/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.motordriver;

import java.io.File;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import javax.inject.Inject;
import us.hebi.gui.lib.ahb;
import us.hebi.gui.lib.aib;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.bcf;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.views.scope.dialogs.BasicFxmlDialog;

public class SaveMotorDriverXmlDialog
extends BasicFxmlDialog {
    @FXML
    private ToggleButton adcOffsetsToggle;
    @FXML
    private ToggleButton encoderOffsetsToggle;
    @FXML
    private Button saveButton;
    @Inject
    bcf fileChooser;
    @Inject
    azz notificationService;

    public SaveMotorDriverXmlDialog() {
        super("savemotordriverxml.fxml");
    }

    @FXML
    void initialize() {
        bgt.a((Property)this.adcOffsetsToggle.selectedProperty(), this.properties.getBoolean("SAVE_ADC_OFFSETS", false));
        bgt.a((Property)this.encoderOffsetsToggle.selectedProperty(), this.properties.getBoolean("SAVE_ENCODER_OFFSETS", false));
    }

    public void setContent(aib aib2) {
        this.saveButton.setOnAction(actionEvent -> {
            File file = this.fileChooser.g(bgt.a(actionEvent));
            if (file == null) {
                return;
            }
            if (!this.adcOffsetsToggle.isSelected()) {
                aib2.setBoardCalibration(null);
            }
            if (!this.encoderOffsetsToggle.isSelected()) {
                Optional.ofNullable(aib2.getEncoders().getEncoderA1()).ifPresent(ahj2 -> ahj2.setCalibrationOffset(null));
                Optional.ofNullable(aib2.getEncoders().getEncoderA2()).ifPresent(ahj2 -> ahj2.setCalibrationOffset(null));
                Optional.ofNullable(aib2.getEncoders().getEncoderB1()).ifPresent(ahj2 -> ahj2.setCalibrationOffset(null));
                Optional.ofNullable(aib2.getEncoders().getEncoderB2()).ifPresent(ahj2 -> ahj2.setCalibrationOffset(null));
            }
            try {
                new ahb().writeXml(aib2, file);
                return;
            }
            catch (Exception exception) {
                this.notificationService.f(exception);
                return;
            }
        });
    }
}

