/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.amc;
import us.hebi.gui.lib.atn;
import us.hebi.gui.lib.bbn;
import us.hebi.gui.lib.bbo;
import us.hebi.gui.lib.bbp;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.beb;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.na;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class AdcCalibrationDialog
extends CalibrationDialog<bbo> {
    ReadOnlyObjectProperty<amc> controlStrategy;
    DoubleBinding baseOffset;
    DoubleBinding sampleRange;
    DoubleBinding numSamples;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate ADC offsets");
        List<amc> list = Arrays.stream(amc.values()).filter(amc2 -> amc2 != amc.a).toList();
        this.controlStrategy = this.addEnumParameter("Control strategy", list, amc.b, "The strategy that the adc should be calibrated in. We recommend using 'Off'. The strategy will not be reset afterwards.");
        this.baseOffset = this.addDoubleParameter("Base offset", 38.0, "center base");
        this.sampleRange = this.addDoubleParameter("Sample range", 4.0, "searches base offset +/- sample range");
        this.numSamples = this.addDoubleParameter("# Samples", 200.0, "number of samples");
    }

    @Override
    protected void fillResultGrid(bbo bbo2) {
        this.addResult("I a", bbo2.a);
        this.addResult("I b", bbo2.b);
        this.addResult("I c", bbo2.c);
        this.addResult("I bus", bbo2.d);
    }

    private void addResult(String string, bbp bbp2) {
        this.addResult(string, atn.c(bbp2.h()[0]), this.getComment(bbp2));
    }

    private String getComment(bbp bbp2) {
        if (!bbp2.aN()) {
            return "Bad fit: " + bbp2.dl();
        }
        return "Ok";
    }

    @Override
    protected Parent renderResult(bbo bbo2) {
        XYChart xYChart = bdc.c();
        xYChart.setTitle("Phase Current");
        xYChart.getXAxis().setName("Offset");
        xYChart.getYAxis().setName("Current");
        xYChart.getYAxis().setUnit("A");
        DataSet dataSet = AdcCalibrationDialog.wrap("A", bbo2.a);
        DataSet dataSet2 = AdcCalibrationDialog.wrap("B", bbo2.b);
        DataSet dataSet3 = AdcCalibrationDialog.wrap("C", bbo2.c);
        xYChart.getDatasets().addAll((Object[])new DataSet[]{dataSet, dataSet2, dataSet3});
        bdc.a(xYChart, "A", bbo2.Q);
        bdc.a(xYChart, "B", bbo2.R);
        bdc.a(xYChart, "C", bbo2.S);
        bdc.a(xYChart);
        XYChart xYChart2 = bdc.c();
        xYChart2.setTitle("Bus Current");
        xYChart2.getXAxis().setName("Offset");
        xYChart2.getYAxis().setName("Current");
        xYChart2.getYAxis().setUnit("A");
        DataSet dataSet4 = AdcCalibrationDialog.wrap("Bus", bbo2.d);
        xYChart2.getDatasets().add((Object)dataSet4);
        bdc.a(xYChart2, null, bbo2.T);
        bdc.a(xYChart2);
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(xYChart);
        calibrationResultDialog.setSecondaryChart(xYChart2);
        calibrationResultDialog.addResult("Offset A", bbo2.a.h()[0], this.getComment(bbo2.a));
        calibrationResultDialog.addResult("Offset B", bbo2.b.h()[0], this.getComment(bbo2.b));
        calibrationResultDialog.addResult("Offset C", bbo2.c.h()[0], this.getComment(bbo2.c));
        calibrationResultDialog.addResult("Offset Bus", bbo2.d.h()[0], this.getComment(bbo2.d));
        return calibrationResultDialog;
    }

    private static DataSet wrap(String string, bbp bbp2) {
        return new beb(string, bbp2::getNumSamples, bbp2::c, bbp2::d).addStyleClasses(new String[]{bek.c.D()});
    }

    private static DataSet wrapCoeffs(bbp bbp2) {
        na na2 = new na(100);
        na na3 = new na(100);
        bbp2.h();
        return new beb("coeffs", na2, na3).addStyleClasses(new String[]{bek.c.D()});
    }

    @Override
    protected Callable<bbo> createTask(ald ald2) {
        bbn bbn2 = new bbn(ald2, (amc)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue());
        AdcCalibrationDialog adcCalibrationDialog = this;
        new bbn(ald2, (amc)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue()).a = adcCalibrationDialog;
        return bbn2;
    }
}

