/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import java.util.concurrent.ExecutorService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javax.inject.Inject;
import lombok.Generated;
import us.hebi.gui.lib.amq;
import us.hebi.gui.lib.axl;
import us.hebi.gui.lib.axs;
import us.hebi.gui.lib.aye;
import us.hebi.gui.lib.bac;
import us.hebi.gui.lib.bai;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bgv;
import us.hebi.gui.lib.bhb;
import us.hebi.gui.lib.bjf;

public class UpdateItem {
    @FXML
    protected Text deviceName;
    @FXML
    protected Text currentText;
    @FXML
    protected Text updateText;
    @FXML
    protected Button updateBtn;
    @FXML
    protected ProgressBar progressBar;
    private final Pane content;
    private DoubleProperty numActiveTasks;
    private bai updateInfo;
    private aye device;
    private BooleanProperty hasUpdated = new SimpleBooleanProperty(false);
    @Inject
    private bac bootloaderService;
    @Inject
    private ExecutorService executorService;

    public UpdateItem(bai bai2, DoubleProperty doubleProperty) {
        this.content = (Pane)bgv.a(this, "updateitem.fxml");
        this.numActiveTasks = doubleProperty;
        this.updateInfo = bai2;
        this.device = bai2.device;
        this.deviceName.textProperty().bind((ObservableValue)this.device.a);
        this.updateBtn.setOnAction(this::update);
        this.updateBtn.visibleProperty().bind((ObservableValue)this.hasUpdated.not());
        this.updateBtn.managedProperty().bind((ObservableValue)this.updateBtn.visibleProperty());
        Object[] objectArray = new Object[1];
        axs axs2 = bai2.device.getInfo();
        axl axl2 = axs2.a;
        objectArray[0] = axl2.a() == amq.c ? axl2.p() : "N/A";
        UpdateItem.setText(this.currentText, "Current: %s", objectArray);
        UpdateItem.setText(this.updateText, "Update to: %s", bai2.C());
        this.progressBar.setVisible(false);
    }

    public void update(ActionEvent actionEvent) {
        if (this.hasUpdated.get()) {
            return;
        }
        this.hasUpdated.set(true);
        Task<Boolean> task = this.bootloaderService.createAutoUpdateTask(this.device, bjf.d);
        Runnable runnable = () -> bhb.b(this.device.a());
        bgt.a(task, bl2 -> {
            this.executorService.submit(runnable);
            UpdateItem.setText(this.updateText, "Update Finished", new Object[0]);
            UpdateItem.setText(this.currentText, "Current: %s", this.updateInfo.C());
            this.progressBar.setVisible(false);
            this.numActiveTasks.setValue((Number)(this.numActiveTasks.get() - 1.0));
        }, throwable -> {
            UpdateItem.setText(this.updateText, "Update failed: %s", throwable.getLocalizedMessage());
            this.hasUpdated.set(false);
            this.progressBar.setVisible(false);
            this.numActiveTasks.setValue((Number)(this.numActiveTasks.get() - 1.0));
        });
        this.numActiveTasks.setValue((Number)(this.numActiveTasks.get() + 1.0));
        this.executorService.submit((Runnable)task);
        this.updateText.textProperty().bind((ObservableValue)task.messageProperty());
        this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        this.progressBar.setVisible(true);
    }

    protected static void setText(Text text, String string, Object ... objectArray) {
        if (text.textProperty().isBound()) {
            text.textProperty().unbind();
        }
        text.setText(String.format(string, objectArray));
    }

    @Generated
    public Pane getContent() {
        return this.content;
    }
}

