/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javax.inject.Inject;
import us.hebi.gui.controls.Css;
import us.hebi.gui.controls.buttons.HActionButton;
import us.hebi.gui.lib.aye;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.bbc;
import us.hebi.gui.lib.bcy;
import us.hebi.gui.lib.beh;
import us.hebi.gui.lib.ben;
import us.hebi.gui.lib.beo;
import us.hebi.gui.lib.bgt;

public class MonitoringCustomController {
    @FXML
    private Parent root;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button reloadFilesBtn;
    private static final int NUM_COLS = 4;
    @Inject
    bcy plottingService;
    @Inject
    bbc selectorService;
    @Inject
    beo customChartDirectory;

    private List<Node> createButtonsFromCustomXml() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.customChartDirectory.forEachXml(ber2 -> {
            HActionButton hActionButton = Css.addClass(new HActionButton(), "btn-PlotButton");
            hActionButton.setText(ber2.getTitle());
            Supplier<beh> supplier = ben.a(ber2);
            hActionButton.setOnAction(this.plottingService.a((List<aye>)this.selectorService.getSelectedModules(), ber2.getTitle(), supplier));
            arrayList.add((Node)hActionButton);
        }, (path, string) -> {
            HActionButton hActionButton = Css.addClass(new HActionButton(), "btn-PlotButton");
            hActionButton.pseudoClassStateChanged(Css.CLASS_INVALID, true);
            hActionButton.setText(path.getFileName().toString());
            hActionButton.setOnAction(actionEvent -> azy.a(string, bgt.a(actionEvent)));
            arrayList.add((Node)hActionButton);
        });
        return arrayList;
    }

    private void layoutButtonsOnGrid(List<Node> list) {
        int n2 = 0;
        this.gridPane.getChildren().clear();
        for (Node node : list) {
            this.gridPane.add(node, MonitoringCustomController.getRow(n2), MonitoringCustomController.getCol(n2));
            GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
            ++n2;
        }
    }

    private void reloadFilesAsync() {
        this.reloadFilesBtn.setDisable(true);
        this.gridPane.getChildren().clear();
        ((CompletableFuture)CompletableFuture.supplyAsync(this::createButtonsFromCustomXml).thenAcceptAsync(this::layoutButtonsOnGrid, bgt.c)).thenRun(() -> this.reloadFilesBtn.setDisable(false));
    }

    @FXML
    void initialize() {
        this.gridPane.disableProperty().bind((ObservableValue)this.selectorService.selectionEmpty());
        this.customChartDirectory.selectedDirectoryProperty().addListener(observable -> this.reloadFilesAsync());
        this.reloadFilesBtn.setOnAction(actionEvent -> this.reloadFilesAsync());
        this.reloadFilesAsync();
    }

    private static int getRow(int n2) {
        return n2 % 4;
    }

    private static int getCol(int n2) {
        return n2 / 4;
    }
}

