/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components;

import java.io.File;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Mesh;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.b;
import us.hebi.gui.lib.adv;
import us.hebi.gui.lib.auu;
import us.hebi.gui.lib.avw;
import us.hebi.gui.lib.avx;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.awr;
import us.hebi.gui.lib.awu;
import us.hebi.gui.lib.ayt;
import us.hebi.gui.lib.azc;
import us.hebi.gui.lib.azg;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azo;
import us.hebi.gui.lib.azq;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.bge;
import us.hebi.gui.lib.bgf;
import us.hebi.gui.lib.bgh;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bjq;
import us.hebi.gui.lib.bqc;
import us.hebi.gui.lib.bqd;
import us.hebi.gui.lib.bsa;
import us.hebi.gui.lib.bvb;
import us.hebi.gui.lib.cht;
import us.hebi.gui.lib.nc;
import us.hebi.gui.lib.pf;
import us.hebi.gui.views.maps.EncoderState;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsAppState$View;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.maps.ScanningState;
import us.hebi.gui.views.scope.components.ParseUtils;

public class ScanningController
extends bge {
    @FXML
    private ToggleButton pauseToggle;
    @FXML
    private Pane pauseArea;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane pane3d;
    @FXML
    private TextField resolutionField;
    @FXML
    private TextField distanceField;
    @FXML
    private Button startBtn;
    @FXML
    private Button cancelBtn;
    @FXML
    private Button restartBtn;
    @FXML
    private Button repeatBtn;
    @FXML
    private Button completeBtn;
    @FXML
    private Button backBtn;
    azi coverageImg;
    avw coverageGrid = new avw();
    awr mappedSurface = null;
    @Inject
    avx maps;
    @Inject
    MapsAppState state;
    @Inject
    EncoderState encoderState;
    @Inject
    ScanningState scanState;
    @Inject
    azz notifications;
    final adv logWriter = adv.a();

    @Override
    public void initializeFx() {
        this.resolutionField.textProperty().bindBidirectional((Property)this.state.getString("scanResolution", "10"));
        this.distanceField.textProperty().bindBidirectional((Property)this.state.getString("scanMaxDistance", "30"));
        this.state.addUnitFields(this.resolutionField, this.distanceField);
        bgt.b(() -> this.pauseArea.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.pauseToggle.selectedProperty().get()), new Observable[]{this.pauseToggle.selectedProperty()});
        this.pauseToggle.selectedProperty().bindBidirectional((Property)this.scanState.pausedProperty());
        SimpleObjectProperty simpleObjectProperty = new SimpleObjectProperty();
        azc azc2 = new azc();
        azo azo2 = MapsCss.createEndEffectorAxes3d();
        azo azo3 = new azo(new Node[]{azo2, azc2.e});
        azo azo4 = new azo(new Node[]{azo3, azl.a.a()});
        new azq(new Node[]{azo4}).a().a(this.pane3d);
        ImageView imageView = MapsCss.createView2d(this.pane2d);
        this.maps.b(arg_0 -> this.lambda$initializeFx$1((Property)simpleObjectProperty, azc2, azo3, imageView, arg_0));
        this.maps.d(avy2 -> {
            double d2;
            avy2.cx = d2 = this.coverageGrid.cx;
            this.scanState.setInContact(avy2.isInContact());
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                if (this.state.getShowLiveMap()) {
                    this.mappedSurface.a((avy)avy2, this.state.getProbeWidth());
                }
                if (this.scanState.isActive().booleanValue() && this.scanState.isInContact()) {
                    boolean bl2;
                    avy avy3 = avy2;
                    avw avw2 = this.coverageGrid;
                    if (avw2.aQ && (ayt.a(avy3.o, avw2.x) || ayt.a(avy3.p, avw2.y))) {
                        avw2.x = avy3.o - (float)avw2.cs;
                        avw2.a.a(avw2.x);
                        avw2.y = avy3.p - (float)avw2.cu;
                        avw2.b.a(avw2.y);
                        avw2.c.a(avy3.A);
                        nc nc2 = avw2.a;
                        int n2 = nc2.ag - 1;
                        int n3 = avw2.r(n2);
                        int n4 = avw2.s(n2);
                        if (avw2.a.a(n3, n4) || (double)avy3.A > avw2.cx) {
                            bl2 = false;
                        } else {
                            avw2.a.f(n3, n4);
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (bl2 && this.state.getShowLiveMap()) {
                        this.redrawCoverage();
                    }
                }
            }
        });
        this.maps.c(bjq2 -> {
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                azo2.b((bjq)bjq2);
            }
        });
        ValidationSupport validationSupport = bgh.a();
        bgh.a(validationSupport, this.resolutionField);
        bgh.a(validationSupport, this.distanceField);
        bgt.b(this::updateGrid, new Observable[]{this.resolutionField.textProperty(), this.distanceField.textProperty()});
        this.backBtn.setOnAction(this.state::previousView);
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(false);
        this.scanState.pausedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$initializeFx$4((BooleanProperty)simpleBooleanProperty, arg_0, arg_1, arg_2));
        this.encoderState.encoderStartMessageProperty().addListener((observableValue, bqc2, bqc3) -> this.scanState.reset());
        this.startBtn.setOnAction(bgt.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.mappedSurface == null) {
                this.notifications.i("Scan cannot be started without a map.");
                return;
            }
            Optional.ofNullable(this.encoderState.getEncoderStartMessage()).ifPresent(bqc2 -> {
                bqc bqc3 = bqc2;
                avx avx2 = this.maps;
                avx2.b.c().a().a(bqc3);
                avx avx3 = avx2;
                avx3.a(avx3.b, null);
            });
            this.startLogging();
            this.scanState.startScan();
        })));
        this.cancelBtn.setOnAction(bgt.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Cancelling this scan will irrecoverably delete data. Do you want to delete this scan?")) {
                this.reset();
                this.cancelLogging();
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.restartBtn.setOnAction(bgt.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Restarting will discard the current scan and begin a new scan on this same surface. Do you want to restart")) {
                this.reset();
                this.cancelLogging();
                this.maps.a(bqd.b);
            }
        })));
        this.repeatBtn.setOnAction(bgt.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Repeating will complete the current scan and begin a new scan on this same surface. Do you want to repeat?")) {
                this.reset();
                this.stopLogging().ifPresent(file -> azy.a(file, bgt.a(actionEvent)));
                this.maps.a(bqd.b);
            }
        })));
        this.completeBtn.setOnAction(bgt.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Completing a scan will finish this scan and let you set up a new surface. Do you want to complete this scan?")) {
                this.reset();
                this.maps.a(bqd.d);
                this.stopLogging().ifPresent(file -> azy.a(file, bgt.a(actionEvent)));
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.updateGrid();
    }

    private void reset() {
        this.scanState.reset();
        this.coverageGrid.aN();
        this.redrawCoverage();
    }

    private void updateGrid() {
        Double d2 = ParseUtils.tryParseFiniteDouble(this.resolutionField);
        Double d3 = ParseUtils.tryParseFiniteDouble(this.distanceField);
        if (this.mappedSurface != null && d2 != null && d2 > 0.0) {
            this.mappedSurface.l(((auu)auu.a).e(d2));
        }
        if (d2 != null && d3 != null && d2 > 0.0 && d3 > 0.0) {
            boolean bl2;
            boolean bl3;
            double d4 = ((auu)auu.a).e(d2);
            avw avw2 = this.coverageGrid;
            if (avw2.cw != d4) {
                avw2.cw = d4;
                avw2.aM();
                bl3 = true;
            } else {
                bl3 = false;
            }
            boolean bl4 = false | bl3;
            d4 = ((auu)auu.a).e(d3);
            avw2 = this.coverageGrid;
            if (avw2.cx != d4) {
                avw2.cx = d4;
                avw2.aM();
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (bl4 | bl2) {
                this.redrawCoverage();
            }
        }
    }

    private void redrawCoverage() {
        pf pf2 = this.coverageGrid.a;
        if (pf2.j() == 0) {
            return;
        }
        if (this.coverageImg == null || this.coverageImg.cR != pf2.aC || this.coverageImg.cS != pf2.aB) {
            this.coverageImg = new azi((double)pf2.aC, (double)pf2.aB);
        }
        int n2 = azi.a(Color.WHITE);
        int n3 = azi.a(b.c);
        for (int i2 = 0; i2 < pf2.aC; ++i2) {
            for (int i3 = 0; i3 < pf2.aB; ++i3) {
                int n4 = pf2.a(i3, i2) ? n3 : n2;
                this.coverageImg.e(i2, i3, n4);
            }
        }
        avw avw2 = this.coverageGrid;
        avw avw3 = avw2;
        avw3 = this.coverageGrid;
        this.mappedSurface.a((Image)this.coverageImg.a().a, this.coverageGrid.cs, this.coverageGrid.cu, (double)avw2.K() * avw3.cw, (double)avw3.J() * avw3.cw);
    }

    private void startLogging() {
        try {
            UUID uUID = UUID.randomUUID();
            ScanningController scanningController = this;
            bvb bvb2 = scanningController.logWriter.a();
            bvb2.a("MAPS Feedback Log").a().a(bgf.b.ai).b(bgf.b.ah);
            this.logWriter.a(new File(this.state.getLogDirectory(), String.valueOf(uUID) + ".mapslog"), bvb2);
            this.maps.a(this.logWriter);
            avx avx2 = this.maps;
            bsa bsa2 = bsa.a();
            bsa2.c().a().d().a(true);
            avx2.a(bsa2, null);
            return;
        }
        catch (Exception exception) {
            this.notifications.f(exception);
            return;
        }
    }

    private Optional<File> stopLogging() {
        try {
            this.maps.a((adv)null);
            return Optional.ofNullable(this.logWriter.b());
        }
        catch (Exception exception) {
            this.notifications.f(exception);
            return Optional.empty();
        }
    }

    private void cancelLogging() {
        this.stopLogging().map(File::delete).ifPresent(bl2 -> cht.c(bl2, "Failed to delete log file"));
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }

    @Generated
    public EncoderState getEncoderState() {
        return this.encoderState;
    }

    @Generated
    public ScanningState getScanState() {
        return this.scanState;
    }

    private /* synthetic */ void lambda$initializeFx$4(BooleanProperty booleanProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (!booleanProperty.get()) {
            this.maps.a(bl3 != false ? null : this.logWriter);
            this.maps.a(bl3 != false ? bqd.e : bqd.f);
        }
    }

    private /* synthetic */ void lambda$initializeFx$1(Property property, azc azc2, azo azo2, ImageView imageView, awu awu2) {
        awu awu3 = awu2;
        avw avw2 = this.coverageGrid;
        this.coverageGrid.cs = awu3.cS;
        avw2.cu = awu3.cT;
        avw2.ct = awu3.cU;
        avw2.cv = awu3.cV;
        avw avw3 = avw2;
        avw3.y = Float.NaN;
        avw3.x = Float.NaN;
        avw2.aQ = true;
        avw2.aN();
        avw2.aM();
        property.setValue((Object)awu2);
        azc2.a((Mesh)awu2.a());
        bgt.a((Node)azo2, azg.a((Mesh)awu2.a()));
        this.mappedSurface = awr.a(awu2, 1000.0, 1000.0);
        azc2.e.diffuseMapProperty().bind(this.mappedSurface.a);
        azc2.f.diffuseMapProperty().bind(this.mappedSurface.b);
        imageView.imageProperty().bind(this.mappedSurface.a);
        this.updateGrid();
        this.scanState.reset();
        this.stopLogging();
    }
}

