/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import us.hebi.gui.lib.ah;
import us.hebi.gui.lib.atz;
import us.hebi.gui.lib.aul;
import us.hebi.gui.lib.auu;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.bjm;
import us.hebi.gui.lib.bjq;
import us.hebi.gui.lib.bjs;
import us.hebi.gui.lib.bjt;
import us.hebi.gui.lib.bjw;
import us.hebi.gui.lib.bjy;
import us.hebi.gui.lib.bka;
import us.hebi.gui.lib.bkd;
import us.hebi.gui.lib.ble;
import us.hebi.gui.lib.blf;
import us.hebi.gui.lib.blg;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.lib.na;
import us.hebi.gui.lib.nd;
import us.hebi.gui.lib.ps;
import us.hebi.gui.lib.rc;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class XyzLogData {
    private blg treeFK;
    private ble FK;
    private blf numericalJacobian;
    private bkd staticConnections;
    private int numEntries = 0;
    private int numDevices = 0;
    private na time;
    private na[] position;
    private na[] positionCmd;
    private na[] velocity;
    private na[] velocityCmd;
    private na[] gyroX;
    private na[] gyroY;
    private na[] gyroZ;
    public na[] centerOfMass;
    public na[] xyzPosition;
    public na[] xyzPositionCmd;
    public na xyzPositionErrorMagnitude;
    public na[] xyzVelocity;
    public na[] xyzVelocityCmd;
    public na xyzVelocityMagnitude;
    public na xyzVelocityMagnitudeCmd;
    public na[] imuVelocity;
    private double[] tmpPos;
    private double[] tmpPosCmd;
    private double[] tmpVel;
    private double[] tmpVelCmd;
    public static final aul SAME_INDEX = n2 -> n2;
    private aul indexMap = SAME_INDEX;
    static final double XYZ_SCALE = auu.a.f(1.0);

    public void setLogData(HebiLogFeedback hebiLogFeedback) {
        this.time = hebiLogFeedback.time;
        this.position = hebiLogFeedback.position;
        this.positionCmd = hebiLogFeedback.positionCmd;
        this.velocity = hebiLogFeedback.velocity;
        this.velocityCmd = hebiLogFeedback.velocityCmd;
        this.gyroX = hebiLogFeedback.gyroX;
        this.gyroY = hebiLogFeedback.gyroY;
        this.gyroZ = hebiLogFeedback.gyroZ;
        this.numEntries = hebiLogFeedback.time.size();
        this.numDevices = hebiLogFeedback.numJoints;
        this.update();
    }

    public void setKinematics(bka bka2, aul aul2) {
        this.treeFK = new blg(bka2);
        bjy bjy2 = bka2.a(true);
        this.FK = new ble(bjy2);
        this.numericalJacobian = new blf(this.FK);
        bka bka3 = bka2;
        bkd bkd2 = new bkd(bka3.S());
        bjq bjq2 = bjq.d();
        nd nd2 = new nd(bka3.R());
        for (int i2 = 0; i2 < bka3.S(); ++i2) {
            nd2.clear();
            boolean bl2 = false;
            int n2 = bka3.ak.indexOf(bka3.N.get(i2));
            block1: for (int i3 = n2 + 1; i3 < bka3.a.size() && !bl2; ++i3) {
                Object object;
                if (bka3.a.l(i3) == n2) {
                    object = bka3.ak.get(i3);
                    if (object instanceof bjw) {
                        bl2 = true;
                        bkd2.bj[i2] = bka3.N.indexOf((bjw)object);
                    } else {
                        nd2.d(i3);
                        n2 = i3;
                    }
                }
                int n3 = i2;
                object = bkd2.a[n3];
                bjq2.c();
                int n4 = 0;
                while (true) {
                    nd nd3 = nd2;
                    if (n4 >= nd3.ag) continue block1;
                    int n5 = nd2.l(n4);
                    bjq bjq3 = bka3.ak.get(n5).h();
                    bjs.a(bjq2, bjq3, (bjq)object);
                    bjq2.c((bjq)object);
                    ++n4;
                }
            }
        }
        this.staticConnections = bkd2;
        this.indexMap = aul2 == null ? SAME_INDEX : aul2;
        this.update();
    }

    public boolean hasValidCombination() {
        return this.FK != null && this.numEntries > 0 && this.FK.c.numJoints == this.numDevices;
    }

    public void update() {
        if (!this.hasValidCombination()) {
            return;
        }
        this.resize();
        bjt bjt2 = bjt.d();
        bjt bjt3 = bjt.d();
        ps ps2 = new ps(0, 0);
        ps ps3 = new ps(0, 0);
        bjq bjq2 = bjq.d();
        bjm bjm2 = new bjm();
        for (int i2 = 0; i2 < this.numEntries; ++i2) {
            this.fillTmpArrays(i2);
            bjt bjt4 = bjt3;
            double[] dArray = this.tmpPos;
            this.treeFK.a(this.tmpPos).a(bjt4);
            bjt3.a(XYZ_SCALE);
            this.centerOfMass[0].c(bjt3.a1);
            this.centerOfMass[1].c(bjt3.a2);
            this.centerOfMass[2].c(bjt3.a3);
            this.FK.a(this.tmpPos, bjq2);
            this.xyzPosition[0].c(XYZ_SCALE * bjq2.ea);
            this.xyzPosition[1].c(XYZ_SCALE * bjq2.ec);
            this.xyzPosition[2].c(XYZ_SCALE * bjq2.eg);
            this.FK.a(this.tmpPosCmd, bjq2);
            this.xyzPositionCmd[0].c(XYZ_SCALE * bjq2.ea);
            this.xyzPositionCmd[1].c(XYZ_SCALE * bjq2.ec);
            this.xyzPositionCmd[2].c(XYZ_SCALE * bjq2.eg);
            double d2 = this.xyzPositionCmd[0].a(i2) - this.xyzPosition[0].a(i2);
            double d3 = this.xyzPositionCmd[1].a(i2) - this.xyzPosition[1].a(i2);
            double d4 = this.xyzPositionCmd[2].a(i2) - this.xyzPosition[2].a(i2);
            double d5 = d2;
            double d6 = d3;
            double d7 = d4;
            this.xyzPositionErrorMagnitude.c(Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7));
            this.numericalJacobian.a(this.tmpPos, bjm2);
            ps2.a(this.tmpVelCmd.length, 1, true, this.tmpVel);
            rc.a(bjm2, ps2, ps3);
            double d8 = XYZ_SCALE * ps3.h[0];
            double d9 = XYZ_SCALE * ps3.h[1];
            double d10 = XYZ_SCALE * ps3.h[2];
            this.xyzVelocity[0].c(d8);
            this.xyzVelocity[1].c(d9);
            this.xyzVelocity[2].c(d10);
            double d11 = d8;
            double d12 = d9;
            double d13 = d10;
            this.xyzVelocityMagnitude.c(Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13));
            this.numericalJacobian.a(this.tmpPosCmd, bjm2);
            ps2.a(this.tmpVelCmd.length, 1, true, this.tmpVelCmd);
            rc.a(bjm2, ps2, ps3);
            d8 = XYZ_SCALE * ps3.h[0];
            d9 = XYZ_SCALE * ps3.h[1];
            d10 = XYZ_SCALE * ps3.h[2];
            this.xyzVelocityCmd[0].c(d8);
            this.xyzVelocityCmd[1].c(d9);
            this.xyzVelocityCmd[2].c(d10);
            double d14 = d8;
            double d15 = d9;
            double d16 = d10;
            this.xyzVelocityMagnitudeCmd.c(Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16));
            for (int i3 = 0; i3 < this.numDevices; ++i3) {
                double d17 = Double.NaN;
                int n2 = i3;
                Object object = this.staticConnections;
                if (n2 < ((bkd)object).bj.length && ((bkd)object).bj[n2] >= 0) {
                    n2 = i3;
                    int n3 = this.staticConnections.bj[n2];
                    bjt2.a1 = this.gyroX[n3].a(i2);
                    bjt2.a2 = this.gyroY[n3].a(i2);
                    bjt2.a3 = this.gyroZ[n3].a(i2);
                    int n4 = i3;
                    bjt4 = bjt3;
                    bjt bjt5 = bjt2;
                    object = this.staticConnections.a[n4];
                    bjt4.a1 = ((bjq)object).u * bjt5.a1 + ((bjq)object).w * bjt5.a2 + ((bjq)object).ed * bjt5.a3;
                    bjt4.a2 = ((bjq)object).v * bjt5.a1 + ((bjq)object).x * bjt5.a2 + ((bjq)object).ee * bjt5.a3;
                    bjt4.a3 = ((bjq)object).dZ * bjt5.a1 + ((bjq)object).eb * bjt5.a2 + ((bjq)object).ef * bjt5.a3;
                    d17 = bjt3.a3 - this.gyroZ[i3].a(i2);
                }
                this.imuVelocity[i3].c(d17);
            }
        }
    }

    public void getCharts(ChartList chartList) {
        if (!this.hasValidCombination()) {
            return;
        }
        chartList.setTime(this.time).setTraceType(bek.a).addXyzCommandChart(ChartCategory.Cartesian, "Position", "mm", -50.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addXyzErrorChart(ChartCategory.Cartesian, "Position Error", "mm", 0.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addSingleTrace(ChartCategory.Cartesian, "Position Error Magnitude", "mm", 0.0, 10.0, this.xyzPositionErrorMagnitude).addXyzCommandChart(ChartCategory.Cartesian, "Velocity", "mm/s", -50.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addXyzErrorChart(ChartCategory.Cartesian, "Velocity Error", "mm/s", 0.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addTimeTraces((Supplier<String>)ChartCategory.Cartesian, "Velocity Magnitude", "mm/s", 0.0, 500.0, new na[]{this.xyzVelocityMagnitudeCmd, this.xyzVelocityMagnitude}, renderer -> {
            bdc.a(renderer, 0, "xyz velocity command", "trace-dashed", "color-primary-muted");
            bdc.a(renderer, 1, "xyz velocity feedback", "trace-solid", "color-primary");
        }).addXyzChart(ChartCategory.Cartesian, "Center of Mass", "mm", -50.0, 50.0, this.centerOfMass).addCommandChart(ChartCategory.Encoders, "Velocity IMU", "rad/s", -5.0, 5.0, this.imuVelocity, this.velocity).addErrorChart(ChartCategory.Encoders, "Velocity IMU Error", "rad/s", 0.0, 0.05, this.imuVelocity, this.velocity);
    }

    public static aul createIndexMap(List<String> list, List<String> list2) {
        bpd.a(list.size() == list2.size(), "source names do not match hrdf names");
        if (Objects.equals(list, list2)) {
            return SAME_INDEX;
        }
        ToIntFunction<String> toIntFunction = string -> {
            String string2 = string;
            if (ah.b(string2).contains("*") || string2.contains("?")) {
                Pattern pattern = atz.a(string, true);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (!pattern.matcher((CharSequence)list.get(i2)).matches()) continue;
                    return i2;
                }
            } else {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    if (!string.equalsIgnoreCase((String)list.get(i3))) continue;
                    return i3;
                }
            }
            throw new IllegalArgumentException("Source does not contain device name: " + string);
        };
        int n3 = list2.size();
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = toIntFunction.applyAsInt(list2.get(i2));
        }
        return n2 -> nArray[n2];
    }

    private void fillTmpArrays(int n2) {
        for (int i2 = 0; i2 < this.numDevices; ++i2) {
            int n3 = this.indexMap.apply(i2);
            this.tmpPos[i2] = this.position[n3].a(n2);
            this.tmpPosCmd[i2] = this.positionCmd[n3].a(n2);
            this.tmpVel[i2] = this.velocity[n3].a(n2);
            this.tmpVelCmd[i2] = this.velocityCmd[n3].a(n2);
        }
    }

    private void resize() {
        this.centerOfMass = TDoubleArrayListRegistry.resizeMultiple(this.centerOfMass, 3, this.numEntries);
        this.xyzPosition = TDoubleArrayListRegistry.resizeMultiple(this.xyzPosition, 3, this.numEntries);
        this.xyzPositionCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzPositionCmd, 3, this.numEntries);
        this.xyzPositionErrorMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzPositionErrorMagnitude, this.numEntries);
        this.xyzVelocity = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocity, 3, this.numEntries);
        this.xyzVelocityCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocityCmd, 3, this.numEntries);
        this.xyzVelocityMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitude, this.numEntries);
        this.xyzVelocityMagnitudeCmd = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitudeCmd, this.numEntries);
        this.imuVelocity = TDoubleArrayListRegistry.resizeMultiple(this.imuVelocity, this.numDevices, this.numEntries);
        this.tmpPos = new double[this.position.length];
        this.tmpPosCmd = new double[this.position.length];
        this.tmpVel = new double[this.position.length];
        this.tmpVelCmd = new double[this.position.length];
    }
}

