/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.scene3d.camera;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Point3D;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import us.hebi.gui.lib.ah;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.ayp;
import us.hebi.gui.lib.bgv;

public class ViewCube
extends VBox
implements Initializable {
    @FXML
    private Button bottomBtn;
    @FXML
    private Button isoCenterBtn;
    @FXML
    private Button leftBtn;
    @FXML
    private Button resetRotationBtn;
    @FXML
    private Button rightBtn;
    @FXML
    private Button rotateDownBtn;
    @FXML
    private Button rotateLeftBtn;
    @FXML
    private Button rotateRightBtn;
    @FXML
    private Button rotateUpBtn;
    @FXML
    private Button topBtn;
    @FXML
    private GridPane viewGrid;
    @FXML
    private Button zoomInBtn;
    @FXML
    private Button zoomOutBtn;
    @FXML
    private Button resetZoomBtn;
    private ayn camera;
    private double rotationStep = 15.0;
    private double zoomStep = 1.2;

    public ViewCube() {
        bgv.a((Object)this, "viewcube.fxml");
        String string = "viewcube.css";
        ViewCube viewCube = this;
        URL uRL = ((Object)((Object)viewCube)).getClass().getResource(string);
        ah.a(uRL, "Could not find stylesheet %s", (Object)string);
        viewCube.getStylesheets().add((Object)uRL.toExternalForm());
        this.getStyleClass().add((Object)"view-cube");
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.setupViewButtons();
        this.setupZoomButtons();
        this.setupRotationButtons();
    }

    private void setupRotationButtons() {
        this.rotateUpBtn.setOnAction(actionEvent -> this.rotateView(0.0, this.rotationStep));
        this.rotateDownBtn.setOnAction(actionEvent -> this.rotateView(0.0, -this.rotationStep));
        this.rotateLeftBtn.setOnAction(actionEvent -> {
            ViewCube viewCube = this;
            viewCube.rotateView(-viewCube.rotationStep, 0.0);
        });
        this.rotateRightBtn.setOnAction(actionEvent -> {
            ViewCube viewCube = this;
            viewCube.rotateView(viewCube.rotationStep, 0.0);
        });
    }

    private void setupZoomButtons() {
        this.zoomInBtn.setOnAction(actionEvent -> {
            if (this.camera != null) {
                double d2 = this.camera.dh / this.zoomStep;
                this.camera.p(d2);
            }
        });
        this.zoomOutBtn.setOnAction(actionEvent -> {
            if (this.camera != null) {
                double d2 = this.camera.dh * this.zoomStep;
                this.camera.p(d2);
            }
        });
        this.resetZoomBtn.setOnAction(actionEvent -> {
            if (this.camera != null) {
                ayn ayn2 = this.camera;
                ayn2.a(ayp.h);
                ayn2.a = Point3D.ZERO;
                ayn2.b.setX(0.0);
                ayn2.b.setY(0.0);
                ayn2.b.setZ(0.0);
                ayn2.p(800.0);
                ayn2.bc();
            }
        });
    }

    private void setupViewButtons() {
        this.leftBtn.setOnAction(actionEvent -> this.setView(ayp.d));
        this.rightBtn.setOnAction(actionEvent -> this.setView(ayp.e));
        this.topBtn.setOnAction(actionEvent -> this.setView(ayp.f));
        this.bottomBtn.setOnAction(actionEvent -> this.setView(ayp.g));
        this.isoCenterBtn.setOnAction(actionEvent -> this.setView(ayp.h));
        this.resetRotationBtn.setOnAction(actionEvent -> this.setView(ayp.b));
    }

    private void setView(ayp ayp2) {
        if (this.camera != null) {
            this.camera.a(ayp2);
        }
    }

    private void rotateView(double d2, double d3) {
        if (this.camera != null) {
            ayo ayo2 = ayo.a(new Point3D(0.0, 1.0, 0.0), Math.toRadians(d2));
            ayo ayo3 = ayo.a(new Point3D(1.0, 0.0, 0.0), Math.toRadians(d3));
            ayo ayo4 = ayo2.a(ayo3);
            ayn ayn2 = this.camera;
            this.camera.a = ayo4.a(ayn2.a);
            ayn2.bc();
        }
    }

    public void setCamera(ayn ayn2) {
        this.camera = ayn2;
    }

    public void setRotationStep(double d2) {
        this.rotationStep = d2;
    }

    public void setZoomStep(double d2) {
        this.zoomStep = d2;
    }
}

