/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import picocli.CommandLine;
import us.hebi.gui.lib.adk;
import us.hebi.gui.lib.adm;
import us.hebi.gui.lib.ajq;
import us.hebi.gui.lib.akz;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.amc;
import us.hebi.gui.lib.anl;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.apk;
import us.hebi.gui.lib.atp;
import us.hebi.gui.lib.bap;
import us.hebi.gui.lib.bbn;
import us.hebi.gui.lib.bbo;
import us.hebi.gui.lib.bbq;
import us.hebi.gui.lib.bbx;
import us.hebi.gui.lib.bby;
import us.hebi.gui.lib.bcc;
import us.hebi.gui.lib.bfe;
import us.hebi.gui.lib.bfl;
import us.hebi.gui.lib.bfn;
import us.hebi.gui.lib.bfq;
import us.hebi.gui.lib.bfr;
import us.hebi.gui.lib.bhb;
import us.hebi.gui.lib.byk;
import us.hebi.gui.lib.byo;
import us.hebi.gui.lib.bzp;
import us.hebi.gui.lib.cht;

public final class bfk
extends bfe {
    @CommandLine.Parameters(index="0", paramLabel="mode", description={"Chooses the operating mode [calibration, errorlog, getinfo, getfbk, readlog, program]"})
    protected bfn mode;
    @CommandLine.Option(names={"--frequency"}, description={"Sets the frequency [Hz] for modes that poll device data."})
    private double frequency = 10.0;
    @CommandLine.Option(names={"--imu-accel-offset"}, description={"Sets the xyz accelerometer offset after calibration. Expects 3 numbers separated by commas."}, split=",")
    private float[] imuAccelOffsets;
    @CommandLine.Option(names={"--imu-rotation"}, description={"Sets the 3x3 rotation matrix of the IMU after calibration. Expects 9 numbers  separated by commas."}, split=",")
    private float[] imuRotation;
    @CommandLine.Option(names={"--md-motor-adc"}, description={"Runs a calibration procedure and sets motor driver offsets"})
    private boolean mdMotorAdc;
    @CommandLine.Option(names={"--md-encoder-offset"}, description={"Runs a calibration procedure and sets encoder offsets"})
    private boolean mdEncoderOffset;
    @CommandLine.Option(names={"--md-table-index"}, description={"Selects the target calibration table index."})
    private int targetTableIndex = 0;
    @CommandLine.Option(names={"--md-read-encoder-offset-table"}, description={"Reads the current encoder offset table"})
    private boolean mdReadEncoderOffsetTable;
    @CommandLine.Option(names={"--hebilog"}, description={"Loads a .hebilog file and prints the output"})
    private File hebilogFile;
    @CommandLine.Option(names={"--application"}, description={"Application firmware file"})
    private File applicationFile;

    @Override
    protected final void run() throws Exception {
        if (this.frequency < 0.0) {
            throw bfr.a("frequency");
        }
        if (this.mode == bfn.errorlog || this.mode == bfn.getinfo || this.mode == bfn.getfbk) {
            ajq ajq2;
            bfk bfk2 = this;
            ald ald2 = bfk2.b();
            System.out.println("Polling of " + String.valueOf(ald2) + " at " + bfk2.frequency + " Hz");
            bfq bfq2 = new bfq(ald2);
            bfq2.a(bfk2.frequency);
            bzp bzp3 = bfq2.h.c();
            switch (bfk2.mode.ordinal()) {
                case 1: {
                    bzp3.j(true);
                    break;
                }
                case 2: {
                    bzp3.l(true).k(true).a(byo.b).c(true).b(true).a(true).d(true).g(true).e(true).f(true).h(true);
                    break;
                }
                case 3: {
                    bzp3.b(true).a(true).d(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported poll mode: " + String.valueOf((Object)bfk2.mode));
                }
            }
            bfq2.a = ajq2 = (bzp2, l2, bl2) -> {
                switch (this.mode.ordinal()) {
                    case 1: {
                        byk byk2 = bzp2.a;
                        if (byk2.hO()) {
                            System.out.print("[error] ");
                            System.out.println(byk2.T.a(cht.a));
                        }
                        if (byk2.hN()) {
                            System.out.print("[flags] ");
                            System.out.println(byk2.S.a(cht.a));
                        }
                        return;
                    }
                }
                System.out.println(bzp2);
            };
            bfq2.a();
            Runtime.getRuntime().addShutdownHook(new Thread(bfq2::bP));
            while (true) {
                atp.b(100L, TimeUnit.MILLISECONDS);
            }
        }
        if (this.mode == bfn.calibration) {
            if (this.mdMotorAdc) {
                bfk bfk3 = this;
                bfk3.b();
                ald ald3 = bfk3.b();
                System.out.println("Running ADC calibration on " + String.valueOf(ald3));
                new bfq(ald3);
                float cfr_ignored_0 = 4.0f / 200.0f;
                bbo bbo2 = new bbn(ald3, amc.b, 200, 38.0f, 4.0f).a();
                System.out.println("Computed fit coefficients for ADC offsets");
                System.out.println("A:   " + Arrays.toString(bbo2.a.h()));
                System.out.println("B:   " + Arrays.toString(bbo2.b.h()));
                System.out.println("C:   " + Arrays.toString(bbo2.c.h()));
                System.out.println("Bus: " + Arrays.toString(bbo2.d.h()));
                return;
            }
            if (this.mdEncoderOffset) {
                ano ano2;
                bfk bfk4 = this;
                bfk4.b();
                bfk bfk5 = bfk4;
                ald ald4 = bfk4.b();
                System.out.println("Running encoder offset calibration on " + String.valueOf(ald4));
                System.out.println("Make sure the following are set:\n   Motor Driver: [Output Encoder] is set to your configured encoder (e.g. A1)\n   Motor Driver: [Motor Encoder] is set to POSITION_COMMAND\n   Motor Driver: [Controller Mode] is set to FOC\n   Gains:        [Control Strategy] is set to DIRECT_FOC\nPress Enter to continue...\n");
                if (bfk5.verbose) {
                    System.out.println("Requesting current motor encoder configuration");
                }
                try {
                    apk apk2 = akz.a(ald4);
                    ano2 = apk2.a.a().a();
                }
                catch (IOException iOException) {
                    throw bfr.a("Failed to get info message from device", new Object[0]);
                }
                if (bfk5.verbose) {
                    System.out.println("Using motor encoder " + String.valueOf((Object)ano2));
                }
                bcc bcc2 = new bbx(ald4, ano2, 15.0, 2.0, 11, bby.Calibrate).a();
                System.out.println("Fit Coeffs: " + Arrays.toString(bcc2.e.h()));
                return;
            }
            if (this.mdReadEncoderOffsetTable) {
                ano ano3;
                bfk bfk6 = this;
                ald ald5 = bfk6.b();
                bfk bfk7 = bfk6;
                if (bfk6.verbose) {
                    System.out.println("Requesting current motor encoder offsets");
                }
                System.err.println("TODO: currently hardcoded A1 w/ 256 buckets. We need to add more parameters to define the target.");
                bbq bbq2 = new bbq(anl.d);
                new bbq(anl.d).l = ano3 = ano.c;
                bbq2.a(ald5, bzp2 -> {
                    if (this.verbose) {
                        System.out.println(bzp2);
                    }
                }, bzp2 -> {
                    if (this.verbose) {
                        System.out.println(bzp2);
                    }
                });
                System.out.println(Arrays.toString(bbq2.z));
                return;
            }
        }
        if (this.mode == bfn.readlog) {
            bfk bfk8 = this;
            if (!bfk8.c(bfk8.hebilogFile)) {
                throw bfr.a("Invalid '--hebilog' parameter : " + String.valueOf(bfk8.hebilogFile), new Object[0]);
            }
            try (adm adm2 = adk.a(bfk8.hebilogFile);){
                adm2.a(new bfl(bfk8));
                return;
            }
            catch (IOException iOException) {
                throw bfr.a("Failed to read log file. Reason: %s", iOException.getMessage());
            }
        }
        if (this.mode == bfn.program) {
            bfk bfk9 = this;
            if (!bfk9.c(bfk9.applicationFile)) {
                throw bfr.a("Invalid '--application' parameter : " + String.valueOf(this.applicationFile), new Object[0]);
            }
            if (!bhb.a(this.b(), System.out::println)) {
                throw new IllegalStateException("Failed to get into bootloader");
            }
            bap.a(this.b(), this.applicationFile).U();
            System.out.println("Booting into application.");
            bhb.b(this.b());
        }
        super.run();
    }

    @Override
    protected final void g(List<BiConsumer<bzp, Integer>> list) {
        if (this.imuAccelOffsets != null) {
            bfk.c(this.imuAccelOffsets.length == 3, "Accelerometer offset expects 3 values: [x,y,z]. Got %d.", this.imuAccelOffsets.length);
            list.add((bzp2, n2) -> bzp2.a().e().i(true).b(this.imuAccelOffsets));
        }
        if (this.imuRotation != null) {
            bfk.c(this.imuRotation.length == 9, "IMU rotation expects 9 values separated by commas. Got %d. ", this.imuRotation.length);
            list.add((bzp2, n2) -> bzp2.a().e().h(true).a(this.imuRotation));
        }
    }

    @Override
    protected final void w(int n2) {
        if (n2 > 1) {
            bfk.c(this.imuAccelOffsets == null, "--imu-accel-offset only supports single devices", new Object[0]);
            bfk.c(this.imuRotation == null, "--imu-rotation only supports single devices", new Object[0]);
        }
    }

    private ald b() throws bfr {
        List<ald> list = this.c();
        if (list.size() > 1) {
            throw bfr.b();
        }
        return list.get(0);
    }
}

