/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import us.hebi.glue.Buffer6;
import us.hebi.gui.lib.adc;
import us.hebi.gui.lib.add;
import us.hebi.gui.lib.ade;
import us.hebi.gui.lib.adf;
import us.hebi.gui.lib.adg;
import us.hebi.gui.lib.adi;
import us.hebi.gui.lib.adj;
import us.hebi.gui.lib.aky;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.bfr;
import us.hebi.gui.lib.bfs;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.lib.fg;

public final class bfj
implements Callable<Integer> {
    @CommandLine.Option(required=true, names={"--index"}, split=",", description={"Zero based indices of the input log separated by ','"})
    private int[] indices;
    @CommandLine.Option(names={"-i", "--input"}, description={"Path to input .hebilog file. May occur more than once"}, split=",")
    private File[] inputFiles;
    @CommandLine.Option(names={"-o", "--output-dir"}, description={"Output directory. Defaults to the same as the input file"})
    private File outputDir;
    @CommandLine.Option(names={"--suffix"}, description={"Suffix for the resulting output file"}, defaultValue="-filtered")
    private String suffix;
    @CommandLine.Option(names={"--verbose"}, description={"Prints verbose information."})
    protected boolean verbose;
    @CommandLine.Option(names={"--debug"}, description={"Prints debug information."})
    protected boolean debug;

    private Integer a() throws Exception {
        try {
            bfj bfj2 = this;
            bpd.a(bfj2.inputFiles.length > 0, "no input files selected");
            System.out.println("Filtering " + bfj2.inputFiles.length + " file(s)...");
            File[] fileArray = bfj2.inputFiles;
            int n2 = bfj2.inputFiles.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file = fileArray[i2].getAbsoluteFile();
                if (!file.exists()) {
                    throw bfr.a("File not found: %s", file);
                }
                File file2 = Optional.ofNullable(bfj2.outputDir).orElse(file.getParentFile());
                bpd.b(file2.isDirectory() || file2.mkdirs(), (Object)"Could not create output directory");
                String string = fg.a(file.getName());
                File file3 = new File(file2, string + bfj2.suffix + ".hebilog");
                if (file3.isFile()) {
                    file3.delete();
                }
                try (adc adc2 = adc.a(file);
                     ade ade2 = ade.a(file3);){
                    adi adi2 = adc2.a();
                    ald[] aldArray = (ald[])Arrays.stream(bfj2.indices).mapToObj(((adg)adi2).getAddressMap()::a).filter(Objects::nonNull).toArray(ald[]::new);
                    adi adi3 = ((adg)adi2).b().a(aky.a(aldArray)).b();
                    Object object = adi3;
                    ade ade3 = ade2;
                    Object object2 = object;
                    int n3 = 0;
                    if (((adg)object2).J()) {
                        n3 = 0 + (8 + 8 * ((adg)object2).getAddressMap().C());
                    }
                    if (((adg)object2).K()) {
                        n3 += 12;
                    }
                    if (((adg)object2).L()) {
                        n3 += 12;
                    }
                    ByteBuffer byteBuffer = ade3.a(n3);
                    add.a((adg)object, byteBuffer);
                    Buffer6.flip(byteBuffer);
                    ade3.a.write(byteBuffer);
                    long[] lArray = Arrays.stream(aldArray).mapToLong(ald::t).toArray();
                    Arrays.sort(lArray);
                    adf adf2 = adf.a();
                    while (adc2.I()) {
                        adc2.a(adf2);
                        if (Arrays.binarySearch(lArray, adf2.U) < 0) continue;
                        object = adf2;
                        ade3 = ade2;
                        ByteBuffer byteBuffer2 = byteBuffer = ade3.a(24 + ((adf)object).v);
                        object2 = object;
                        add.a(adj.a(((adf)object2).bQ), ((adf)object2).T, ((adf)object2).U, ((adf)object2).b, 0, ((adf)object2).v, byteBuffer2);
                        Buffer6.flip(byteBuffer);
                        ade3.a.write(byteBuffer);
                    }
                    continue;
                }
            }
            return bfs.b.dg;
        }
        catch (bfr bfr2) {
            System.err.println(bfr2.getMessage());
            return bfr2.a.dg;
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            return bfs.c.dg;
        }
    }

    @Override
    public final /* synthetic */ Object call() throws Exception {
        return this.a();
    }
}

