/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.reader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.scanner.Constant;

public class StreamReader {
    private String name;
    private final Reader stream;
    private int[] dataWindow;
    private int dataLength;
    private int pointer = 0;
    private boolean eof;
    private int index = 0;
    private int documentIndex = 0;
    private int line = 0;
    private int column = 0;
    private final char[] buffer;
    private static final int BUFFER_SIZE = 1025;

    public StreamReader(String string) {
        this(new StringReader(string));
        this.name = "'string'";
    }

    public StreamReader(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("Reader must be provided.");
        }
        this.name = "'reader'";
        this.dataWindow = new int[0];
        this.dataLength = 0;
        this.stream = reader;
        this.eof = false;
        this.buffer = new char[1025];
    }

    public static boolean isPrintable(String string) {
        int n2;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (StreamReader.isPrintable(n2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(int n2) {
        return n2 >= 32 && n2 <= 126 || n2 == 9 || n2 == 10 || n2 == 13 || n2 == 133 || n2 >= 160 && n2 <= 55295 || n2 >= 57344 && n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF;
    }

    public Mark getMark() {
        return new Mark(this.name, this.index, this.line, this.column, this.dataWindow, this.pointer);
    }

    public void forward() {
        this.forward(1);
    }

    public void forward(int n2) {
        for (int i2 = 0; i2 < n2 && this.ensureEnoughData(); ++i2) {
            int n3 = this.dataWindow[this.pointer++];
            this.moveIndices(1);
            if (Constant.LINEBR.has(n3) || n3 == 13 && this.ensureEnoughData() && this.dataWindow[this.pointer] != 10) {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (n3 == 65279) continue;
            ++this.column;
        }
    }

    public int peek() {
        return this.ensureEnoughData() ? this.dataWindow[this.pointer] : 0;
    }

    public int peek(int n2) {
        return this.ensureEnoughData(n2) ? this.dataWindow[this.pointer + n2] : 0;
    }

    public String prefix(int n2) {
        if (n2 == 0) {
            return "";
        }
        if (this.ensureEnoughData(n2)) {
            return new String(this.dataWindow, this.pointer, n2);
        }
        return new String(this.dataWindow, this.pointer, Math.min(n2, this.dataLength - this.pointer));
    }

    public String prefixForward(int n2) {
        String string = this.prefix(n2);
        this.pointer += n2;
        this.moveIndices(n2);
        this.column += n2;
        return string;
    }

    private boolean ensureEnoughData() {
        return this.ensureEnoughData(0);
    }

    private boolean ensureEnoughData(int n2) {
        if (!this.eof && this.pointer + n2 >= this.dataLength) {
            this.update();
        }
        return this.pointer + n2 < this.dataLength;
    }

    private void update() {
        try {
            int n2 = this.stream.read(this.buffer, 0, 1024);
            if (n2 > 0) {
                int n3 = this.dataLength - this.pointer;
                this.dataWindow = Arrays.copyOfRange(this.dataWindow, this.pointer, this.dataLength + n2);
                if (Character.isHighSurrogate(this.buffer[n2 - 1])) {
                    if (this.stream.read(this.buffer, n2, 1) == -1) {
                        this.eof = true;
                    } else {
                        ++n2;
                    }
                }
                int n4 = 32;
                int n5 = 0;
                while (n5 < n2) {
                    int n6;
                    this.dataWindow[n3] = n6 = Character.codePointAt(this.buffer, n5);
                    if (StreamReader.isPrintable(n6)) {
                        n5 += Character.charCount(n6);
                    } else {
                        n4 = n6;
                        n5 = n2;
                    }
                    ++n3;
                }
                this.dataLength = n3;
                this.pointer = 0;
                if (n4 != 32) {
                    throw new ReaderException(this.name, n3 - 1, n4, "special characters are not allowed");
                }
            } else {
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            throw new YAMLException(iOException);
        }
    }

    public int getColumn() {
        return this.column;
    }

    private void moveIndices(int n2) {
        this.index += n2;
        this.documentIndex += n2;
    }

    public int getDocumentIndex() {
        return this.documentIndex;
    }

    public void resetDocumentIndex() {
        this.documentIndex = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }
}

