/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import java.math.BigInteger;
import javafx.beans.binding.NumberExpression;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;

class NumericField
extends TextField {
    private final NumericValidator<? extends Number> value;

    public NumericField(Class<? extends Number> clazz) {
        this.value = clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == BigInteger.class ? new LongValidator(this) : new DoubleValidator(this);
        this.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (!bl3.booleanValue()) {
                this.value.setValue(this.value.toNumber(this.getText()));
            }
        });
    }

    public final ObservableValue<Number> valueProperty() {
        return this.value;
    }

    public void replaceText(int n2, int n3, String string) {
        if (this.replaceValid(n2, n3, string).booleanValue()) {
            super.replaceText(n2, n3, string);
        }
    }

    public void replaceSelection(String string) {
        IndexRange indexRange = this.getSelection();
        if (this.replaceValid(indexRange.getStart(), indexRange.getEnd(), string).booleanValue()) {
            super.replaceSelection(string);
        }
    }

    protected void setValue(Number number) {
        this.value.setValue(number);
    }

    private Boolean replaceValid(int n2, int n3, String string) {
        try {
            String string2 = this.getText().substring(0, n2) + string + this.getText().substring(n3);
            if (string2.isEmpty()) {
                return true;
            }
            this.value.toNumber(string2);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static class LongValidator
    extends SimpleLongProperty
    implements NumericValidator<Long> {
        private NumericField field;

        public LongValidator(NumericField numericField) {
            super((Object)numericField, "value", 0L);
            this.field = numericField;
        }

        protected void invalidated() {
            this.field.setText(Long.toString(this.get()));
        }

        @Override
        public Long toNumber(String string) {
            if (string == null || string.trim().isEmpty()) {
                return 0L;
            }
            String string2 = string.trim();
            return new Long(string2);
        }
    }

    static class DoubleValidator
    extends SimpleDoubleProperty
    implements NumericValidator<Double> {
        private NumericField field;

        public DoubleValidator(NumericField numericField) {
            super((Object)numericField, "value", 0.0);
            this.field = numericField;
        }

        protected void invalidated() {
            this.field.setText(Double.toString(this.get()));
        }

        @Override
        public Double toNumber(String string) {
            if (string == null || string.trim().isEmpty()) {
                return 0.0;
            }
            String string2 = string.trim();
            if (string2.endsWith("f") || string2.endsWith("d") || string2.endsWith("F") || string2.endsWith("D")) {
                throw new NumberFormatException("There should be no alpha symbols");
            }
            return new Double(string2);
        }
    }

    private static interface NumericValidator<T extends Number>
    extends NumberExpression {
        public void setValue(Number var1);

        public T toNumber(String var1);
    }
}

