/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.textfield.CustomTextField;

abstract class AbstractObjectField<T>
extends HBox {
    private static final Image image = new Image(AbstractObjectField.class.getResource("/org/controlsfx/control/open-editor.png").toExternalForm());
    private final CustomTextField textField = new CustomTextField();
    private ObjectProperty<T> objectProperty = new SimpleObjectProperty();

    public AbstractObjectField() {
        super(1.0);
        this.textField.setEditable(false);
        this.textField.setFocusTraversable(false);
        StackPane stackPane = new StackPane(new Node[]{new ImageView(image)});
        stackPane.setCursor(Cursor.DEFAULT);
        stackPane.setOnMouseReleased(mouseEvent -> {
            Object object;
            if (MouseButton.PRIMARY == mouseEvent.getButton() && (object = this.edit(this.objectProperty.get())) != null) {
                this.objectProperty.set(object);
            }
        });
        this.textField.setRight((Node)stackPane);
        this.getChildren().add((Object)this.textField);
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.objectProperty.addListener((observableValue, object, object2) -> this.textProperty().set((Object)this.objectToString(object2)));
    }

    protected StringProperty textProperty() {
        return this.textField.textProperty();
    }

    public ObjectProperty<T> getObjectProperty() {
        return this.objectProperty;
    }

    protected String objectToString(T t2) {
        return t2 == null ? "" : t2.toString();
    }

    protected abstract Class<T> getType();

    protected abstract T edit(T var1);
}

