/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import impl.org.controlsfx.ReflectionUtils;
import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.table.ColumnFilter;
import org.controlsfx.control.table.FilterValue;

public final class FilterPanel<T, R>
extends VBox {
    private final ColumnFilter<T, R> columnFilter;
    private final FilteredList<FilterValue> filterList;
    private final TextField searchBox = new TextField();
    private final ListView<FilterValue> checkListView;
    private final Collection<InvalidationListener> columnHeadersChangeListeners = new ArrayList<InvalidationListener>();
    private final ChangeListener<Skin<?>> skinListener = (observableValue, skin, skin2) -> {
        this.columnHeadersChangeListeners.clear();
        if (skin2 instanceof TableViewSkin) {
            TableViewSkin tableViewSkin = (TableViewSkin)skin2;
            FilterPanel.checkChangeContextMenu(tableViewSkin, this.getColumnFilter().getTableColumn(), this);
        }
    };

    void selectAllValues() {
        this.checkListView.getItems().forEach(filterValue -> filterValue.selectedProperty().set(true));
    }

    void unSelectAllValues() {
        this.checkListView.getItems().forEach(filterValue -> filterValue.selectedProperty().set(false));
    }

    void selectValue(Object object) {
        this.checkListView.getItems().stream().filter(filterValue -> filterValue.getValue() == null && object == null || filterValue.getValue() != null && object != null && filterValue.getValue().equals(object)).forEach(filterValue -> filterValue.selectedProperty().set(true));
    }

    void unSelectValue(Object object) {
        this.checkListView.getItems().stream().filter(filterValue -> filterValue.getValue() == null && object == null || filterValue.getValue() != null && object != null && filterValue.getValue().equals(object)).forEach(filterValue -> filterValue.selectedProperty().set(false));
    }

    FilterPanel(ColumnFilter<T, R> columnFilter, ContextMenu contextMenu) {
        columnFilter.setFilterPanel(this);
        this.columnFilter = columnFilter;
        this.getStyleClass().add((Object)"filter-panel");
        this.setPadding(new Insets(3.0));
        this.searchBox.setPromptText(Localization.getString("filterpanel.search.field"));
        this.getChildren().add((Object)this.searchBox);
        this.filterList = new FilteredList((ObservableList)new SortedList(columnFilter.getFilterValues()), filterValue -> true);
        this.checkListView = new ListView();
        this.checkListView.setItems((ObservableList)new SortedList(this.filterList, FilterValue::compareTo));
        this.getChildren().add(this.checkListView);
        HBox hBox = new HBox();
        Button button = new Button(Localization.getString("filterpanel.apply.button"));
        HBox.setHgrow((Node)button, (Priority)Priority.ALWAYS);
        button.setOnAction(actionEvent -> {
            if (columnFilter.getTableFilter().isDirty()) {
                columnFilter.applyFilter();
            }
            contextMenu.hide();
        });
        hBox.getChildren().add((Object)button);
        Button button2 = new Button(Localization.getString("filterpanel.none.button"));
        HBox.setHgrow((Node)button2, (Priority)Priority.ALWAYS);
        button2.setOnAction(actionEvent -> columnFilter.getFilterValues().forEach(filterValue -> filterValue.selectedProperty().set(false)));
        hBox.getChildren().add((Object)button2);
        Button button3 = new Button(Localization.getString("filterpanel.all.button"));
        HBox.setHgrow((Node)button3, (Priority)Priority.ALWAYS);
        button3.setOnAction(actionEvent -> columnFilter.getFilterValues().forEach(filterValue -> filterValue.selectedProperty().set(true)));
        hBox.getChildren().add((Object)button3);
        Button button4 = new Button(Localization.getString("filterpanel.resetall.button"));
        HBox.setHgrow((Node)button4, (Priority)Priority.ALWAYS);
        button4.setOnAction(actionEvent -> {
            columnFilter.resetAllFilters();
            columnFilter.getTableFilter().getColumnFilters().forEach(columnFilter -> columnFilter.getTableColumn().setGraphic(null));
            contextMenu.hide();
        });
        hBox.getChildren().add((Object)button4);
        hBox.setAlignment(Pos.BASELINE_CENTER);
        this.getChildren().add((Object)hBox);
    }

    public void resetSearchFilter() {
        this.filterList.setPredicate(filterValue -> true);
        this.searchBox.clear();
    }

    public static <T, R> CustomMenuItem getInMenuItem(ColumnFilter<T, R> columnFilter, ContextMenu contextMenu) {
        FilterPanel<T, R> filterPanel = new FilterPanel<T, R>(columnFilter, contextMenu);
        CustomMenuItem customMenuItem = new CustomMenuItem();
        filterPanel.initializeListeners();
        customMenuItem.contentProperty().set(filterPanel);
        columnFilter.getTableFilter().getTableView().skinProperty().addListener((ChangeListener)new WeakChangeListener(filterPanel.skinListener));
        customMenuItem.setHideOnClick(false);
        return customMenuItem;
    }

    private void initializeListeners() {
        this.searchBox.textProperty().addListener(observable -> {
            this.filterList.setPredicate(filterValue -> this.searchBox.getText().isEmpty() || this.columnFilter.getSearchStrategy().test(this.searchBox.getText(), Optional.ofNullable(filterValue.getValue()).map(Object::toString).orElse("")));
            this.columnFilter.getFilterValues().stream().filter(filterValue -> !this.columnFilter.getSearchStrategy().test(this.searchBox.getText(), Optional.ofNullable(filterValue.getValue()).map(Object::toString).orElse(""))).collect(Collectors.toList()).forEach(filterValue -> filterValue.selectedProperty().set(false));
            this.columnFilter.getFilterValues().stream().filter(filterValue -> this.columnFilter.getSearchStrategy().test(this.searchBox.getText(), Optional.ofNullable(filterValue.getValue()).map(Object::toString).orElse(""))).collect(Collectors.toList()).forEach(filterValue -> filterValue.selectedProperty().set(true));
        });
    }

    private static void checkChangeContextMenu(TableViewSkin<?> tableViewSkin, TableColumn<?, ?> tableColumn, FilterPanel filterPanel) {
        ReflectionUtils.getTableHeaderRowFrom(tableViewSkin).ifPresent(tableHeaderRow -> ReflectionUtils.getRootHeaderFrom(tableHeaderRow).ifPresent(nestedTableColumnHeader -> {
            InvalidationListener invalidationListener = filterPanel.getOrCreateChangeListener((NestedTableColumnHeader)nestedTableColumnHeader, tableColumn);
            nestedTableColumnHeader.getColumnHeaders().addListener((InvalidationListener)new WeakInvalidationListener(invalidationListener));
            FilterPanel.changeContextMenu(nestedTableColumnHeader, tableColumn);
        }));
    }

    private InvalidationListener getOrCreateChangeListener(NestedTableColumnHeader nestedTableColumnHeader, TableColumn<?, ?> tableColumn) {
        InvalidationListener invalidationListener = observable -> FilterPanel.changeContextMenu(nestedTableColumnHeader, tableColumn);
        this.columnHeadersChangeListeners.add(invalidationListener);
        return invalidationListener;
    }

    private static void changeContextMenu(NestedTableColumnHeader nestedTableColumnHeader, TableColumn<?, ?> tableColumn) {
        TableColumnHeader tableColumnHeader = FilterPanel.scan(tableColumn, (TableColumnHeader)nestedTableColumnHeader);
        if (tableColumnHeader != null) {
            tableColumnHeader.setOnContextMenuRequested(contextMenuEvent -> {
                ContextMenu contextMenu = tableColumn.getContextMenu();
                if (contextMenu != null) {
                    contextMenu.show((Node)tableColumnHeader, Side.BOTTOM, 5.0, 5.0);
                }
                contextMenuEvent.consume();
            });
        }
    }

    private static TableColumnHeader scan(TableColumn<?, ?> tableColumn, TableColumnHeader tableColumnHeader) {
        if (tableColumn.equals((Object)tableColumnHeader.getTableColumn())) {
            return tableColumnHeader;
        }
        if (tableColumnHeader instanceof NestedTableColumnHeader) {
            NestedTableColumnHeader nestedTableColumnHeader = (NestedTableColumnHeader)tableColumnHeader;
            for (int i2 = 0; i2 < nestedTableColumnHeader.getColumnHeaders().size(); ++i2) {
                TableColumnHeader tableColumnHeader2 = FilterPanel.scan(tableColumn, (TableColumnHeader)nestedTableColumnHeader.getColumnHeaders().get(i2));
                if (tableColumnHeader2 == null) continue;
                return tableColumnHeader2;
            }
        }
        return null;
    }

    public ColumnFilter<T, R> getColumnFilter() {
        return this.columnFilter;
    }
}

