/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Object2IntCounterMap<K> {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int initialValue;
    private int resizeThreshold;
    private int size = 0;
    private K[] keys;
    private int[] values;

    public Object2IntCounterMap(int n2) {
        this(8, 0.65f, n2);
    }

    public Object2IntCounterMap(int n2, float f2, int n3) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.initialValue = n3;
        int n4 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.keys = new Object[n4];
        this.values = new int[n4];
        Arrays.fill(this.values, n3);
        this.resizeThreshold = (int)((float)n4 * f2);
    }

    public int initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.values.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(K k2) {
        int n2;
        int n3 = this.initialValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        while (n3 != (n2 = nArray[n5]) && !Objects.equals(KArray[n5], k2)) {
            ++n5;
            n5 &= n4;
        }
        return n2;
    }

    public int put(K k2, int n2) {
        int n3 = this.initialValue;
        if (n3 == n2) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        int n6 = n3;
        while (nArray[n5] != n3) {
            if (Objects.equals(KArray[n5], k2)) {
                n6 = nArray[n5];
                break;
            }
            ++n5;
            n5 &= n4;
        }
        if (n6 == n3) {
            ++this.size;
            KArray[n5] = k2;
        }
        nArray[n5] = n2;
        this.increaseCapacity();
        return n6;
    }

    public int incrementAndGet(K k2) {
        return this.addAndGet(k2, 1);
    }

    public int decrementAndGet(K k2) {
        return this.addAndGet(k2, -1);
    }

    public int addAndGet(K k2, int n2) {
        return this.getAndAdd(k2, n2) + n2;
    }

    public int getAndIncrement(K k2) {
        return this.getAndAdd(k2, 1);
    }

    public int getAndDecrement(K k2) {
        return this.getAndAdd(k2, -1);
    }

    public int getAndAdd(K k2, int n2) {
        int n3 = this.initialValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        int n6 = n3;
        while (n3 != nArray[n5]) {
            if (Objects.equals(KArray[n5], k2)) {
                n6 = nArray[n5];
                break;
            }
            ++n5;
            n5 &= n4;
        }
        if (n2 != 0) {
            int n7;
            nArray[n5] = n7 = n6 + n2;
            if (n3 == n6) {
                ++this.size;
                KArray[n5] = k2;
                this.increaseCapacity();
            } else if (n3 == n7) {
                --this.size;
                this.compactChain(n5);
            }
        }
        return n6;
    }

    public void forEach(ObjIntConsumer<K> objIntConsumer) {
        int n2 = this.initialValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n3 = nArray.length;
        int n4 = this.size;
        for (int i2 = 0; n4 > 0 && i2 < n3; ++i2) {
            if (n2 == nArray[i2]) continue;
            objIntConsumer.accept(KArray[i2], nArray[i2]);
            --n4;
        }
    }

    public boolean containsKey(K k2) {
        return this.initialValue != this.get(k2);
    }

    public boolean containsValue(int n2) {
        boolean bl2 = false;
        if (this.initialValue != n2) {
            for (int n3 : this.values) {
                if (n2 != n3) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public int computeIfAbsent(K k2, ToIntFunction<? super K> toIntFunction) {
        int n2 = this.get(k2);
        if (this.initialValue == n2 && this.initialValue != (n2 = toIntFunction.applyAsInt(k2))) {
            this.put(k2, n2);
        }
        return n2;
    }

    public int remove(K k2) {
        int n2 = this.initialValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n3 = nArray.length - 1;
        int n4 = Hashing.hash(k2, n3);
        int n5 = n2;
        while (n2 != nArray[n4]) {
            if (Objects.equals(KArray[n4], k2)) {
                n5 = nArray[n4];
                nArray[n4] = n2;
                --this.size;
                this.compactChain(n4);
                break;
            }
            ++n4;
            n4 &= n3;
        }
        return n5;
    }

    public int minValue() {
        int n2 = this.initialValue;
        int n3 = 0 == this.size ? n2 : Integer.MAX_VALUE;
        for (int n4 : this.values) {
            if (n2 == n4) continue;
            n3 = Math.min(n3, n4);
        }
        return n3;
    }

    public int maxValue() {
        int n2 = this.initialValue;
        int n3 = 0 == this.size ? n2 : Integer.MIN_VALUE;
        for (int n4 : this.values) {
            if (n2 == n4) continue;
            n3 = Math.max(n3, n4);
        }
        return n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        int n2 = this.initialValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n2 == n4) continue;
            stringBuilder.append(KArray[i2]).append('=').append(n4).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void compactChain(int n2) {
        int n3 = this.initialValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = n2;
        while (true) {
            ++n5;
            int n6 = nArray[n5 &= n4];
            if (n3 == n6) break;
            K k2 = KArray[n5];
            int n7 = Hashing.hash(k2, n4);
            if ((n5 >= n7 || n7 > n2 && n2 > n5) && (n7 > n2 || n2 > n5)) continue;
            KArray[n2] = k2;
            nArray[n2] = n6;
            KArray[n5] = null;
            nArray[n5] = n3;
            n2 = n5;
        }
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.values.length * 2;
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        Object[] objectArray = new Object[n2];
        int[] nArray = new int[n2];
        int n4 = this.initialValue;
        Arrays.fill(nArray, n4);
        K[] KArray = this.keys;
        int[] nArray2 = this.values;
        int n5 = nArray2.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = nArray2[i2];
            if (n4 == n6) continue;
            K k2 = KArray[i2];
            int n7 = Hashing.hash(k2, n3);
            while (n4 != nArray[n7]) {
                ++n7;
                n7 &= n3;
            }
            objectArray[n7] = k2;
            nArray[n7] = n6;
        }
        this.keys = objectArray;
        this.values = nArray;
    }
}

