/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;

public class LongArrayList
extends AbstractList<Long>
implements List<Long>,
RandomAccess {
    public static final long DEFAULT_NULL_VALUE = Long.MIN_VALUE;
    public static final int INITIAL_CAPACITY = 10;
    private final long nullValue;
    private int size = 0;
    private long[] elements;

    public LongArrayList() {
        this(10, Long.MIN_VALUE);
    }

    public LongArrayList(int n2, long l2) {
        this.nullValue = l2;
        this.elements = new long[Math.max(n2, 10)];
    }

    public LongArrayList(long[] lArray, int n2, long l2) {
        this.wrap(lArray, n2);
        this.nullValue = l2;
    }

    public void wrap(long[] lArray, int n2) {
        if (n2 < 0 || n2 > lArray.length) {
            throw new IllegalArgumentException("illegal initial size " + n2 + " for array length of " + lArray.length);
        }
        this.elements = lArray;
        this.size = n2;
    }

    public long nullValue() {
        return this.nullValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size && this.elements.length > 10) {
            this.elements = Arrays.copyOf(this.elements, Math.max(10, this.size));
        }
    }

    @Override
    public Long get(int n2) {
        long l2 = this.getLong(n2);
        return this.nullValue == l2 ? null : Long.valueOf(l2);
    }

    public long getLong(int n2) {
        this.checkIndex(n2);
        return this.elements[n2];
    }

    @Override
    public boolean add(Long l2) {
        return this.addLong(null == l2 ? this.nullValue : l2);
    }

    public boolean addLong(long l2) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = l2;
        ++this.size;
        return true;
    }

    @Override
    public void add(int n2, Long l2) {
        this.addLong(n2, null == l2 ? this.nullValue : l2);
    }

    public void addLong(int n2, long l2) {
        this.checkIndexForAdd(n2);
        int n3 = this.size + 1;
        this.ensureCapacityPrivate(n3);
        if (n2 < this.size) {
            System.arraycopy(this.elements, n2, this.elements, n2 + 1, this.size - n2);
        }
        this.elements[n2] = l2;
        ++this.size;
    }

    @Override
    public Long set(int n2, Long l2) {
        long l3 = this.setLong(n2, null == l2 ? this.nullValue : l2);
        return this.nullValue == l3 ? null : Long.valueOf(l3);
    }

    public long setLong(int n2, long l2) {
        this.checkIndex(n2);
        long l3 = this.elements[n2];
        this.elements[n2] = l2;
        return l3;
    }

    @Override
    public boolean contains(Object object) {
        return this.containsLong(null == object ? this.nullValue : (Long)object);
    }

    public boolean containsLong(long l2) {
        return -1 != this.indexOf(l2);
    }

    public int indexOf(long l2) {
        long[] lArray = this.elements;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (l2 != lArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(long l2) {
        long[] lArray = this.elements;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (l2 != lArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public boolean addAll(LongArrayList longArrayList) {
        int n2 = longArrayList.size;
        if (n2 > 0) {
            this.ensureCapacityPrivate(this.size + n2);
            System.arraycopy(longArrayList.elements, 0, this.elements, this.size, n2);
            this.size += n2;
            return true;
        }
        return false;
    }

    public boolean addAll(int n2, LongArrayList longArrayList) {
        this.checkIndexForAdd(n2);
        int n3 = longArrayList.size;
        if (n3 > 0) {
            int n4 = this.size;
            this.ensureCapacityPrivate(n4 + n3);
            long[] lArray = this.elements;
            for (int i2 = n4 - 1; i2 >= n2; --i2) {
                lArray[i2 + n3] = lArray[i2];
            }
            System.arraycopy(longArrayList.elements, 0, lArray, n2, n3);
            this.size += n3;
            return true;
        }
        return false;
    }

    public boolean containsAll(LongArrayList longArrayList) {
        long[] lArray = longArrayList.elements;
        long l2 = longArrayList.nullValue;
        boolean bl2 = this.contains(null);
        int n2 = longArrayList.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = lArray[i2];
            if (this.containsLong(l3) || bl2 && l2 == l3) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(LongArrayList longArrayList) {
        long[] lArray = this.elements;
        int n2 = this.size;
        if (n2 > 0) {
            if (longArrayList.isEmpty()) {
                this.size = 0;
                return true;
            }
            long l2 = this.nullValue;
            boolean bl2 = longArrayList.contains(null);
            long[] lArray2 = null;
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = lArray[i2];
                if (!(longArrayList.containsLong(l3) || bl2 && l2 == l3)) {
                    if (null != lArray2) continue;
                    lArray2 = Arrays.copyOf(lArray, n2);
                    n3 = i2 - 1;
                    continue;
                }
                if (null == lArray2) continue;
                lArray2[++n3] = l3;
            }
            if (null != lArray2) {
                this.elements = lArray2;
                this.size = n3 + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeAll(LongArrayList longArrayList) {
        long[] lArray = this.elements;
        int n2 = this.size;
        if (n2 > 0 && !longArrayList.isEmpty()) {
            long l2 = this.nullValue;
            boolean bl2 = longArrayList.contains(null);
            long[] lArray2 = null;
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = lArray[i2];
                if (longArrayList.containsLong(l3) || bl2 && l2 == l3) {
                    if (null != lArray2) continue;
                    lArray2 = Arrays.copyOf(lArray, n2);
                    n3 = i2 - 1;
                    continue;
                }
                if (null == lArray2) continue;
                lArray2[++n3] = l3;
            }
            if (null != lArray2) {
                this.elements = lArray2;
                this.size = n3 + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeIfLong(LongPredicate longPredicate) {
        Objects.requireNonNull(longPredicate);
        long[] lArray = this.elements;
        int n2 = this.size;
        if (n2 > 0) {
            long[] lArray2 = null;
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l2 = lArray[i2];
                if (longPredicate.test(l2)) {
                    if (null != lArray2) continue;
                    lArray2 = Arrays.copyOf(lArray, n2);
                    n3 = i2 - 1;
                    continue;
                }
                if (null == lArray2) continue;
                lArray2[++n3] = l2;
            }
            if (null != lArray2) {
                this.elements = lArray2;
                this.size = n3 + 1;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return this.removeLong(null == object ? this.nullValue : (Long)object);
    }

    @Override
    public Long remove(int n2) {
        long l2 = this.removeAt(n2);
        return this.nullValue == l2 ? null : Long.valueOf(l2);
    }

    public long removeAt(int n2) {
        this.checkIndex(n2);
        long l2 = this.elements[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elements, n2 + 1, this.elements, n2, n3);
        }
        --this.size;
        return l2;
    }

    public long fastUnorderedRemove(int n2) {
        this.checkIndex(n2);
        long l2 = this.elements[n2];
        this.elements[n2] = this.elements[--this.size];
        return l2;
    }

    public boolean removeLong(long l2) {
        int n2 = this.indexOf(l2);
        if (-1 != n2) {
            this.removeAt(n2);
            return true;
        }
        return false;
    }

    public boolean fastUnorderedRemoveLong(long l2) {
        int n2 = this.indexOf(l2);
        if (-1 != n2) {
            this.elements[n2] = this.elements[--this.size];
            return true;
        }
        return false;
    }

    public void pushLong(long l2) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = l2;
        ++this.size;
    }

    public long popLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[--this.size];
    }

    public void forEachOrderedLong(LongConsumer longConsumer) {
        long[] lArray = this.elements;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            longConsumer.accept(lArray[i2]);
        }
    }

    public LongStream longStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public long[] toLongArray(long[] lArray) {
        if (lArray.length == this.size) {
            System.arraycopy(this.elements, 0, lArray, 0, lArray.length);
            return lArray;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int n2) {
        this.ensureCapacityPrivate(Math.max(n2, 10));
    }

    public boolean equals(LongArrayList longArrayList) {
        if (longArrayList == this) {
            return true;
        }
        boolean bl2 = false;
        int n2 = this.size;
        if (n2 == longArrayList.size) {
            bl2 = true;
            long[] lArray = this.elements;
            long[] lArray2 = longArrayList.elements;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l2 = lArray[i2];
                long l3 = lArray2[i2];
                if (l2 == l3 || l2 == this.nullValue && l3 == longArrayList.nullValue) continue;
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    @Override
    public boolean equals(Object object) {
        List list;
        if (object == this) {
            return true;
        }
        boolean bl2 = false;
        if (object instanceof LongArrayList) {
            return this.equals((LongArrayList)object);
        }
        if (object instanceof List && this.size == (list = (List)object).size()) {
            bl2 = true;
            int n2 = 0;
            for (Object e2 : list) {
                Long l2;
                Long l3;
                if ((null == e2 || e2 instanceof Long) && Objects.equals(l3 = this.get(n2++), l2 = (Long)e2)) continue;
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        long l2 = this.nullValue;
        long[] lArray = this.elements;
        int n3 = this.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            long l3 = lArray[i2];
            n2 = 31 * n2 + (l2 == l3 ? 0 : Long.hashCode(l3));
        }
        return n2;
    }

    @Override
    public void forEach(Consumer<? super Long> consumer) {
        Objects.requireNonNull(consumer);
        long l2 = this.nullValue;
        long[] lArray = this.elements;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = lArray[i2];
            consumer.accept(l2 != l3 ? Long.valueOf(l3) : null);
        }
    }

    public void forEachLong(LongConsumer longConsumer) {
        Objects.requireNonNull(longConsumer);
        long[] lArray = this.elements;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            longConsumer.accept(lArray[i2]);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        long l2 = this.nullValue;
        long[] lArray = this.elements;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = lArray[i2];
            stringBuilder.append(l3 != l2 ? Long.valueOf(l3) : null).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void ensureCapacityPrivate(int n2) {
        int n3 = this.elements.length;
        if (n2 > n3) {
            int n4;
            if (n2 > 0x7FFFFFF7) {
                throw new IllegalStateException("max capacity: 2147483639");
            }
            int n5 = n4 = n3 > 10 ? n3 : 10;
            while (n4 < n2) {
                if ((n4 += n4 >> 1) >= 0 && n4 < 0x7FFFFFF7) continue;
                n4 = 0x7FFFFFF7;
            }
            long[] lArray = new long[n4];
            System.arraycopy(this.elements, 0, lArray, 0, n3);
            this.elements = lArray;
        }
    }

    private void checkIndex(int n2) {
        if (n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("index=" + n2 + " size=" + this.size);
        }
    }

    private void checkIndexForAdd(int n2) {
        if (n2 > this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("index=" + n2 + " size=" + this.size);
        }
    }
}

