/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongConsumer;
import org.agrona.collections.LongLongFunction;
import org.agrona.collections.LongLongPredicate;

public class Long2LongHashMap
implements Map<Long, Long> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private long[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Long2LongHashMap(long l2) {
        this(8, 0.65f, l2);
    }

    public Long2LongHashMap(int n2, float f2, long l2) {
        this(n2, f2, l2, true);
    }

    public Long2LongHashMap(int n2, float f2, long l2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.missingValue = l2;
        this.shouldAvoidAllocation = bl2;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public Long2LongHashMap(Long2LongHashMap long2LongHashMap) {
        this.loadFactor = long2LongHashMap.loadFactor;
        this.resizeThreshold = long2LongHashMap.resizeThreshold;
        this.size = long2LongHashMap.size;
        this.shouldAvoidAllocation = long2LongHashMap.shouldAvoidAllocation;
        this.missingValue = long2LongHashMap.missingValue;
        this.entries = (long[])long2LongHashMap.entries.clone();
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    public long getOrDefault(long l2, long l3) {
        long l4 = this.get(l2);
        return this.missingValue != l4 ? l4 : l3;
    }

    public long get(long l2) {
        long l3;
        long l4 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l4 != (l3 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongHashMap.next(n3, n2);
        }
        return l3;
    }

    @Override
    public long put(long l2, long l3) {
        long l4;
        long l5 = this.missingValue;
        if (l5 == l3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l5 != (l4 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongHashMap.next(n3, n2);
        }
        if (l5 == l4) {
            ++this.size;
            lArray[n3] = l2;
        }
        lArray[n3 + 1] = l3;
        this.increaseCapacity();
        return l4;
    }

    @Override
    public long putIfAbsent(long l2, long l3) {
        long l4;
        long l5 = this.missingValue;
        if (l5 == l3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l5 != (l4 = lArray[n3 + 1])) {
            if (l2 == lArray[n3]) {
                return l4;
            }
            n3 = Long2LongHashMap.next(n3, n2);
        }
        ++this.size;
        lArray[n3] = l2;
        lArray[n3 + 1] = l3;
        this.increaseCapacity();
        return l4;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.entries.length;
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        long l2 = this.missingValue;
        long[] lArray = this.entries;
        int n3 = lArray.length;
        this.capacity(n2);
        long[] lArray2 = this.entries;
        int n4 = lArray2.length - 1;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            long l4 = lArray[i2 - 1];
            int n5 = Hashing.evenHash(l4, n4);
            while (l2 != lArray2[n5 + 1]) {
                n5 = Long2LongHashMap.next(n5, n4);
            }
            lArray2[n5] = l4;
            lArray2[n5 + 1] = l3;
        }
    }

    @Deprecated
    public void longForEach(LongLongConsumer longLongConsumer) {
        this.forEachLong(longLongConsumer);
    }

    public void forEachLong(LongLongConsumer longLongConsumer) {
        Objects.requireNonNull(longLongConsumer);
        long l2 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        int n3 = this.size;
        for (int i2 = 1; n3 > 0 && i2 < n2; i2 += 2) {
            if (l2 == lArray[i2]) continue;
            longLongConsumer.accept(lArray[i2 - 1], lArray[i2]);
            --n3;
        }
    }

    public boolean containsKey(long l2) {
        return this.missingValue != this.get(l2);
    }

    public boolean containsValue(long l2) {
        boolean bl2 = false;
        long l3 = this.missingValue;
        if (l3 != l2) {
            long[] lArray = this.entries;
            int n2 = lArray.length;
            int n3 = this.size;
            for (int i2 = 1; n3 > 0 && i2 < n2; i2 += 2) {
                long l4 = lArray[i2];
                if (l3 == l4) continue;
                if (l4 == l2) {
                    bl2 = true;
                    break;
                }
                --n3;
            }
        }
        return bl2;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public long computeIfAbsent(long l2, LongUnaryOperator longUnaryOperator) {
        long l3;
        Objects.requireNonNull(longUnaryOperator);
        long l4 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l4 != (l3 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongHashMap.next(n3, n2);
        }
        if (l4 == l3 && l4 != (l3 = longUnaryOperator.applyAsLong(l2))) {
            lArray[n3] = l2;
            lArray[n3 + 1] = l3;
            ++this.size;
            this.increaseCapacity();
        }
        return l3;
    }

    public long computeIfPresent(long l2, LongBinaryOperator longBinaryOperator) {
        long l3;
        Objects.requireNonNull(longBinaryOperator);
        long l4 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l4 != (l3 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongHashMap.next(n3, n2);
        }
        if (l4 != l3) {
            lArray[n3 + 1] = l3 = longBinaryOperator.applyAsLong(l2, l3);
            if (l4 == l3) {
                --this.size;
                this.compactChain(n3);
            }
        }
        return l3;
    }

    public long compute(long l2, LongBinaryOperator longBinaryOperator) {
        long l3;
        Objects.requireNonNull(longBinaryOperator);
        long l4 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l4 != (l3 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongHashMap.next(n3, n2);
        }
        long l5 = longBinaryOperator.applyAsLong(l2, l3);
        if (l4 != l5) {
            lArray[n3 + 1] = l5;
            if (l3 == l4) {
                lArray[n3] = l2;
                ++this.size;
                this.increaseCapacity();
            }
        } else if (l4 != l3) {
            lArray[n3 + 1] = l4;
            --this.size;
            this.compactChain(n3);
        }
        return l5;
    }

    @Override
    public Long get(Object object) {
        return this.valOrNull(this.get((Long)object));
    }

    @Override
    public Long put(Long l2, Long l3) {
        return this.valOrNull(this.put((long)l2, (long)l3));
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Long> biConsumer) {
        this.forEachLong(biConsumer::accept);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey((Long)object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue((Long)object);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> map) {
        for (Map.Entry<? extends Long, ? extends Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Long2LongHashMap long2LongHashMap) {
        EntryIterator entryIterator = long2LongHashMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            entryIterator.findNext();
            this.put(entryIterator.getLongKey(), entryIterator.getLongValue());
        }
    }

    @Override
    public Long putIfAbsent(Long l2, Long l3) {
        return this.valOrNull(this.putIfAbsent((long)l2, (long)l3));
    }

    @Override
    public Long replace(Long l2, Long l3) {
        return this.valOrNull(this.replace((long)l2, (long)l3));
    }

    @Override
    public boolean replace(Long l2, Long l3, Long l4) {
        return this.replace((long)l2, (long)l3, (long)l4);
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Long, ? extends Long> biFunction) {
        this.replaceAllLong(biFunction::apply);
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Long remove(Object object) {
        return this.valOrNull(this.remove((Long)object));
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove((Long)object, (Long)object2);
    }

    public long remove(long l2) {
        long l3;
        long l4 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l4 != (l3 = lArray[n3 + 1])) {
            if (l2 == lArray[n3]) {
                lArray[n3 + 1] = l4;
                --this.size;
                this.compactChain(n3);
                break;
            }
            n3 = Long2LongHashMap.next(n3, n2);
        }
        return l3;
    }

    public boolean remove(long l2, long l3) {
        long l4;
        long l5 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l5 != (l4 = lArray[n3 + 1])) {
            if (l2 == lArray[n3]) {
                if (l3 != l4) break;
                lArray[n3 + 1] = l5;
                --this.size;
                this.compactChain(n3);
                return true;
            }
            n3 = Long2LongHashMap.next(n3, n2);
        }
        return false;
    }

    public long merge(long l2, long l3, LongLongFunction longLongFunction) {
        long l4;
        long l5;
        Objects.requireNonNull(longLongFunction);
        long l6 = this.missingValue;
        if (l6 == l3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l6 != (l5 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongHashMap.next(n3, n2);
        }
        long l7 = l4 = l6 == l5 ? l3 : longLongFunction.apply(l5, l3);
        if (l6 != l4) {
            lArray[n3 + 1] = l4;
            if (l6 == l5) {
                lArray[n3] = l2;
                ++this.size;
                this.increaseCapacity();
            }
        } else {
            lArray[n3 + 1] = l6;
            --this.size;
            this.compactChain(n3);
        }
        return l4;
    }

    private void compactChain(int n2) {
        long l2;
        long l3 = this.missingValue;
        long[] lArray = this.entries;
        int n3 = lArray.length - 1;
        int n4 = n2;
        while (l3 != (l2 = lArray[(n4 = Long2LongHashMap.next(n4, n3)) + 1])) {
            long l4 = lArray[n4];
            int n5 = Hashing.evenHash(l4, n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            lArray[n2] = l4;
            lArray[n2 + 1] = l2;
            lArray[n4 + 1] = l3;
            n2 = n4;
        }
    }

    public long minValue() {
        long l2 = this.missingValue;
        long l3 = 0 == this.size ? l2 : Long.MAX_VALUE;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            long l4 = lArray[i2];
            if (l2 == l4) continue;
            l3 = Math.min(l3, l4);
        }
        return l3;
    }

    public long maxValue() {
        long l2 = this.missingValue;
        long l3 = 0 == this.size ? l2 : Long.MIN_VALUE;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            long l4 = lArray[i2];
            if (l2 == l4) continue;
            l3 = Math.max(l3, l4);
        }
        return l3;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder stringBuilder = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            stringBuilder.append(entryIterator.getLongKey()).append('=').append(entryIterator.getLongValue());
            if (!entryIterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    @Override
    public long replace(long l2, long l3) {
        long l4;
        long l5 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l5 != (l4 = lArray[n3 + 1])) {
            if (l2 == lArray[n3]) {
                lArray[n3 + 1] = l3;
                break;
            }
            n3 = Long2LongHashMap.next(n3, n2);
        }
        return l4;
    }

    @Override
    public boolean replace(long l2, long l3, long l4) {
        long l5;
        long l6 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l6 != (l5 = lArray[n3 + 1])) {
            if (l2 == lArray[n3]) {
                if (l3 != l5) break;
                lArray[n3 + 1] = l4;
                return true;
            }
            n3 = Long2LongHashMap.next(n3, n2);
        }
        return false;
    }

    public void replaceAllLong(LongLongFunction longLongFunction) {
        Objects.requireNonNull(longLongFunction);
        long l2 = this.missingValue;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        int n3 = this.size;
        for (int i2 = 1; n3 > 0 && i2 < n2; i2 += 2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            long l4 = longLongFunction.apply(lArray[i2 - 1], l3);
            if (l2 == l4) {
                throw new IllegalArgumentException("cannot replace with a missingValue");
            }
            lArray[i2] = l4;
            --n3;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.size == map.size() && this.entrySet().equals(map.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int n2, int n3) {
        return n2 + 2 & n3;
    }

    private void capacity(int n2) {
        int n3 = n2 * 2;
        if (n3 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        this.entries = new long[n3];
        Arrays.fill(this.entries, this.missingValue);
    }

    private Long valOrNull(long l2) {
        return this.missingValue == l2 ? null : Long.valueOf(l2);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Long, Long>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Long2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Long l2 = Long2LongHashMap.this.get(entry.getKey());
            return l2 != null && l2.equals(entry.getValue());
        }

        public boolean removeIfLong(LongLongPredicate longLongPredicate) {
            boolean bl2 = false;
            EntryIterator entryIterator = this.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.findNext();
                if (!longLongPredicate.test(entryIterator.getLongKey(), entryIterator.getLongValue())) continue;
                entryIterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= Long2LongHashMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), Long2LongHashMap.this.size);
            EntryIterator entryIterator = this.iterator();
            for (int i2 = 0; i2 < TArray2.length; ++i2) {
                if (!entryIterator.hasNext()) {
                    TArray2[i2] = null;
                    break;
                }
                entryIterator.next();
                TArray2[i2] = entryIterator.allocateDuplicateEntry();
            }
            return TArray2;
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Long, Long>>,
    Map.Entry<Long, Long> {
        @Override
        public Long getKey() {
            return this.getLongKey();
        }

        public long getLongKey() {
            return Long2LongHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        public long getLongValue() {
            return Long2LongHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Long setValue(Long l2) {
            return this.setValue((long)l2);
        }

        @Override
        public long setValue(long l2) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Long2LongHashMap.this.missingValue == l2) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int n2 = this.keyPosition();
            long[] lArray = Long2LongHashMap.this.entries;
            long l3 = lArray[n2 + 1];
            lArray[n2 + 1] = l2;
            return l3;
        }

        @Override
        public Map.Entry<Long, Long> next() {
            this.findNext();
            if (Long2LongHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Long, Long> allocateDuplicateEntry() {
            return new MapEntry(this.getLongKey(), this.getLongValue());
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.getLongKey()) ^ Long.hashCode(this.getLongValue());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }

        public final class MapEntry
        implements Map.Entry<Long, Long> {
            private final long k;
            private final long v;

            public MapEntry(long l2, long l3) {
                this.k = l2;
                this.v = l3;
            }

            @Override
            public Long getKey() {
                return this.k;
            }

            @Override
            public Long getValue() {
                return this.v;
            }

            @Override
            public Long setValue(Long l2) {
                return Long2LongHashMap.this.put(this.k, (long)l2);
            }

            @Override
            public int hashCode() {
                return Long.hashCode(EntryIterator.this.getLongKey()) ^ Long.hashCode(EntryIterator.this.getLongValue());
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return entry.getKey() != null && entry.getValue() != null && entry.getKey().equals(this.k) && entry.getValue().equals(this.v);
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeySet
    extends AbstractSet<Long> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Long2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.contains((Long)object);
        }

        public boolean contains(long l2) {
            return Long2LongHashMap.this.containsKey(l2);
        }

        public boolean removeIfLong(LongPredicate longPredicate) {
            boolean bl2 = false;
            KeyIterator keyIterator = this.iterator();
            while (keyIterator.hasNext()) {
                if (!longPredicate.test(keyIterator.nextValue())) continue;
                keyIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Long> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.contains((Long)object);
        }

        public boolean contains(long l2) {
            return Long2LongHashMap.this.containsValue(l2);
        }

        public boolean removeIfLong(LongPredicate longPredicate) {
            boolean bl2 = false;
            ValueIterator valueIterator = this.iterator();
            while (valueIterator.hasNext()) {
                if (!longPredicate.test(valueIterator.nextValue())) continue;
                valueIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Long> {
        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Long> {
        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int n2;
            this.isPositionValid = false;
            this.remaining = Long2LongHashMap.this.size;
            long l2 = Long2LongHashMap.this.missingValue;
            long[] lArray = Long2LongHashMap.this.entries;
            int n3 = n2 = lArray.length;
            if (l2 != lArray[n2 - 1]) {
                for (int i2 = 1; i2 < n2; i2 += 2) {
                    if (l2 != lArray[i2]) continue;
                    n3 = i2 - 1;
                    break;
                }
            }
            this.stopCounter = n3;
            this.positionCounter = n3 + n2;
        }

        protected final int keyPosition() {
            return this.positionCounter & Long2LongHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] lArray = Long2LongHashMap.this.entries;
            long l2 = Long2LongHashMap.this.missingValue;
            int n2 = lArray.length - 1;
            int n3 = this.stopCounter;
            for (int i2 = this.positionCounter - 2; i2 >= n3; i2 -= 2) {
                int n4 = i2 & n2;
                if (l2 == lArray[n4 + 1]) continue;
                this.isPositionValid = true;
                this.positionCounter = i2;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            int n2;
            if (this.isPositionValid) {
                n2 = this.keyPosition();
                Long2LongHashMap.this.entries[n2 + 1] = Long2LongHashMap.this.missingValue;
                --Long2LongHashMap.this.size;
            } else {
                throw new IllegalStateException();
            }
            Long2LongHashMap.this.compactChain(n2);
            this.isPositionValid = false;
        }
    }
}

