/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.agrona.AbstractMutableDirectBuffer;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;

public class ExpandableArrayBuffer
extends AbstractMutableDirectBuffer {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    public static final int INITIAL_CAPACITY = 128;

    public ExpandableArrayBuffer() {
        this(128);
    }

    public ExpandableArrayBuffer(int n2) {
        this.byteArray = new byte[n2];
        this.capacity = n2;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET;
    }

    @Override
    public void wrap(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer byteBuffer, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer directBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer directBuffer, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long l2, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer byteBuffer() {
        return null;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public int wrapAdjustment() {
        return 0;
    }

    @Override
    public void checkLimit(int n2) {
        this.ensureCapacity(n2, 0);
    }

    public String toString() {
        return "ExpandableArrayBuffer{, capacity=" + this.capacity + ", byteArray=" + (String)(null == this.byteArray ? "null" : "byte[" + this.byteArray.length + "]") + "}";
    }

    @Override
    protected final void ensureCapacity(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException("negative value: index=" + n2 + " length=" + n3);
        }
        long l2 = (long)n2 + (long)n3;
        if (l2 > (long)this.capacity) {
            if (l2 > 0x7FFFFFF7L) {
                throw new IndexOutOfBoundsException("index=" + n2 + " length=" + n3 + " maxCapacity=2147483639");
            }
            int n4 = ExpandableArrayBuffer.calculateExpansion(this.capacity, l2);
            this.byteArray = Arrays.copyOf(this.byteArray, n4);
            this.capacity = n4;
        }
    }

    private static int calculateExpansion(int n2, long l2) {
        long l3 = Math.max(n2, 2);
        while (l3 < l2) {
            if ((l3 += l3 >> 1) <= 0x7FFFFFF7L) continue;
            l3 = 0x7FFFFFF7L;
        }
        return (int)l3;
    }
}

