/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.OptionalMethod;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
        this.sslParametersClass = clazz;
        this.setUseSessionTickets = optionalMethod;
        this.setHostname = optionalMethod2;
        this.getAlpnSelectedProtocol = optionalMethod3;
        this.setAlpnProtocols = optionalMethod4;
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        try {
            socket.connect(inetSocketAddress, n2);
        }
        catch (AssertionError assertionError) {
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)assertionError));
            }
            throw assertionError;
        }
        catch (SecurityException securityException) {
            IOException iOException = new IOException("Exception in connect");
            iOException.initCause(securityException);
            throw iOException;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                IOException iOException = new IOException("Exception in connect");
                iOException.initCause(classCastException);
                throw iOException;
            }
            throw classCastException;
        }
    }

    @Override
    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        Object object;
        Object object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, this.sslParametersClass, "sslParameters");
        if (object2 == null) {
            try {
                object = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sSLSocketFactory.getClass().getClassLoader());
                object2 = AndroidPlatform.readFieldOrNull(sSLSocketFactory, object, "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager(sSLSocketFactory);
            }
        }
        if ((object = AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "x509TrustManager")) != null) {
            return object;
        }
        return AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
        if (string != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sSLSocket, true);
            this.setHostname.invokeOptionalWithoutCheckedException(sSLSocket, string);
        }
        if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sSLSocket)) {
            Object[] objectArray = new Object[]{AndroidPlatform.concatLengthPrefixed(list)};
            this.setAlpnProtocols.invokeWithoutCheckedException(sSLSocket, objectArray);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        if (this.getAlpnSelectedProtocol == null) {
            return null;
        }
        if (!this.getAlpnSelectedProtocol.isSupported(sSLSocket)) {
            return null;
        }
        byte[] byArray = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(sSLSocket, new Object[0]);
        return byArray != null ? new String(byArray, Util.UTF_8) : null;
    }

    @Override
    public void log(int n2, String string, Throwable throwable) {
        int n3;
        int n4 = n3 = n2 == 5 ? 5 : 3;
        if (throwable != null) {
            string = string + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        int n5 = string.length();
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6;
            int n7 = string.indexOf(10, i2);
            n7 = n7 != -1 ? n7 : n5;
            do {
                n6 = Math.min(n7, i2 + 4000);
                Log.println((int)n3, (String)"OkHttp", (String)string.substring(i2, n6));
            } while ((i2 = n6) < n7);
        }
    }

    @Override
    public Object getStackTraceForCloseable(String string) {
        return this.closeGuard.createAndOpen(string);
    }

    @Override
    public void logCloseableLeak(String string, Object object) {
        boolean bl2 = this.closeGuard.warnIfOpen(object);
        if (!bl2) {
            this.log(5, string, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String string) {
        try {
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            return this.api24IsCleartextTrafficPermitted(string, clazz, object);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return super.isCleartextTrafficPermitted(string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw Util.assertionError("unable to determine cleartext support", exception);
        }
    }

    private boolean api24IsCleartextTrafficPermitted(String string, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = clazz.getMethod("isCleartextTrafficPermitted", String.class);
            return (Boolean)method.invoke(object, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(string, clazz, object);
        }
    }

    private boolean api23IsCleartextTrafficPermitted(String string, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = clazz.getMethod("isCleartextTrafficPermitted", new Class[0]);
            return (Boolean)method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string);
        }
    }

    private static boolean supportsAlpn() {
        if (Security.getProvider("GMSCore_OpenSSL") != null) {
            return true;
        }
        try {
            Class.forName("android.net.Network");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        try {
            Class<?> clazz = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = clazz.getConstructor(X509TrustManager.class);
            Object obj = constructor.newInstance(x509TrustManager);
            Method method = clazz.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(obj, method);
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> optionalMethod = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> optionalMethod2 = new OptionalMethod<Socket>(null, "setHostname", String.class);
            OptionalMethod<Socket> optionalMethod3 = null;
            OptionalMethod optionalMethod4 = null;
            if (AndroidPlatform.supportsAlpn()) {
                optionalMethod3 = new OptionalMethod<Socket>(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                optionalMethod4 = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
            }
            return new AndroidPlatform(clazz, optionalMethod, optionalMethod2, optionalMethod3, optionalMethod4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        try {
            Method method = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            method.setAccessible(true);
            return new AndroidTrustRootIndex(x509TrustManager, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
    }

    static final class AndroidTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        AndroidTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.findByIssuerAndSignatureMethod = method;
            this.trustManager = x509TrustManager;
        }

        @Override
        public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
            try {
                TrustAnchor trustAnchor = (TrustAnchor)this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, x509Certificate);
                return trustAnchor != null ? trustAnchor.getTrustedCert() : null;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Util.assertionError("unable to get issues and signature", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AndroidTrustRootIndex)) {
                return false;
            }
            AndroidTrustRootIndex androidTrustRootIndex = (AndroidTrustRootIndex)object;
            return this.trustManager.equals(androidTrustRootIndex.trustManager) && this.findByIssuerAndSignatureMethod.equals(androidTrustRootIndex.findByIssuerAndSignatureMethod);
        }

        public int hashCode() {
            return this.trustManager.hashCode() + 31 * this.findByIssuerAndSignatureMethod.hashCode();
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method method, Method method2, Method method3) {
            this.getMethod = method;
            this.openMethod = method2;
            this.warnIfOpenMethod = method3;
        }

        Object createAndOpen(String string) {
            if (this.getMethod != null) {
                try {
                    Object object = this.getMethod.invoke(null, new Object[0]);
                    this.openMethod.invoke(object, string);
                    return object;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        boolean warnIfOpen(Object object) {
            boolean bl2 = false;
            if (object != null) {
                try {
                    this.warnIfOpenMethod.invoke(object, new Object[0]);
                    bl2 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl2;
        }

        static CloseGuard get() {
            Method method;
            Method method2;
            Method method3;
            try {
                Class<?> clazz = Class.forName("dalvik.system.CloseGuard");
                method3 = clazz.getMethod("get", new Class[0]);
                method2 = clazz.getMethod("open", String.class);
                method = clazz.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception exception) {
                method3 = null;
                method2 = null;
                method = null;
            }
            return new CloseGuard(method3, method2, method);
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.x509TrustManagerExtensions = object;
            this.checkServerTrusted = method;
        }

        @Override
        public List<Certificate> clean(List<Certificate> list, String string) throws SSLPeerUnverifiedException {
            try {
                X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[list.size()]);
                return (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, x509CertificateArray, "RSA", string);
            }
            catch (InvocationTargetException invocationTargetException) {
                SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                sSLPeerUnverifiedException.initCause(invocationTargetException);
                throw sSLPeerUnverifiedException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        public boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }
}

