/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

final class Http2Reader
implements Closeable {
    static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSource source;
    private final ContinuationSource continuation;
    private final boolean client;
    final Hpack.Reader hpackReader;

    Http2Reader(BufferedSource bufferedSource, boolean bl2) {
        this.source = bufferedSource;
        this.client = bl2;
        this.continuation = new ContinuationSource(this.source);
        this.hpackReader = new Hpack.Reader(4096, this.continuation);
    }

    public void readConnectionPreface(Handler handler) throws IOException {
        if (this.client) {
            if (!this.nextFrame(true, handler)) {
                throw Http2.ioException("Required SETTINGS preface not received", new Object[0]);
            }
        } else {
            ByteString byteString = this.source.readByteString(Http2.CONNECTION_PREFACE.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format("<< CONNECTION %s", byteString.hex()));
            }
            if (!Http2.CONNECTION_PREFACE.equals(byteString)) {
                throw Http2.ioException("Expected a connection header but was %s", byteString.utf8());
            }
        }
    }

    public boolean nextFrame(boolean bl2, Handler handler) throws IOException {
        try {
            this.source.require(9L);
        }
        catch (IOException iOException) {
            return false;
        }
        int n2 = Http2Reader.readMedium(this.source);
        if (n2 < 0 || n2 > 16384) {
            throw Http2.ioException("FRAME_SIZE_ERROR: %s", n2);
        }
        byte by2 = (byte)(this.source.readByte() & 0xFF);
        if (bl2 && by2 != 4) {
            throw Http2.ioException("Expected a SETTINGS frame but was %s", by2);
        }
        byte by3 = (byte)(this.source.readByte() & 0xFF);
        int n3 = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(true, n3, n2, by2, by3));
        }
        switch (by2) {
            case 0: {
                this.readData(handler, n2, by3, n3);
                break;
            }
            case 1: {
                this.readHeaders(handler, n2, by3, n3);
                break;
            }
            case 2: {
                this.readPriority(handler, n2, by3, n3);
                break;
            }
            case 3: {
                this.readRstStream(handler, n2, by3, n3);
                break;
            }
            case 4: {
                this.readSettings(handler, n2, by3, n3);
                break;
            }
            case 5: {
                this.readPushPromise(handler, n2, by3, n3);
                break;
            }
            case 6: {
                this.readPing(handler, n2, by3, n3);
                break;
            }
            case 7: {
                this.readGoAway(handler, n2, by3, n3);
                break;
            }
            case 8: {
                this.readWindowUpdate(handler, n2, by3, n3);
                break;
            }
            default: {
                this.source.skip(n2);
            }
        }
        return true;
    }

    private void readHeaders(Handler handler, int n2, byte by2, int n3) throws IOException {
        short s2;
        if (n3 == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
        }
        boolean bl2 = (by2 & 1) != 0;
        short s3 = s2 = (by2 & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        if ((by2 & 0x20) != 0) {
            this.readPriority(handler, n3);
            n2 -= 5;
        }
        n2 = Http2Reader.lengthWithoutPadding(n2, by2, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by2, n3);
        handler.headers(bl2, n3, -1, list);
    }

    private List<Header> readHeaderBlock(int n2, short s2, byte by2, int n3) throws IOException {
        this.continuation.length = this.continuation.left = n2;
        this.continuation.padding = s2;
        this.continuation.flags = by2;
        this.continuation.streamId = n3;
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private void readData(Handler handler, int n2, byte by2, int n3) throws IOException {
        boolean bl2;
        if (n3 == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_DATA streamId == 0", new Object[0]);
        }
        boolean bl3 = (by2 & 1) != 0;
        boolean bl4 = bl2 = (by2 & 0x20) != 0;
        if (bl2) {
            throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
        }
        short s2 = (by2 & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        n2 = Http2Reader.lengthWithoutPadding(n2, by2, s2);
        handler.data(bl3, n3, this.source, n2);
        this.source.skip(s2);
    }

    private void readPriority(Handler handler, int n2, byte by2, int n3) throws IOException {
        if (n2 != 5) {
            throw Http2.ioException("TYPE_PRIORITY length: %d != 5", n2);
        }
        if (n3 == 0) {
            throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
        }
        this.readPriority(handler, n3);
    }

    private void readPriority(Handler handler, int n2) throws IOException {
        int n3 = this.source.readInt();
        boolean bl2 = (n3 & Integer.MIN_VALUE) != 0;
        int n4 = n3 & Integer.MAX_VALUE;
        int n5 = (this.source.readByte() & 0xFF) + 1;
        handler.priority(n2, n4, n5, bl2);
    }

    private void readRstStream(Handler handler, int n2, byte by2, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", n2);
        }
        if (n3 == 0) {
            throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
        }
        int n4 = this.source.readInt();
        ErrorCode errorCode = ErrorCode.fromHttp2(n4);
        if (errorCode == null) {
            throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", n4);
        }
        handler.rstStream(n3, errorCode);
    }

    private void readSettings(Handler handler, int n2, byte by2, int n3) throws IOException {
        if (n3 != 0) {
            throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
        }
        if ((by2 & 1) != 0) {
            if (n2 != 0) {
                throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
            }
            handler.ackSettings();
            return;
        }
        if (n2 % 6 != 0) {
            throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", n2);
        }
        Settings settings = new Settings();
        for (int i2 = 0; i2 < n2; i2 += 6) {
            int n4 = this.source.readShort() & 0xFFFF;
            int n5 = this.source.readInt();
            switch (n4) {
                case 1: {
                    break;
                }
                case 2: {
                    if (n5 == 0 || n5 == 1) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                }
                case 3: {
                    n4 = 4;
                    break;
                }
                case 4: {
                    n4 = 7;
                    if (n5 >= 0) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                }
                case 5: {
                    if (n5 >= 16384 && n5 <= 0xFFFFFF) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", n5);
                }
                case 6: {
                    break;
                }
            }
            settings.set(n4, n5);
        }
        handler.settings(false, settings);
    }

    private void readPushPromise(Handler handler, int n2, byte by2, int n3) throws IOException {
        if (n3 == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
        }
        short s2 = (by2 & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        int n4 = this.source.readInt() & Integer.MAX_VALUE;
        n2 -= 4;
        n2 = Http2Reader.lengthWithoutPadding(n2, by2, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by2, n3);
        handler.pushPromise(n3, n4, list);
    }

    private void readPing(Handler handler, int n2, byte by2, int n3) throws IOException {
        if (n2 != 8) {
            throw Http2.ioException("TYPE_PING length != 8: %s", n2);
        }
        if (n3 != 0) {
            throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
        }
        int n4 = this.source.readInt();
        int n5 = this.source.readInt();
        boolean bl2 = (by2 & 1) != 0;
        handler.ping(bl2, n4, n5);
    }

    private void readGoAway(Handler handler, int n2, byte by2, int n3) throws IOException {
        if (n2 < 8) {
            throw Http2.ioException("TYPE_GOAWAY length < 8: %s", n2);
        }
        if (n3 != 0) {
            throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
        }
        int n4 = this.source.readInt();
        int n5 = this.source.readInt();
        int n6 = n2 - 8;
        ErrorCode errorCode = ErrorCode.fromHttp2(n5);
        if (errorCode == null) {
            throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", n5);
        }
        ByteString byteString = ByteString.EMPTY;
        if (n6 > 0) {
            byteString = this.source.readByteString(n6);
        }
        handler.goAway(n4, errorCode, byteString);
    }

    private void readWindowUpdate(Handler handler, int n2, byte by2, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", n2);
        }
        long l2 = (long)this.source.readInt() & Integer.MAX_VALUE;
        if (l2 == 0L) {
            throw Http2.ioException("windowSizeIncrement was 0", l2);
        }
        handler.windowUpdate(n3, l2);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    static int readMedium(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    static int lengthWithoutPadding(int n2, byte by2, short s2) throws IOException {
        if ((by2 & 8) != 0) {
            --n2;
        }
        if (s2 > n2) {
            throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", s2, n2);
        }
        return (short)(n2 - s2);
    }

    static interface Handler {
        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, List<Header> var4);

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Header> var3) throws IOException;

        public void alternateService(int var1, String var2, ByteString var3, String var4, int var5, long var6);
    }

    static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        int length;
        byte flags;
        int streamId;
        int left;
        short padding;

        ContinuationSource(BufferedSource bufferedSource) {
            this.source = bufferedSource;
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            while (this.left == 0) {
                this.source.skip(this.padding);
                this.padding = 0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long l3 = this.source.read(buffer, Math.min(l2, (long)this.left));
            if (l3 == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - l3);
            return l3;
        }

        @Override
        public Timeout timeout() {
            return this.source.timeout();
        }

        @Override
        public void close() throws IOException {
        }

        private void readContinuationHeader() throws IOException {
            int n2 = this.streamId;
            this.length = this.left = Http2Reader.readMedium(this.source);
            byte by2 = (byte)(this.source.readByte() & 0xFF);
            this.flags = (byte)(this.source.readByte() & 0xFF);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.frameLog(true, this.streamId, this.length, by2, this.flags));
            }
            this.streamId = this.source.readInt() & Integer.MAX_VALUE;
            if (by2 != 9) {
                throw Http2.ioException("%s != TYPE_CONTINUATION", by2);
            }
            if (this.streamId != n2) {
                throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
        }
    }
}

