/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

final class Hpack {
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    static final Header[] STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
    static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();

    private Hpack() {
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap<ByteString, Integer> linkedHashMap = new LinkedHashMap<ByteString, Integer>(STATIC_HEADER_TABLE.length);
        for (int i2 = 0; i2 < STATIC_HEADER_TABLE.length; ++i2) {
            if (linkedHashMap.containsKey(Hpack.STATIC_HEADER_TABLE[i2].name)) continue;
            linkedHashMap.put(Hpack.STATIC_HEADER_TABLE[i2].name, i2);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n2 = byteString.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2 = byteString.getByte(i2);
            if (by2 < 65 || by2 > 90) continue;
            throw new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + byteString.utf8());
        }
        return byteString;
    }

    static final class Writer {
        private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
        private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
        private final Buffer out;
        private final boolean useCompression;
        private int smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        private boolean emitDynamicTableSizeUpdate;
        int headerTableSizeSetting;
        int maxDynamicTableByteCount;
        Header[] dynamicTable = new Header[8];
        int nextHeaderIndex = this.dynamicTable.length - 1;
        int headerCount = 0;
        int dynamicTableByteCount = 0;

        Writer(Buffer buffer) {
            this(4096, true, buffer);
        }

        Writer(int n2, boolean bl2, Buffer buffer) {
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n2;
            this.useCompression = bl2;
            this.out = buffer;
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            if (n2 > 0) {
                for (int i2 = this.dynamicTable.length - 1; i2 >= this.nextHeaderIndex && n2 > 0; --i2) {
                    n2 -= this.dynamicTable[i2].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[i2].hpackSize;
                    --this.headerCount;
                    ++n3;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
                Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + n3, null);
                this.nextHeaderIndex += n3;
            }
            return n3;
        }

        private void insertIntoDynamicTable(Header header) {
            int n2 = header.hpackSize;
            if (n2 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n3 = this.dynamicTableByteCount + n2 - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(n3);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray = new Header[this.dynamicTable.length * 2];
                System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            int n4 = this.nextHeaderIndex--;
            this.dynamicTable[n4] = header;
            ++this.headerCount;
            this.dynamicTableByteCount += n2;
        }

        void writeHeaders(List<Header> list) throws IOException {
            if (this.emitDynamicTableSizeUpdate) {
                if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                    this.writeInt(this.smallestHeaderTableSizeSetting, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Header header = list.get(i2);
                ByteString byteString = header.name.toAsciiLowercase();
                ByteString byteString2 = header.value;
                int n3 = -1;
                int n4 = -1;
                Integer n5 = NAME_TO_FIRST_INDEX.get(byteString);
                if (n5 != null && (n4 = n5 + 1) > 1 && n4 < 8) {
                    if (Util.equal(Hpack.STATIC_HEADER_TABLE[n4 - 1].value, byteString2)) {
                        n3 = n4;
                    } else if (Util.equal(Hpack.STATIC_HEADER_TABLE[n4].value, byteString2)) {
                        n3 = n4 + 1;
                    }
                }
                if (n3 == -1) {
                    int n6 = this.dynamicTable.length;
                    for (int i3 = this.nextHeaderIndex + 1; i3 < n6; ++i3) {
                        if (!Util.equal(this.dynamicTable[i3].name, byteString)) continue;
                        if (Util.equal(this.dynamicTable[i3].value, byteString2)) {
                            n3 = i3 - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                            break;
                        }
                        if (n4 != -1) continue;
                        n4 = i3 - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                    }
                }
                if (n3 != -1) {
                    this.writeInt(n3, 127, 128);
                    continue;
                }
                if (n4 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(byteString);
                    this.writeByteString(byteString2);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (byteString.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals(byteString)) {
                    this.writeInt(n4, 15, 0);
                    this.writeByteString(byteString2);
                    continue;
                }
                this.writeInt(n4, 63, 64);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
            }
        }

        void writeInt(int n2, int n3, int n4) {
            if (n2 < n3) {
                this.out.writeByte(n4 | n2);
                return;
            }
            this.out.writeByte(n4 | n3);
            n2 -= n3;
            while (n2 >= 128) {
                int n5 = n2 & 0x7F;
                this.out.writeByte(n5 | 0x80);
                n2 >>>= 7;
            }
            this.out.writeByte(n2);
        }

        void writeByteString(ByteString byteString) throws IOException {
            if (this.useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
                Buffer buffer = new Buffer();
                Huffman.get().encode(byteString, buffer);
                ByteString byteString2 = buffer.readByteString();
                this.writeInt(byteString2.size(), 127, 128);
                this.out.write(byteString2);
            } else {
                this.writeInt(byteString.size(), 127, 0);
                this.out.write(byteString);
            }
        }

        void setHeaderTableSizeSetting(int n2) {
            this.headerTableSizeSetting = n2;
            int n3 = Math.min(n2, 16384);
            if (this.maxDynamicTableByteCount == n3) {
                return;
            }
            if (n3 < this.maxDynamicTableByteCount) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n3);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n3;
            this.adjustDynamicTableByteCount();
        }

        private void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }
    }

    static final class Reader {
        private final List<Header> headerList = new ArrayList<Header>();
        private final BufferedSource source;
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        Header[] dynamicTable = new Header[8];
        int nextHeaderIndex = this.dynamicTable.length - 1;
        int headerCount = 0;
        int dynamicTableByteCount = 0;

        Reader(int n2, Source source) {
            this(n2, n2, source);
        }

        Reader(int n2, int n3, Source source) {
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n3;
            this.source = Okio.buffer(source);
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        private void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            if (n2 > 0) {
                for (int i2 = this.dynamicTable.length - 1; i2 >= this.nextHeaderIndex && n2 > 0; --i2) {
                    n2 -= this.dynamicTable[i2].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[i2].hpackSize;
                    --this.headerCount;
                    ++n3;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
                this.nextHeaderIndex += n3;
            }
            return n3;
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n2;
                int n3 = this.source.readByte() & 0xFF;
                if (n3 == 128) {
                    throw new IOException("index == 0");
                }
                if ((n3 & 0x80) == 128) {
                    n2 = this.readInt(n3, 127);
                    this.readIndexedHeader(n2 - 1);
                    continue;
                }
                if (n3 == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((n3 & 0x40) == 64) {
                    n2 = this.readInt(n3, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(n2 - 1);
                    continue;
                }
                if ((n3 & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(n3, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (n3 == 16 || n3 == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                n2 = this.readInt(n3, 15);
                this.readLiteralHeaderWithoutIndexingIndexedName(n2 - 1);
            }
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        private void readIndexedHeader(int n2) throws IOException {
            if (this.isStaticHeader(n2)) {
                Header header = STATIC_HEADER_TABLE[n2];
                this.headerList.add(header);
            } else {
                int n3 = this.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
                if (n3 < 0 || n3 >= this.dynamicTable.length) {
                    throw new IOException("Header index too large " + (n2 + 1));
                }
                this.headerList.add(this.dynamicTable[n3]);
            }
        }

        private int dynamicTableIndex(int n2) {
            return this.nextHeaderIndex + 1 + n2;
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n2) throws IOException {
            ByteString byteString = this.getName(n2);
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n2) throws IOException {
            ByteString byteString = this.getName(n2);
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private ByteString getName(int n2) throws IOException {
            if (this.isStaticHeader(n2)) {
                return Hpack.STATIC_HEADER_TABLE[n2].name;
            }
            int n3 = this.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
            if (n3 < 0 || n3 >= this.dynamicTable.length) {
                throw new IOException("Header index too large " + (n2 + 1));
            }
            return this.dynamicTable[n3].name;
        }

        private boolean isStaticHeader(int n2) {
            return n2 >= 0 && n2 <= STATIC_HEADER_TABLE.length - 1;
        }

        private void insertIntoDynamicTable(int n2, Header header) {
            this.headerList.add(header);
            int n3 = header.hpackSize;
            if (n2 != -1) {
                n3 -= this.dynamicTable[this.dynamicTableIndex((int)n2)].hpackSize;
            }
            if (n3 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n4 = this.dynamicTableByteCount + n3 - this.maxDynamicTableByteCount;
            int n5 = this.evictToRecoverBytes(n4);
            if (n2 == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray = new Header[this.dynamicTable.length * 2];
                    System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                n2 = this.nextHeaderIndex--;
                this.dynamicTable[n2] = header;
                ++this.headerCount;
            } else {
                n2 += this.dynamicTableIndex(n2) + n5;
                this.dynamicTable[n2] = header;
            }
            this.dynamicTableByteCount += n3;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        int readInt(int n2, int n3) throws IOException {
            int n4;
            int n5 = n2 & n3;
            if (n5 < n3) {
                return n5;
            }
            int n6 = n3;
            int n7 = 0;
            while (((n4 = this.readByte()) & 0x80) != 0) {
                n6 += (n4 & 0x7F) << n7;
                n7 += 7;
            }
            return n6 += n4 << n7;
        }

        ByteString readByteString() throws IOException {
            int n2 = this.readByte();
            boolean bl2 = (n2 & 0x80) == 128;
            int n3 = this.readInt(n2, 127);
            if (bl2) {
                return ByteString.of(Huffman.get().decode(this.source.readByteArray(n3)));
            }
            return this.source.readByteString(n3);
        }
    }
}

