/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import okhttp3.ConnectionSpec;
import okhttp3.internal.Internal;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private int nextModeIndex = 0;
    private boolean isFallbackPossible;
    private boolean isFallback;

    public ConnectionSpecSelector(List<ConnectionSpec> list) {
        this.connectionSpecs = list;
    }

    public ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) throws IOException {
        ConnectionSpec connectionSpec = null;
        int n2 = this.connectionSpecs.size();
        for (int i2 = this.nextModeIndex; i2 < n2; ++i2) {
            ConnectionSpec connectionSpec2 = this.connectionSpecs.get(i2);
            if (!connectionSpec2.isCompatible(sSLSocket)) continue;
            connectionSpec = connectionSpec2;
            this.nextModeIndex = i2 + 1;
            break;
        }
        if (connectionSpec == null) {
            throw new UnknownServiceException("Unable to find acceptable protocols. isFallback=" + this.isFallback + ", modes=" + this.connectionSpecs + ", supported protocols=" + Arrays.toString(sSLSocket.getEnabledProtocols()));
        }
        this.isFallbackPossible = this.isFallbackPossible(sSLSocket);
        Internal.instance.apply(connectionSpec, sSLSocket, this.isFallback);
        return connectionSpec;
    }

    public boolean connectionFailed(IOException iOException) {
        this.isFallback = true;
        if (!this.isFallbackPossible) {
            return false;
        }
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        if (iOException instanceof SSLPeerUnverifiedException) {
            return false;
        }
        return iOException instanceof SSLHandshakeException || iOException instanceof SSLProtocolException;
    }

    private boolean isFallbackPossible(SSLSocket sSLSocket) {
        for (int i2 = this.nextModeIndex; i2 < this.connectionSpecs.size(); ++i2) {
            if (!this.connectionSpecs.get(i2).isCompatible(sSLSocket)) continue;
            return true;
        }
        return false;
    }
}

