/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.Buffer;

public final class HttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    final String scheme;
    private final String username;
    private final String password;
    final String host;
    final int port;
    private final List<String> pathSegments;
    @Nullable
    private final List<String> queryNamesAndValues;
    @Nullable
    private final String fragment;
    private final String url;

    HttpUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.username = HttpUrl.percentDecode(builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        this.queryNamesAndValues = builder.encodedQueryNamesAndValues != null ? this.percentDecode(builder.encodedQueryNamesAndValues, true) : null;
        this.fragment = builder.encodedFragment != null ? HttpUrl.percentDecode(builder.encodedFragment, false) : null;
        this.url = builder.toString();
    }

    public URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public URI uri() {
        String string = this.newBuilder().reencodeForUri().toString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                String string2 = string.replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", FRAGMENT_ENCODE_SET);
                return URI.create(string2);
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.scheme.length() + 3;
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), ":@");
        return this.url.substring(n2, n3);
    }

    public String username() {
        return this.username;
    }

    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.url.indexOf(58, this.scheme.length() + 3) + 1;
        int n3 = this.url.indexOf(64);
        return this.url.substring(n2, n3);
    }

    public String password() {
        return this.password;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public static int defaultPort(String string) {
        if (string.equals("http")) {
            return 80;
        }
        if (string.equals("https")) {
            return 443;
        }
        return -1;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public String encodedPath() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), "?#");
        return this.url.substring(n2, n3);
    }

    static void pathSegmentsToString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i2));
        }
    }

    public List<String> encodedPathSegments() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), "?#");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n2;
        while (n4 < n3) {
            int n5 = Util.delimiterOffset(this.url, ++n4, n3, '/');
            arrayList.add(this.url.substring(n4, n5));
            n4 = n5;
        }
        return arrayList;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    @Nullable
    public String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n2 = this.url.indexOf(63) + 1;
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), '#');
        return this.url.substring(n2, n3);
    }

    static void namesAndValuesToQueryString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string = list.get(i2);
            String string2 = list.get(i2 + 1);
            if (i2 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
    }

    static List<String> queryStringToNamesAndValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 <= string.length()) {
            int n3;
            int n4 = string.indexOf(38, n2);
            if (n4 == -1) {
                n4 = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) == -1 || n3 > n4) {
                arrayList.add(string.substring(n2, n4));
                arrayList.add(null);
            } else {
                arrayList.add(string.substring(n2, n3));
                arrayList.add(string.substring(n3 + 1, n4));
            }
            n2 = n4 + 1;
        }
        return arrayList;
    }

    @Nullable
    public String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    public int querySize() {
        return this.queryNamesAndValues != null ? this.queryNamesAndValues.size() / 2 : 0;
    }

    @Nullable
    public String queryParameter(String string) {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i2))) continue;
            return this.queryNamesAndValues.get(i2 + 1);
        }
        return null;
    }

    public Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            linkedHashSet.add(this.queryNamesAndValues.get(i2));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public List<String> queryParameterValues(String string) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i2))) continue;
            arrayList.add(this.queryNamesAndValues.get(i2 + 1));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String queryParameterName(int n2) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(n2 * 2);
    }

    public String queryParameterValue(int n2) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(n2 * 2 + 1);
    }

    @Nullable
    public String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int n2 = this.url.indexOf(35) + 1;
        return this.url.substring(n2);
    }

    @Nullable
    public String fragment() {
        return this.fragment;
    }

    public String redact() {
        return this.newBuilder("/...").username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public HttpUrl resolve(String string) {
        Builder builder = this.newBuilder(string);
        return builder != null ? builder.build() : null;
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.scheme = this.scheme;
        builder.encodedUsername = this.encodedUsername();
        builder.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        builder.port = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        builder.encodedPathSegments.clear();
        builder.encodedPathSegments.addAll(this.encodedPathSegments());
        builder.encodedQuery(this.encodedQuery());
        builder.encodedFragment = this.encodedFragment();
        return builder;
    }

    @Nullable
    public Builder newBuilder(String string) {
        Builder builder = new Builder();
        Builder.ParseResult parseResult = builder.parse(this, string);
        return parseResult == Builder.ParseResult.SUCCESS ? builder : null;
    }

    @Nullable
    public static HttpUrl parse(String string) {
        Builder builder = new Builder();
        Builder.ParseResult parseResult = builder.parse(null, string);
        return parseResult == Builder.ParseResult.SUCCESS ? builder.build() : null;
    }

    @Nullable
    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    static HttpUrl getChecked(String string) throws MalformedURLException, UnknownHostException {
        Builder builder = new Builder();
        Builder.ParseResult parseResult = builder.parse(null, string);
        switch (parseResult) {
            case SUCCESS: {
                return builder.build();
            }
            case INVALID_HOST: {
                throw new UnknownHostException("Invalid host: " + string);
            }
        }
        throw new MalformedURLException("Invalid URL: " + (Object)((Object)parseResult) + " for " + string);
    }

    @Nullable
    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof HttpUrl && ((HttpUrl)object).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    @Nullable
    public String topPrivateDomain() {
        if (Util.verifyAsIpAddress(this.host)) {
            return null;
        }
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    static String percentDecode(String string, boolean bl2) {
        return HttpUrl.percentDecode(string, 0, string.length(), bl2);
    }

    private List<String> percentDecode(List<String> list, boolean bl2) {
        int n2 = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = list.get(i2);
            arrayList.add(string != null ? HttpUrl.percentDecode(string, bl2) : null);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String percentDecode(String string, int n2, int n3, boolean bl2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '%' && (c2 != '+' || !bl2)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n2, i2);
            HttpUrl.percentDecode(buffer, string, i2, n3, bl2);
            return buffer.readUtf8();
        }
        return string.substring(n2, n3);
    }

    static void percentDecode(Buffer buffer, String string, int n2, int n3, boolean bl2) {
        int n4;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (n4 == 37 && i2 + 2 < n3) {
                int n5 = Util.decodeHexDigit(string.charAt(i2 + 1));
                int n6 = Util.decodeHexDigit(string.charAt(i2 + 2));
                if (n5 != -1 && n6 != -1) {
                    buffer.writeByte((n5 << 4) + n6);
                    i2 += 2;
                    continue;
                }
            } else if (n4 == 43 && bl2) {
                buffer.writeByte(32);
                continue;
            }
            buffer.writeUtf8CodePoint(n4);
        }
    }

    static boolean percentEncoded(String string, int n2, int n3) {
        return n2 + 2 < n3 && string.charAt(n2) == '%' && Util.decodeHexDigit(string.charAt(n2 + 1)) != -1 && Util.decodeHexDigit(string.charAt(n2 + 2)) != -1;
    }

    static String canonicalize(String string, int n2, int n3, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Charset charset) {
        int n4;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (!(n4 < 32 || n4 == 127 || n4 >= 128 && bl5 || string2.indexOf(n4) != -1 || n4 == 37 && (!bl2 || bl3 && !HttpUrl.percentEncoded(string, i2, n3))) && (n4 != 43 || !bl4)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n2, i2);
            HttpUrl.canonicalize(buffer, string, i2, n3, string2, bl2, bl3, bl4, bl5, charset);
            return buffer.readUtf8();
        }
        return string.substring(n2, n3);
    }

    static void canonicalize(Buffer buffer, String string, int n2, int n3, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Charset charset) {
        int n4;
        Buffer buffer2 = null;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (bl2 && (n4 == 9 || n4 == 10 || n4 == 12 || n4 == 13)) continue;
            if (n4 == 43 && bl4) {
                buffer.writeUtf8(bl2 ? "+" : "%2B");
                continue;
            }
            if (n4 < 32 || n4 == 127 || n4 >= 128 && bl5 || string2.indexOf(n4) != -1 || n4 == 37 && (!bl2 || bl3 && !HttpUrl.percentEncoded(string, i2, n3))) {
                if (buffer2 == null) {
                    buffer2 = new Buffer();
                }
                if (charset == null || charset.equals(Util.UTF_8)) {
                    buffer2.writeUtf8CodePoint(n4);
                } else {
                    buffer2.writeString(string, i2, i2 + Character.charCount(n4), charset);
                }
                while (!buffer2.exhausted()) {
                    int n5 = buffer2.readByte() & 0xFF;
                    buffer.writeByte(37);
                    buffer.writeByte(HEX_DIGITS[n5 >> 4 & 0xF]);
                    buffer.writeByte(HEX_DIGITS[n5 & 0xF]);
                }
                continue;
            }
            buffer.writeUtf8CodePoint(n4);
        }
    }

    static String canonicalize(String string, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Charset charset) {
        return HttpUrl.canonicalize(string, 0, string.length(), string2, bl2, bl3, bl4, bl5, charset);
    }

    static String canonicalize(String string, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return HttpUrl.canonicalize(string, 0, string.length(), string2, bl2, bl3, bl4, bl5, null);
    }

    public static final class Builder {
        @Nullable
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        @Nullable
        String host;
        int port = -1;
        final List<String> encodedPathSegments = new ArrayList<String>();
        @Nullable
        List<String> encodedQueryNamesAndValues;
        @Nullable
        String encodedFragment;

        public Builder() {
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        public Builder scheme(String string) {
            if (string == null) {
                throw new NullPointerException("scheme == null");
            }
            if (string.equalsIgnoreCase("http")) {
                this.scheme = "http";
            } else if (string.equalsIgnoreCase("https")) {
                this.scheme = "https";
            } else {
                throw new IllegalArgumentException("unexpected scheme: " + string);
            }
            return this;
        }

        public Builder username(String string) {
            if (string == null) {
                throw new NullPointerException("username == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedUsername(String string) {
            if (string == null) {
                throw new NullPointerException("encodedUsername == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder password(String string) {
            if (string == null) {
                throw new NullPointerException("password == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedPassword(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPassword == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder host(String string) {
            if (string == null) {
                throw new NullPointerException("host == null");
            }
            String string2 = Builder.canonicalizeHost(string, 0, string.length());
            if (string2 == null) {
                throw new IllegalArgumentException("unexpected host: " + string);
            }
            this.host = string2;
            return this;
        }

        public Builder port(int n2) {
            if (n2 <= 0 || n2 > 65535) {
                throw new IllegalArgumentException("unexpected port: " + n2);
            }
            this.port = n2;
            return this;
        }

        int effectivePort() {
            return this.port != -1 ? this.port : HttpUrl.defaultPort(this.scheme);
        }

        public Builder addPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException("pathSegment == null");
            }
            this.push(string, 0, string.length(), false, false);
            return this;
        }

        public Builder addPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException("pathSegments == null");
            }
            return this.addPathSegments(string, false);
        }

        public Builder addEncodedPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            this.push(string, 0, string.length(), false, true);
            return this;
        }

        public Builder addEncodedPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegments == null");
            }
            return this.addPathSegments(string, true);
        }

        private Builder addPathSegments(String string, boolean bl2) {
            int n2;
            int n3 = 0;
            do {
                boolean bl3 = (n2 = Util.delimiterOffset(string, n3, string.length(), "/\\")) < string.length();
                this.push(string, n3, n2, bl3, bl2);
            } while ((n3 = n2 + 1) <= string.length());
            return this;
        }

        public Builder setPathSegment(int n2, String string) {
            if (string == null) {
                throw new NullPointerException("pathSegment == null");
            }
            String string2 = HttpUrl.canonicalize(string, 0, string.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, false, false, false, true, null);
            if (this.isDot(string2) || this.isDotDot(string2)) {
                throw new IllegalArgumentException("unexpected path segment: " + string);
            }
            this.encodedPathSegments.set(n2, string2);
            return this;
        }

        public Builder setEncodedPathSegment(int n2, String string) {
            if (string == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            String string2 = HttpUrl.canonicalize(string, 0, string.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, true, false, false, true, null);
            this.encodedPathSegments.set(n2, string2);
            if (this.isDot(string2) || this.isDotDot(string2)) {
                throw new IllegalArgumentException("unexpected path segment: " + string);
            }
            return this;
        }

        public Builder removePathSegment(int n2) {
            this.encodedPathSegments.remove(n2);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        public Builder encodedPath(String string) {
            if (string == null) {
                throw new NullPointerException("encodedPath == null");
            }
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("unexpected encodedPath: " + string);
            }
            this.resolvePath(string, 0, string.length());
            return this;
        }

        public Builder query(@Nullable String string) {
            this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, HttpUrl.QUERY_ENCODE_SET, false, false, true, true)) : null;
            return this;
        }

        public Builder encodedQuery(@Nullable String string) {
            this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, HttpUrl.QUERY_ENCODE_SET, true, false, true, true)) : null;
            return this;
        }

        public Builder addQueryParameter(String string, @Nullable String string2) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
            this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null);
            return this;
        }

        public Builder addEncodedQueryParameter(String string, @Nullable String string2) {
            if (string == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true) : null);
            return this;
        }

        public Builder setQueryParameter(String string, @Nullable String string2) {
            this.removeAllQueryParameters(string);
            this.addQueryParameter(string, string2);
            return this;
        }

        public Builder setEncodedQueryParameter(String string, @Nullable String string2) {
            this.removeAllEncodedQueryParameters(string);
            this.addEncodedQueryParameter(string, string2);
            return this;
        }

        public Builder removeAllQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            String string2 = HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
            this.removeAllCanonicalQueryParameters(string2);
            return this;
        }

        public Builder removeAllEncodedQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            return this;
        }

        private void removeAllCanonicalQueryParameters(String string) {
            for (int i2 = this.encodedQueryNamesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!string.equals(this.encodedQueryNamesAndValues.get(i2))) continue;
                this.encodedQueryNamesAndValues.remove(i2 + 1);
                this.encodedQueryNamesAndValues.remove(i2);
                if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        public Builder fragment(@Nullable String string) {
            this.encodedFragment = string != null ? HttpUrl.canonicalize(string, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            return this;
        }

        public Builder encodedFragment(@Nullable String string) {
            this.encodedFragment = string != null ? HttpUrl.canonicalize(string, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            return this;
        }

        Builder reencodeForUri() {
            String string;
            int n2;
            int n3 = this.encodedPathSegments.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string = this.encodedPathSegments.get(n2);
                this.encodedPathSegments.set(n2, HttpUrl.canonicalize(string, HttpUrl.PATH_SEGMENT_ENCODE_SET_URI, true, true, false, true));
            }
            if (this.encodedQueryNamesAndValues != null) {
                n3 = this.encodedQueryNamesAndValues.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    string = this.encodedQueryNamesAndValues.get(n2);
                    if (string == null) continue;
                    this.encodedQueryNamesAndValues.set(n2, HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true, true));
                }
            }
            if (this.encodedFragment != null) {
                this.encodedFragment = HttpUrl.canonicalize(this.encodedFragment, HttpUrl.FRAGMENT_ENCODE_SET_URI, true, true, false, false);
            }
            return this;
        }

        public HttpUrl build() {
            if (this.scheme == null) {
                throw new IllegalStateException("scheme == null");
            }
            if (this.host == null) {
                throw new IllegalStateException("host == null");
            }
            return new HttpUrl(this);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme);
            stringBuilder.append("://");
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.encodedPassword);
                }
                stringBuilder.append('@');
            }
            if (this.host.indexOf(58) != -1) {
                stringBuilder.append('[');
                stringBuilder.append(this.host);
                stringBuilder.append(']');
            } else {
                stringBuilder.append(this.host);
            }
            int n2 = this.effectivePort();
            if (n2 != HttpUrl.defaultPort(this.scheme)) {
                stringBuilder.append(':');
                stringBuilder.append(n2);
            }
            HttpUrl.pathSegmentsToString(stringBuilder, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder.append('?');
                HttpUrl.namesAndValuesToQueryString(stringBuilder, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.encodedFragment);
            }
            return stringBuilder.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ParseResult parse(@Nullable HttpUrl httpUrl, String string) {
            int n2;
            int n3;
            int n4;
            int n5;
            block19: {
                n5 = Util.skipLeadingAsciiWhitespace(string, 0, string.length());
                int n6 = Builder.schemeDelimiterOffset(string, n5, n4 = Util.skipTrailingAsciiWhitespace(string, n5, string.length()));
                if (n6 != -1) {
                    if (string.regionMatches(true, n5, "https:", 0, 6)) {
                        this.scheme = "https";
                        n5 += "https:".length();
                    } else {
                        if (!string.regionMatches(true, n5, "http:", 0, 5)) return ParseResult.UNSUPPORTED_SCHEME;
                        this.scheme = "http";
                        n5 += "http:".length();
                    }
                } else {
                    if (httpUrl == null) return ParseResult.MISSING_SCHEME;
                    this.scheme = httpUrl.scheme;
                }
                boolean bl2 = false;
                boolean bl3 = false;
                int n7 = Builder.slashCount(string, n5, n4);
                if (n7 >= 2 || httpUrl == null || !httpUrl.scheme.equals(this.scheme)) {
                    n5 += n7;
                    while (true) {
                        n2 = (n3 = Util.delimiterOffset(string, n5, n4, "@/\\?#")) != n4 ? (int)string.charAt(n3) : -1;
                        switch (n2) {
                            case 64: {
                                int n8;
                                if (!bl3) {
                                    n8 = Util.delimiterOffset(string, n5, n3, ':');
                                    String string2 = HttpUrl.canonicalize(string, n5, n8, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    String string3 = this.encodedUsername = bl2 ? this.encodedUsername + "%40" + string2 : string2;
                                    if (n8 != n3) {
                                        bl3 = true;
                                        this.encodedPassword = HttpUrl.canonicalize(string, n8 + 1, n3, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    }
                                    bl2 = true;
                                } else {
                                    this.encodedPassword = this.encodedPassword + "%40" + HttpUrl.canonicalize(string, n5, n3, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                n5 = n3 + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                int n8 = Builder.portColonOffset(string, n5, n3);
                                if (n8 + 1 < n3) {
                                    this.host = Builder.canonicalizeHost(string, n5, n8);
                                    this.port = Builder.parsePort(string, n8 + 1, n3);
                                    if (this.port == -1) {
                                        return ParseResult.INVALID_PORT;
                                    }
                                } else {
                                    this.host = Builder.canonicalizeHost(string, n5, n8);
                                    this.port = HttpUrl.defaultPort(this.scheme);
                                }
                                if (this.host == null) {
                                    return ParseResult.INVALID_HOST;
                                }
                                n5 = n3;
                                break block19;
                            }
                        }
                    }
                }
                this.encodedUsername = httpUrl.encodedUsername();
                this.encodedPassword = httpUrl.encodedPassword();
                this.host = httpUrl.host;
                this.port = httpUrl.port;
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll(httpUrl.encodedPathSegments());
                if (n5 == n4 || string.charAt(n5) == '#') {
                    this.encodedQuery(httpUrl.encodedQuery());
                }
            }
            n3 = Util.delimiterOffset(string, n5, n4, "?#");
            this.resolvePath(string, n5, n3);
            n5 = n3;
            if (n5 < n4 && string.charAt(n5) == '?') {
                n2 = Util.delimiterOffset(string, n5, n4, '#');
                this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, n5 + 1, n2, HttpUrl.QUERY_ENCODE_SET, true, false, true, true, null));
                n5 = n2;
            }
            if (n5 >= n4 || string.charAt(n5) != '#') return ParseResult.SUCCESS;
            this.encodedFragment = HttpUrl.canonicalize(string, n5 + 1, n4, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
            return ParseResult.SUCCESS;
        }

        private void resolvePath(String string, int n2, int n3) {
            if (n2 == n3) {
                return;
            }
            char c2 = string.charAt(n2);
            if (c2 == '/' || c2 == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
                ++n2;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            }
            int n4 = n2;
            while (n4 < n3) {
                int n5 = Util.delimiterOffset(string, n4, n3, "/\\");
                boolean bl2 = n5 < n3;
                this.push(string, n4, n5, bl2, true);
                n4 = n5;
                if (!bl2) continue;
                ++n4;
            }
        }

        private void push(String string, int n2, int n3, boolean bl2, boolean bl3) {
            String string2 = HttpUrl.canonicalize(string, n2, n3, HttpUrl.PATH_SEGMENT_ENCODE_SET, bl3, false, false, true, null);
            if (this.isDot(string2)) {
                return;
            }
            if (this.isDotDot(string2)) {
                this.pop();
                return;
            }
            if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, string2);
            } else {
                this.encodedPathSegments.add(string2);
            }
            if (bl2) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private boolean isDot(String string) {
            return string.equals(".") || string.equalsIgnoreCase("%2e");
        }

        private boolean isDotDot(String string) {
            return string.equals("..") || string.equalsIgnoreCase("%2e.") || string.equalsIgnoreCase(".%2e") || string.equalsIgnoreCase("%2e%2e");
        }

        private void pop() {
            String string = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            if (string.isEmpty() && !this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            } else {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private static int schemeDelimiterOffset(String string, int n2, int n3) {
            if (n3 - n2 < 2) {
                return -1;
            }
            char c2 = string.charAt(n2);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                return -1;
            }
            for (int i2 = n2 + 1; i2 < n3; ++i2) {
                char c3 = string.charAt(i2);
                if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || c3 == '+' || c3 == '-' || c3 == '.') continue;
                if (c3 == ':') {
                    return i2;
                }
                return -1;
            }
            return -1;
        }

        private static int slashCount(String string, int n2, int n3) {
            char c2;
            int n4 = 0;
            while (n2 < n3 && ((c2 = string.charAt(n2)) == '\\' || c2 == '/')) {
                ++n4;
                ++n2;
            }
            return n4;
        }

        private static int portColonOffset(String string, int n2, int n3) {
            block4: for (int i2 = n2; i2 < n3; ++i2) {
                switch (string.charAt(i2)) {
                    case '[': {
                        while (++i2 < n3 && string.charAt(i2) != ']') {
                        }
                        continue block4;
                    }
                    case ':': {
                        return i2;
                    }
                }
            }
            return n3;
        }

        private static String canonicalizeHost(String string, int n2, int n3) {
            String string2 = HttpUrl.percentDecode(string, n2, n3, false);
            return Util.canonicalizeHost(string2);
        }

        private static int parsePort(String string, int n2, int n3) {
            try {
                String string2 = HttpUrl.canonicalize(string, n2, n3, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null);
                int n4 = Integer.parseInt(string2);
                if (n4 > 0 && n4 <= 65535) {
                    return n4;
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        static enum ParseResult {
            SUCCESS,
            MISSING_SCHEME,
            UNSUPPORTED_SCHEME,
            INVALID_PORT,
            INVALID_HOST;

        }
    }
}

