/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.spi.DataSetBuilder;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.spectra.Convolution;
import io.fair_acc.math.utils.ConcurrencyUtils;
import java.security.InvalidParameterException;
import java.util.concurrent.Future;
import org.apache.commons.math3.complex.Complex;

public class ContinuousWavelet {
    protected int START_THREADS = 512;
    protected boolean DEBUG = false;
    private int fstatus = 100;
    private final Convolution[] fdecon = new Convolution[ConcurrencyUtils.getNumberOfThreads()];

    public GridDataSet getScalogram(double[] dArray, int n2, int n3, double d2, double d3, double d4) {
        if (dArray == null || dArray.length == 0) {
            throw new InvalidParameterException(" getScalogram(double[],int,int,double,fmin,fmax) - data null or zero length");
        }
        if (d3 < 0.0 || d4 > 0.5 || d4 <= d3) {
            throw new InvalidParameterException(" getScalogram(double[],int,int,double," + d3 + "," + d4 + ") - frequency range not within 0<=fmin<fmax<=0.5");
        }
        if (n2 <= 0 || n2 > dArray.length) {
            throw new InvalidParameterException(" getScalogram(double[]," + n2 + ",int,double," + d3 + "," + d4 + ") - nQuantx out of range [0," + dArray.length + "]");
        }
        return new DataSetBuilder("Scalogram").setValues(0, this.getScalogramTimeAxis(dArray, n2, n3, d2, d3, d4)).setValues(1, this.getScalogramFrequencyAxis(n2, n3, d2, d3, d4)).setValues(2, this.getScalogramArrayFourier(dArray, n2, n3, d2, d3, d4)).build(GridDataSet.class);
    }

    public synchronized double[][] getScalogramArray(double[] dArray, int n2, int n3, double d2, double d3, double d4) {
        int n4 = (int)Math.floor((double)n3 * (d4 - d3) / 0.5) + 1;
        double[][] dArray2 = new double[n2][n4];
        this.fstatus = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = dArray.length / n2 * i2;
            this.fstatus = (int)((double)i2 / (double)n2 * 100.0);
            int n5 = (int)(2.0 * d3 * (double)n3);
            int n6 = (int)(2.0 * d4 * (double)n3);
            for (int i3 = n5; i3 < n6; ++i3) {
                double d6 = 0.5 * (double)i3 / (double)n3;
                if (d6 != 0.0) {
                    double d7 = d2 / d6;
                    Complex complex = this.WaveletTransform(dArray, d7, d5, d2);
                    double d8 = complex.getReal() * complex.getReal() + complex.getImaginary() * complex.getImaginary();
                    dArray2[i2][i3 - n5] = 10.0 * MathBase.log10(d8 + 1.0E-99);
                    continue;
                }
                dArray2[i2][i3 - n5] = Double.NaN;
            }
        }
        this.fstatus = 100;
        return dArray2;
    }

    public synchronized double[][] getScalogramArrayFourier(double[] dArray, int n2, int n3, double d2, double d3, double d4) {
        int n4 = (int)Math.floor((double)n3 * (d4 - d3) / 0.5) + 1;
        double[][] dArray2 = new double[n4][n2];
        boolean bl2 = true;
        long l2 = System.nanoTime();
        this.fstatus = 0;
        int n5 = (int)(2.0 * d3 * (double)n3);
        int n6 = (int)(2.0 * d4 * (double)n3);
        int n7 = n6 - n5;
        int n8 = ConcurrencyUtils.nextPow2(1 * dArray.length);
        int n9 = ConcurrencyUtils.getNumberOfThreads();
        if (n9 > 1 && n7 > this.START_THREADS) {
            Future[] futureArray = new Future[n9];
            int n10 = n7 / n9;
            for (int i2 = 0; i2 < n9; ++i2) {
                int n11 = n5 + i2 * n10;
                int n12 = i2 == n9 - 1 ? n6 : n11 + n10;
                int n13 = i2;
                futureArray[i2] = ConcurrencyUtils.submit(() -> {
                    if (this.fdecon[n13] == null) {
                        this.fdecon[n2] = new Convolution();
                    }
                    for (int i2 = n11; i2 < n12; ++i2) {
                        int n9;
                        double d3 = 0.5 * (double)i2 / (double)n3;
                        if (n13 == 0) {
                            this.fstatus = (int)((double)i2 / (double)n12 * 100.0);
                        }
                        double[] dArray3 = Convolution.getMorletFilter(n8, d3, d2);
                        double[] dArray4 = this.fdecon[n13].transformFull(dArray, dArray3, true);
                        if (d3 != 0.0) {
                            double d4;
                            int n10;
                            if (n2 != n8) {
                                n9 = n8 / n2;
                                for (n10 = 0; n10 < n2; ++n10) {
                                    int n11 = n10 * n9;
                                    int n12 = n11 << 1;
                                    d4 = 0.0;
                                    for (int i3 = 0; i3 < n9; ++i3) {
                                        int n13 = i3 << 1;
                                        double d5 = dArray4[n12 + n13];
                                        double d6 = dArray4[n12 + n13 + 1];
                                        d4 += MathBase.sqr(d5) + MathBase.sqr(d6);
                                    }
                                    dArray2[i2 - n8][n10] = 10.0 * MathBase.log10((d4 /= (double)n9) + 1.0E-99);
                                }
                                continue;
                            }
                            for (n9 = 0; n9 < n8; ++n9) {
                                n10 = n9 << 1;
                                double d7 = dArray4[n10];
                                d4 = dArray4[n10 + 1];
                                double d8 = MathBase.sqr(d7) + MathBase.sqr(d4);
                                dArray2[i2 - n8][n9] = 10.0 * MathBase.log10(d8 + 1.0E-99);
                            }
                            continue;
                        }
                        for (n9 = 0; n9 < n2; ++n9) {
                            dArray2[i2 - n8][n9] = Double.NaN;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            boolean bl3 = false;
            if (this.fdecon[0] == null) {
                this.fdecon[0] = new Convolution();
            }
            for (int i3 = n5; i3 < n6; ++i3) {
                int n14;
                double d5 = 0.5 * (double)i3 / (double)n3;
                this.fstatus = (int)((double)i3 / (double)n3 * 100.0);
                double[] dArray3 = Convolution.getMorletFilter(n8, d5, d2);
                double[] dArray4 = this.fdecon[0].transformFull(dArray, dArray3, true);
                if (d5 != 0.0) {
                    double d6;
                    int n15;
                    if (n2 != n8) {
                        n14 = n8 / n2;
                        for (n15 = 0; n15 < n2; ++n15) {
                            int n16 = n15 * n14;
                            int n17 = n16 << 1;
                            d6 = 0.0;
                            for (int i4 = 0; i4 < n14; ++i4) {
                                int n18 = i4 << 1;
                                double d7 = dArray4[n17 + n18];
                                double d8 = dArray4[n17 + n18 + 1];
                                d6 += MathBase.sqr(d7) + MathBase.sqr(d8);
                            }
                            dArray2[i3 - n5][n15] = 10.0 * MathBase.log10((d6 /= (double)n14) + 1.0E-99);
                        }
                        continue;
                    }
                    for (n14 = 0; n14 < n8; ++n14) {
                        n15 = n14 << 1;
                        double d9 = dArray4[n15];
                        d6 = dArray4[n15 + 1];
                        double d10 = MathBase.sqr(d9) + MathBase.sqr(d6);
                        dArray2[i3 - n5][n14] = 10.0 * MathBase.log10(d10 + 1.0E-99);
                    }
                    continue;
                }
                for (n14 = 0; n14 < n2; ++n14) {
                    dArray2[i3 - n5][n14] = Double.NaN;
                }
            }
        }
        long l3 = System.nanoTime();
        if (this.DEBUG) {
            System.err.printf("getScalogramArrayFourier(double[],int,int,double,double,double) - took %f ms\n", (double)(l3 - l2) * 1.0E-6);
        }
        this.fstatus = 100;
        return dArray2;
    }

    public double[] getScalogramFrequencyAxis(int n2, int n3, double d2, double d3, double d4) {
        double[] dArray = new double[(int)Math.floor((double)n3 * (d4 - d3) / 0.5) + 1];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = d3 + (double)i2 * (d4 - d3) / (double)dArray.length;
        }
        return dArray;
    }

    public double[] getScalogramTimeAxis(double[] dArray, int n2, int n3, double d2, double d3, double d4) {
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            dArray2[i2] = i2 * dArray.length / n2;
        }
        return dArray2;
    }

    public int getStatus() {
        return this.fstatus;
    }

    public boolean isBusy() {
        return this.fstatus < 100;
    }

    public Complex MexicanHat(double d2) {
        double d3 = d2 * d2;
        double d4 = (1.0 - d3) * Math.exp(-0.5 * d3);
        return new Complex(0.0, d4);
    }

    public Complex Morlet(double d2, double d3) {
        double d4 = 1.0 / Math.sqrt(java.lang.Math.PI * 2) * MathBase.exp(-2.0 * MathBase.sqr(MathBase.sqr(java.lang.Math.PI * 2) * d2 / d3));
        double d5 = java.lang.Math.PI * 2 * d3 * d2;
        double d6 = d4 * Math.sin(d5);
        double d7 = d4 * Math.cos(d5);
        return new Complex(d6, d7);
    }

    public void Morlet(double d2, double d3, double[] dArray) {
        double d4 = 1.0 / Math.sqrt(java.lang.Math.PI * 2) * MathBase.exp(-2.0 * MathBase.sqr(MathBase.sqr(java.lang.Math.PI * 2) * d2 / d3));
        double d5 = java.lang.Math.PI * 2 * d3 * d2;
        dArray[0] = d4 * Math.cos(d5);
        dArray[1] = d4 * Math.sin(d5);
    }

    public Complex Paul(double d2, int n2) {
        double d3 = Math.pow(2.0, n2) * Math.factorial(n2) / Math.sqrt(java.lang.Math.PI * Math.factorial(2 * n2));
        Complex complex = new Complex(1.0, 0.0);
        Complex complex2 = new Complex(1.0, 0.0);
        for (int i2 = 0; i2 < n2 + 1; ++i2) {
            complex = complex.multiply(new Complex(1.0, -d2));
            if (i2 >= n2) continue;
            complex2 = complex2.multiply(new Complex(0.0, 1.0));
        }
        return complex.multiply(complex2).multiply(d3);
    }

    public synchronized Complex WaveletTransform(Complex[] complexArray, double d2, double d3, double d4) {
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 1.0 / Math.sqrt(d2);
        for (int i2 = 0; i2 < complexArray.length; ++i2) {
            Complex complex = this.Morlet(((double)i2 - d3) / d2, d4).multiply(d7);
            d5 += complexArray[i2].multiply(complex).getReal();
            d6 += complexArray[i2].multiply(complex).getImaginary();
        }
        return new Complex(d5, d6);
    }

    public synchronized Complex WaveletTransform(double[] dArray, double d2, double d3, double d4) {
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray2 = new double[2];
        double d7 = 1.0 / Math.sqrt(d2);
        int n2 = (int)d3 + 1;
        int n3 = (int)(10.0 * d2);
        int n4 = Math.max(0, n2 - n3);
        int n5 = Math.min(dArray.length, n2 + n3);
        for (int i2 = n4; i2 < n5; ++i2) {
            this.Morlet(((double)i2 - d3) / d2, d4, dArray2);
            dArray2[0] = dArray2[0] * d7;
            dArray2[1] = dArray2[1] * d7;
            d5 += dArray[i2] * dArray2[1];
            d6 += dArray[i2] * dArray2[0];
        }
        return new Complex(d5, d6);
    }

    public static void main(String[] stringArray) {
        ContinuousWavelet continuousWavelet = new ContinuousWavelet();
        Complex complex = continuousWavelet.WaveletTransform(new double[]{0.1, 0.2, 0.0, 3.0}, 0.001, 0.0, 0.8);
        System.err.println("result = " + complex);
    }
}

