/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public final class HighPassTransform {
    private HighPassTransform() {
    }

    private static Complex transform(Complex complex, double d2) {
        if (complex.isInfinite()) {
            return new Complex(1.0, 0.0);
        }
        Complex complex2 = complex.multiply(d2);
        return new Complex(-1.0).multiply(new Complex(1.0).add(complex2)).divide(new Complex(1.0).subtract(complex2));
    }

    public static void transform(double d2, LayoutBase layoutBase, LayoutBase layoutBase2) {
        layoutBase.reset();
        double d3 = 1.0 / Math.tan(Math.PI * d2);
        int n2 = layoutBase2.getNumPoles();
        int n3 = n2 / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            PoleZeroPair poleZeroPair = layoutBase2.getPair(i2);
            layoutBase.addPoleZeroConjugatePairs(HighPassTransform.transform(poleZeroPair.poles.first, d3), HighPassTransform.transform(poleZeroPair.zeros.first, d3));
        }
        if ((n2 & 1) == 1) {
            PoleZeroPair poleZeroPair = layoutBase2.getPair(n3);
            layoutBase.add(HighPassTransform.transform(poleZeroPair.poles.first, d3), HighPassTransform.transform(poleZeroPair.zeros.first, d3));
        }
        layoutBase.setNormal(Math.PI - layoutBase2.getNormalW(), layoutBase2.getNormalGain());
    }
}

