/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CacheCollection<T>
extends AbstractCollection<T> {
    protected final List<Reference<T>> contents = Collections.synchronizedList(new LinkedList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t2) {
        if (t2 != null) {
            List<Reference<T>> list = this.contents;
            synchronized (list) {
                if (this.contains(t2)) {
                    return false;
                }
                return this.contents.add(new SoftReference<T>(t2));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            this.contents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object != null) {
            List<Reference<T>> list = this.contents;
            synchronized (list) {
                for (Reference<T> reference : this.contents) {
                    if (!object.equals(reference.get())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            return new CacheCollectionIterator<T>(this.contents.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            Iterator<Reference<T>> iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                Reference<T> reference = iterator.next();
                T t2 = reference.get();
                if (t2 == null) {
                    iterator.remove();
                    continue;
                }
                if (!object.equals(t2)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            this.cleanup();
            return this.contents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        List<Reference<T>> list = this.contents;
        synchronized (list) {
            LinkedList<Reference<T>> linkedList = new LinkedList<Reference<T>>();
            for (Reference<T> reference : this.contents) {
                if (reference.get() != null) continue;
                linkedList.add(reference);
            }
            this.contents.removeAll(linkedList);
        }
    }

    private static class CacheCollectionIterator<T>
    implements Iterator<T> {
        private final Iterator<Reference<T>> iterator;
        private T next;

        private CacheCollectionIterator(Iterator<Reference<T>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                T t2 = this.iterator.next().get();
                if (t2 == null) continue;
                this.next = t2;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            T t2 = this.next;
            this.next = null;
            while (t2 == null) {
                t2 = this.iterator.next().get();
            }
            return t2;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

