/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.testdata.spi;

import java.util.Random;
import java.util.SplittableRandom;

public final class RandomDataGenerator {
    private static final Random RND_DEPRECATED = new Random(System.currentTimeMillis());
    private static final SplittableRandom RND = new SplittableRandom(System.currentTimeMillis());
    private static final int NUMBER_OF_POINTS = 1000;
    private static final double X_MAX = 100.0;
    private static final double PEAK = 10.0;
    private static final double BACK = 1.0;
    private static final double Y_MAX = 12.100000000000001;
    private static final double SATURATION_LEVEL = 15.0;
    private static double noiseLevel = 0.5;
    private static double slope;
    private static double width;
    private static double center;
    private static double background;
    private static double amplitude;
    private static double[] xValues;
    private static double[] yValues;
    private static double nextNextGaussian;
    private static boolean haveNextNextGaussian;

    public static byte[] generateByteArray(int n2) {
        byte[] byArray = new byte[n2];
        RND_DEPRECATED.nextBytes(byArray);
        return byArray;
    }

    public static double[] generateDoubleArray(double d2, double d3, int n2) {
        double[] dArray = new double[n2];
        dArray[0] = d2;
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            int n3 = RND.nextBoolean() ? 1 : -1;
            double d4 = (double)(RND.nextInt() % 1000) / 1000.0;
            dArray[i2] = dArray[i2 - 1] + d3 * d4 * (double)n3;
        }
        return dArray;
    }

    public static float[] generateFloatArray(float f2, float f3, int n2) {
        float[] fArray = new float[n2];
        fArray[0] = f2;
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            int n3 = RND.nextBoolean() ? 1 : -1;
            float f4 = (float)((double)(RND.nextInt() % 1000) / 1000.0);
            fArray[i2] = fArray[i2 - 1] + f3 * f4 * (float)n3;
        }
        return fArray;
    }

    public static int[] generateIntArray(int n2, int n3, int n4) {
        int[] nArray = new int[n4];
        nArray[0] = n2;
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n5 = RND.nextBoolean() ? 1 : -1;
            nArray[i2] = nArray[i2 - 1] + (int)((double)n3 * RND.nextDouble()) * n5;
        }
        return nArray;
    }

    public static double[] generateZeroOneArray(double d2, int n2) {
        double[] dArray = new double[n2];
        dArray[0] = d2;
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            dArray[i2] = RND.nextBoolean() ? 0.0 : 1.0;
        }
        return dArray;
    }

    public static synchronized double[] getGaussianX() {
        if (xValues == null) {
            RandomDataGenerator.getNew1DGaussian();
        }
        return xValues;
    }

    public static synchronized double[] getGaussianY() {
        if (yValues == null) {
            RandomDataGenerator.getNew1DGaussian();
        }
        return yValues;
    }

    public static synchronized void getNew1DGaussian() {
        int n2;
        slope = RandomDataGenerator.myRandom(-0.003, 0.003);
        width = 100.0 * RandomDataGenerator.myRandom(0.04, 0.07);
        center = 100.0 * RandomDataGenerator.myRandom(-0.02, 0.02);
        background = 1.0 * RandomDataGenerator.myRandom(0.5, 1.5);
        amplitude = 10.0 * RandomDataGenerator.myRandom(0.9, 1.1);
        noiseLevel = 0.3;
        if (xValues == null) {
            xValues = new double[1000];
            yValues = new double[1000];
            for (n2 = 0; n2 < 1000; ++n2) {
                RandomDataGenerator.xValues[n2] = 200.0 * (0.5 - (double)(1000 - n2) / 1000.0);
            }
        }
        for (n2 = 0; n2 < 1000; ++n2) {
            RandomDataGenerator.yValues[n2] = RandomDataGenerator.myRandom(0.0, noiseLevel) + background + slope * (xValues[n2] - center) + amplitude * Math.exp(-(xValues[n2] - center) * (xValues[n2] - center) / width / width / 2.0);
        }
        for (n2 = 0; n2 < 1000; ++n2) {
            RandomDataGenerator.yValues[n2] = yValues[n2] > 15.0 ? 15.0 : yValues[n2];
        }
    }

    public static double myRandom(double d2, double d3) {
        assert (d3 > d2);
        return RND.nextDouble() * (d3 - d2) + d2;
    }

    public static synchronized double nextGaussian() {
        double d2;
        double d3;
        double d4;
        if (haveNextNextGaussian) {
            haveNextNextGaussian = false;
            return nextNextGaussian;
        }
        while ((d4 = (d3 = 2.0 * RND.nextDouble() - 1.0) * d3 + (d2 = 2.0 * RND.nextDouble() - 1.0) * d2) >= 1.0 || d4 == 0.0) {
        }
        double d5 = StrictMath.sqrt(-2.0 * StrictMath.log(d4) / d4);
        nextNextGaussian = d2 * d5;
        haveNextNextGaussian = true;
        return d3 * d5;
    }

    public static double random() {
        return RND.nextDouble();
    }

    static {
        haveNextNextGaussian = false;
    }
}

