/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.Histogram1D;
import io.fair_acc.dataset.Histogram2D;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractHistogram;
import io.fair_acc.dataset.spi.Histogram;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Histogram2
extends AbstractHistogram
implements Histogram2D {
    private static final long serialVersionUID = -5583974934398282519L;
    protected final Histogram xProjection;
    protected final Histogram yProjection;

    public Histogram2(String string, int n2, double d2, double d3, int n3, double d4, double d5, AbstractHistogram.HistogramOuterBounds histogramOuterBounds) {
        super(string, n2, d2, d3, n3, d4, d5, histogramOuterBounds);
        this.xProjection = new Histogram(string + "-Proj-X", n2, d2, d3, true, histogramOuterBounds);
        this.yProjection = new Histogram(string + "-Proj-Y", n3, d4, d5, false, histogramOuterBounds);
    }

    @Override
    public int fill(double d2, double d3) {
        return this.fill(d2, d3, 1.0);
    }

    @Override
    public int fill(double d2, double d3, double d4) {
        int n2 = this.lock().writeLockGuard(() -> {
            this.xProjection.fill(d2, d4);
            this.yProjection.fill(d3, d4);
            int n2 = super.findBin(d2, d3);
            super.addBinContent(n2, d4);
            return n2;
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return n2;
    }

    @Override
    public int findFirstBinAbove(double d2, double d3) {
        return this.findBin(d2, d3);
    }

    @Override
    public double get(int n2, int n3) {
        if (n2 == 2) {
            return this.getBinContent(n3);
        }
        return this.getBinCenter(n2, n3 + 1);
    }

    @Override
    public List<String> getErrorList() {
        return Collections.emptyList();
    }

    @Override
    public int getIndex(int n2, double ... dArray) {
        AssertUtils.checkArrayDimension("value", dArray, 1);
        return this.findBin(n2, dArray[0]);
    }

    @Override
    public List<String> getInfoList() {
        return Collections.emptyList();
    }

    public Histogram1D getProjectionX() {
        return this.xProjection;
    }

    public Histogram1D getProjectionY() {
        return this.yProjection;
    }

    protected double getSum(int n2, int n3) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.getShape(n2); ++i2) {
            if (n2 == 0) {
                d2 += this.get(2, i2, n3);
                continue;
            }
            d2 += this.get(2, n3, i2);
        }
        return d2;
    }

    @Override
    public List<String> getWarningList() {
        String[] stringArray = new String[]{"-x", "-y", "-z"};
        LinkedList<String> linkedList = new LinkedList<String>(super.getWarningList());
        for (int i2 = 0; i2 < this.getNGrid(); ++i2) {
            Object object;
            Object object2 = object = i2 < stringArray.length ? stringArray[i2] : "-dim" + (i2 + 1);
            if (this.getSum(i2, 0) > 0.0) {
                linkedList.add("under-range" + (String)object);
            }
            if (!(this.getSum(i2, this.getDataCount() - 1) > 0.0)) continue;
            linkedList.add("over-range" + (String)object);
        }
        return linkedList;
    }

    @Override
    public double get(int n2, int ... nArray) {
        switch (n2) {
            case 0: {
                return this.xProjection.get(n2, nArray[0]);
            }
            case 1: {
                return this.yProjection.get(n2, nArray[1]);
            }
            case 2: {
                int n3 = nArray[1] * this.getShape(0) + nArray[0];
                return super.getBinContent(n3);
            }
        }
        throw new IndexOutOfBoundsException("dimIndex out of bounds");
    }

    @Override
    public void reset() {
        this.xProjection.reset();
        this.yProjection.reset();
        super.reset();
    }

    @Override
    public int[] getShape() {
        return new int[]{this.xProjection.getDataCount(), this.yProjection.getDataCount()};
    }

    @Override
    public double getGrid(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.xProjection.get(0, n3);
            }
            case 1: {
                return this.yProjection.get(1, n3);
            }
        }
        throw new IndexOutOfBoundsException("dim Index out of bound 2");
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }

    @Override
    public int getGridIndex(int n2, double d2) {
        if (n2 >= this.getNGrid()) {
            throw new IndexOutOfBoundsException("dim index out of bounds");
        }
        if (this.getShape(n2) == 0) {
            return 0;
        }
        if (!Double.isFinite(d2)) {
            return 0;
        }
        if (d2 <= this.getAxisDescription(n2).getMin()) {
            return 0;
        }
        int n4 = this.getShape(n2) - 1;
        if (d2 >= this.getAxisDescription(n2).getMax()) {
            return n4;
        }
        return Histogram2.binarySearch(d2, 0, n4, n3 -> this.getGrid(n2, n3));
    }
}

