/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.DataSetMetaData;
import io.fair_acc.dataset.EditConstraints;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.locks.DataSetLock;
import io.fair_acc.dataset.locks.DefaultDataSetLock;
import io.fair_acc.dataset.spi.AbstractStylable;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.spi.DefaultAxisDescription;
import io.fair_acc.dataset.spi.utils.MathUtils;
import io.fair_acc.dataset.spi.utils.StringHashMapList;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.IndexedStringConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntToDoubleFunction;

public abstract class AbstractDataSet<D extends AbstractStylable<D>>
extends AbstractStylable<D>
implements DataSet,
DataSetMetaData {
    private static final long serialVersionUID = -7612136495756923417L;
    private static final String[] DEFAULT_AXES_NAME = new String[]{"x-Axis", "y-Axis", "z-Axis"};
    private String name;
    protected final int dimension;
    private final List<AxisDescription> axesDescriptions = new ArrayList<AxisDescription>();
    private final transient BitState state = BitState.initDirty(this);
    private final transient DataSetLock<? extends DataSet> lock = new DefaultDataSetLock<AbstractDataSet>(this);
    private final StringHashMapList dataLabels = new StringHashMapList();
    private final StringHashMapList dataStyles = new StringHashMapList();
    private final List<String> styleClasses = new ArrayList<String>();
    private final List<String> infoList = new ArrayList<String>();
    private final List<String> warningList = new ArrayList<String>();
    private final List<String> errorList = new ArrayList<String>();
    private transient EditConstraints editConstraints;
    private final Map<String, String> metaInfoMap = new ConcurrentHashMap<String, String>();
    private DurationMeasure benchRecomputeLimitsSingle = DurationMeasure.DISABLED;

    public AbstractDataSet(String string, int n2) {
        AssertUtils.gtThanZero("dimension", n2);
        this.name = string;
        this.dimension = n2;
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            Object object = i2 < DEFAULT_AXES_NAME.length ? DEFAULT_AXES_NAME[i2] : "dim" + (i2 + 1) + "-Axis";
            DefaultAxisDescription defaultAxisDescription = new DefaultAxisDescription(i2, (String)object, "a.u.");
            defaultAxisDescription.addListener(this.state);
            this.axesDescriptions.add(defaultAxisDescription);
        }
    }

    public String addDataLabel(int n2, String string) {
        String string2 = this.lock().writeLockGuard(() -> this.dataLabels.put(n2, string));
        this.fireInvalidated(ChartBits.DataSetMetaData);
        return string2;
    }

    public String addDataStyle(int n2, String string) {
        String string2 = this.lock().writeLockGuard(() -> this.dataStyles.put(n2, string));
        this.fireInvalidated(ChartBits.DataSetMetaData);
        return string2;
    }

    protected int binarySearch(int n2, double d2, int n3, int n4) {
        if (n3 == n4) {
            return n3;
        }
        if (n4 - n3 == 1) {
            if (Math.abs(this.get(n2, n3) - d2) < Math.abs(this.get(n2, n4) - d2)) {
                return n3;
            }
            return n4;
        }
        int n5 = (n4 + n3) / 2;
        double d3 = this.get(n2, n5);
        if (d3 == d2) {
            return n5;
        }
        if (d2 < d3) {
            return this.binarySearch(n2, d2, n3, n5);
        }
        return this.binarySearch(n2, d2, n5, n4);
    }

    public D clearMetaInfo() {
        this.infoList.clear();
        this.warningList.clear();
        this.errorList.clear();
        this.fireInvalidated(ChartBits.DataSetMetaData);
        return (D)this.getThis();
    }

    protected boolean equalDataLabels(DataSet dataSet) {
        if (dataSet instanceof AbstractDataSet) {
            AbstractDataSet abstractDataSet = (AbstractDataSet)dataSet;
            return this.getDataLabelMap().equals(abstractDataSet.getDataLabelMap());
        }
        for (int i2 = 0; i2 < this.getDataCount(); ++i2) {
            String string;
            String string2 = this.getDataLabel(i2);
            if (Objects.equals(string2, string = dataSet.getDataLabel(i2))) continue;
            return false;
        }
        return true;
    }

    protected boolean equalEditConstraints(DataSet dataSet) {
        if (dataSet instanceof EditableDataSet) {
            EditableDataSet editableDataSet = (EditableDataSet)dataSet;
            if (this.editConstraints != null && editableDataSet.getEditConstraints() == null) {
                return false;
            }
            return this.editConstraints == null || this.editConstraints.equals(editableDataSet.getEditConstraints());
        }
        return true;
    }

    protected boolean equalErrorValues(DataSet dataSet, double d2) {
        if (!(this instanceof DataSetError) || !(dataSet instanceof DataSetError)) {
            return true;
        }
        DataSetError dataSetError = (DataSetError)((Object)this);
        DataSetError dataSetError2 = (DataSetError)dataSet;
        if (!dataSetError.getErrorType(0).equals((Object)dataSetError2.getErrorType(0))) {
            return false;
        }
        if (!dataSetError.getErrorType(1).equals((Object)dataSetError2.getErrorType(1))) {
            return false;
        }
        if (d2 <= 0.0) {
            for (int i2 = 0; i2 < this.getDimension(); ++i2) {
                for (int i3 = 0; i3 < this.getDataCount(); ++i3) {
                    if (dataSetError.getErrorNegative(i2, i3) != dataSetError2.getErrorNegative(i2, i3)) {
                        return false;
                    }
                    if (dataSetError.getErrorPositive(i2, i3) == dataSetError2.getErrorPositive(i2, i3)) continue;
                    return false;
                }
            }
            return true;
        }
        for (int i4 = 0; i4 < this.getDimension(); ++i4) {
            for (int i5 = 0; i5 < this.getDataCount(); ++i5) {
                if (!MathUtils.nearlyEqual(dataSetError.getErrorNegative(i4, i5), dataSetError2.getErrorNegative(i4, i5), d2)) {
                    return false;
                }
                if (MathUtils.nearlyEqual(dataSetError.getErrorPositive(i4, i5), dataSetError2.getErrorPositive(i4, i5), d2)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean equalMetaData(DataSet dataSet) {
        if (dataSet instanceof DataSetMetaData) {
            DataSetMetaData dataSetMetaData = (DataSetMetaData)((Object)dataSet);
            if (!this.getErrorList().equals(dataSetMetaData.getErrorList())) {
                return false;
            }
            if (!this.getWarningList().equals(dataSetMetaData.getWarningList())) {
                return false;
            }
            if (!this.getInfoList().equals(dataSetMetaData.getInfoList())) {
                return false;
            }
            return this.getMetaInfo().equals(dataSetMetaData.getMetaInfo());
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DataSet)) {
            return false;
        }
        return this.equals(object, -1.0);
    }

    public boolean equals(Object object, double d2) {
        String string;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DataSet)) {
            return false;
        }
        DataSet dataSet = (DataSet)object;
        if (this.getDimension() != dataSet.getDimension()) {
            return false;
        }
        if (this.getDataCount() != dataSet.getDataCount()) {
            return false;
        }
        String string2 = this.getName();
        if (!Objects.equals(string2, string = dataSet.getName())) {
            return false;
        }
        if (this.getAxisDescriptions().isEmpty() && !dataSet.getAxisDescriptions().isEmpty()) {
            return false;
        }
        if (!this.getAxisDescriptions().equals(dataSet.getAxisDescriptions())) {
            return false;
        }
        if (!this.equalDataLabels(dataSet)) {
            return false;
        }
        if (!this.equalEditConstraints(dataSet)) {
            return false;
        }
        if (!this.equalMetaData(dataSet)) {
            return false;
        }
        if (!this.equalValues(dataSet, d2)) {
            return false;
        }
        return this.equalErrorValues(dataSet, d2);
    }

    protected boolean equalValues(DataSet dataSet, double d2) {
        if (d2 <= 0.0) {
            for (int i2 = 0; i2 < this.getDimension(); ++i2) {
                for (int i3 = 0; i3 < this.getDataCount(); ++i3) {
                    if (this.get(i2, i3) == dataSet.get(i2, i3)) continue;
                    return false;
                }
            }
        } else {
            for (int i4 = 0; i4 < this.getDimension(); ++i4) {
                for (int i5 = 0; i5 < this.getDataCount(); ++i5) {
                    if (MathUtils.nearlyEqual(this.get(i4, i5), dataSet.get(i4, i5), d2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return this.axesDescriptions;
    }

    @Override
    public String getDataLabel(int n2) {
        return (String)this.dataLabels.get(n2);
    }

    @Override
    public boolean hasDataLabels() {
        return !this.dataLabels.isEmpty();
    }

    @Override
    public void forEachDataLabel(int n2, int n3, IndexedStringConsumer indexedStringConsumer) {
        for (Map.Entry entry : this.dataLabels.entrySet()) {
            int n4 = (Integer)entry.getKey();
            if (n4 < n2 || n4 >= n3) continue;
            indexedStringConsumer.accept(n4, (String)entry.getValue());
        }
    }

    public StringHashMapList getDataLabelMap() {
        return this.dataLabels;
    }

    public StringHashMapList getDataStyleMap() {
        return this.dataStyles;
    }

    @Override
    public final int getDimension() {
        return this.dimension;
    }

    public EditConstraints getEditConstraints() {
        return this.editConstraints;
    }

    @Override
    public List<String> getErrorList() {
        return this.errorList;
    }

    @Override
    public List<String> getInfoList() {
        return this.infoList;
    }

    @Override
    public Map<String, String> getMetaInfo() {
        return this.metaInfoMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getStyleClasses() {
        return this.styleClasses;
    }

    public D addStyleClasses(String ... stringArray) {
        boolean bl2 = false;
        for (String string : stringArray) {
            if (this.styleClasses.contains(string)) continue;
            this.styleClasses.add(string);
            bl2 = true;
        }
        if (bl2) {
            this.fireInvalidated(ChartBits.DataSetStyle);
        }
        return (D)this.getThis();
    }

    public D removeStyleClasses(String ... stringArray) {
        boolean bl2 = false;
        for (String string : stringArray) {
            bl2 |= this.styleClasses.remove(string);
        }
        if (bl2) {
            this.fireInvalidated(ChartBits.DataSetStyle);
        }
        return (D)this.getThis();
    }

    @Override
    public D setStyle(String string) {
        if (!Objects.equals(this.getStyle(), string)) {
            super.setStyle(string);
            this.fireInvalidated(ChartBits.DataSetStyle);
        }
        return (D)this.getThis();
    }

    @Override
    public String getStyle(int n2) {
        return (String)this.dataStyles.get(n2);
    }

    @Override
    public boolean hasStyles() {
        return !this.dataStyles.isEmpty();
    }

    @Override
    public void forEachStyle(int n2, int n3, IndexedStringConsumer indexedStringConsumer) {
        for (Map.Entry entry : this.dataStyles.entrySet()) {
            int n4 = (Integer)entry.getKey();
            if (n4 < n2 || n4 >= n3) continue;
            indexedStringConsumer.accept(n4, (String)entry.getValue());
        }
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    @Override
    public List<String> getWarningList() {
        return this.warningList;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.axesDescriptions.hashCode();
        n3 = 31 * n3 + this.dataLabels.hashCode();
        n3 = 31 * n3 + this.dimension;
        n3 = 31 * n3 + Objects.hashCode(this.editConstraints);
        n3 = 31 * n3 + this.errorList.hashCode();
        n3 = 31 * n3 + this.infoList.hashCode();
        n3 = 31 * n3 + this.metaInfoMap.hashCode();
        n3 = 31 * n3 + Objects.hashCode(this.name);
        n3 = 31 * n3 + this.warningList.hashCode();
        return n3;
    }

    public DataSetLock<? extends DataSet> lock() {
        return this.lock;
    }

    public String removeDataLabel(int n2) {
        String string = this.lock().writeLockGuard(() -> (String)this.dataLabels.remove(n2));
        this.fireInvalidated(ChartBits.DataSetMetaData);
        return string;
    }

    public String removeStyle(int n2) {
        String string = this.lock().writeLockGuard(() -> (String)this.dataStyles.remove(n2));
        this.fireInvalidated(ChartBits.DataSetMetaData);
        return string;
    }

    public D setEditConstraints(EditConstraints editConstraints) {
        this.lock().writeLockGuard(() -> {
            this.editConstraints = editConstraints;
            return this.editConstraints;
        });
        this.fireInvalidated(ChartBits.DataSetMetaData);
        return (D)this.getThis();
    }

    public D setName(String string) {
        this.name = string;
        this.fireInvalidated(ChartBits.DataSetName);
        return (D)this.getThis();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName()).append(" [dim=").append(this.getDimension()).append(',').append(" dataCount=").append(this.getDataCount()).append(',');
        for (int i2 = 0; i2 < this.getDimension(); ++i2) {
            AxisDescription axisDescription = this.getAxisDescription(i2);
            boolean bl2 = axisDescription.isDefined();
            stringBuilder.append(" axisName ='").append(axisDescription.getName()).append("',").append(" axisUnit = '").append(axisDescription.getUnit()).append("',").append(" axisRange = ").append(" [").append(bl2 ? Double.valueOf(axisDescription.getMin()) : "NotDefined").append(", ").append(bl2 ? Double.valueOf(axisDescription.getMax()) : "NotDefined").append("],");
            if (!(this instanceof DataSetError)) continue;
            DataSetError.ErrorType errorType = ((DataSetError)((Object)this)).getErrorType(i2);
            stringBuilder.append(" errorType(").append(i2).append(")=").append((Object)errorType).append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public double[] getValues(int n2) {
        int n3 = this.getDataCount();
        double[] dArray = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = this.get(n2, i2);
        }
        return dArray;
    }

    @Override
    public double getValue(int n2, double ... dArray) {
        AssertUtils.checkArrayDimension("x", dArray, 1);
        int n3 = this.getIndex(0, dArray);
        double d2 = this.get(0, n3);
        double d3 = this.get(n2, n3);
        int n4 = d2 < dArray[0] ? n3 + 1 : n3 - 1;
        n4 = Math.max(0, Math.min(n4, this.getDataCount() - 1));
        double d4 = this.get(n2, n4);
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            return Double.NaN;
        }
        double d5 = this.get(0, n4);
        if (d2 == d5) {
            return this.get(n2, n3);
        }
        double d6 = this.get(n2, n3);
        return d6 + (this.get(n2, n4) - d6) * (dArray[0] - d2) / (d5 - d2);
    }

    public static int binarySearch(double d2, int n2, int n3, IntToDoubleFunction intToDoubleFunction) {
        if (n2 == n3) {
            return n2;
        }
        if (n3 - n2 == 1) {
            if (Math.abs(intToDoubleFunction.applyAsDouble(n2) - d2) < Math.abs(intToDoubleFunction.applyAsDouble(n3) - d2)) {
                return n2;
            }
            return n3;
        }
        int n4 = (n3 + n2) / 2;
        double d3 = intToDoubleFunction.applyAsDouble(n4);
        if (d3 == d2) {
            return n4;
        }
        if (d2 < d3) {
            return AbstractDataSet.binarySearch(d2, n2, n4, intToDoubleFunction);
        }
        return AbstractDataSet.binarySearch(d2, n4, n3, intToDoubleFunction);
    }

    @Override
    public int getIndex(int n2, double ... dArray) {
        AssertUtils.checkArrayDimension("x", dArray, 1);
        if (this.getDataCount() == 0) {
            return 0;
        }
        if (!Double.isFinite(dArray[0])) {
            return 0;
        }
        double d2 = this.getAxisDescription(n2).getMin();
        double d3 = this.getAxisDescription(n2).getMax();
        if (Double.isFinite(d2) && dArray[0] <= d2 || dArray[0] <= this.get(n2, 0)) {
            return 0;
        }
        int n4 = this.getDataCount() - 1;
        if (Double.isFinite(d3) && dArray[0] >= d3 || dArray[0] >= this.get(n2, this.getDataCount() - 1)) {
            return n4;
        }
        return AbstractDataSet.binarySearch(dArray[0], 0, n4, n3 -> this.get(n2, n3));
    }

    @Override
    public DataSet recomputeLimits(int n2) {
        this.benchRecomputeLimitsSingle.start();
        DataRange dataRange = new DataRange();
        int n3 = this.getDataCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            dataRange.add(this.get(n2, i2));
        }
        this.getAxisDescription(n2).set(dataRange.getMin(), dataRange.getMax());
        this.benchRecomputeLimitsSingle.stop();
        return this;
    }

    @Override
    public BitState getBitState() {
        return this.state;
    }

    protected boolean copyMetaData(DataSet dataSet) {
        this.setName(dataSet.getName());
        if (!(dataSet instanceof DataSetMetaData)) {
            return false;
        }
        DataSetMetaData dataSetMetaData = (DataSetMetaData)((Object)dataSet);
        this.infoList.clear();
        this.infoList.addAll(dataSetMetaData.getInfoList());
        this.warningList.clear();
        this.warningList.addAll(dataSetMetaData.getWarningList());
        this.errorList.clear();
        this.errorList.addAll(dataSetMetaData.getErrorList());
        this.metaInfoMap.clear();
        this.metaInfoMap.putAll(dataSetMetaData.getMetaInfo());
        return true;
    }

    protected void copyDataLabelsAndStyles(DataSet dataSet, boolean bl2) {
        this.setStyle(dataSet.getStyle());
        if (bl2 || !(dataSet instanceof AbstractDataSet)) {
            String string;
            int n2;
            this.getDataLabelMap().clear();
            for (n2 = 0; n2 < dataSet.getDataCount(); ++n2) {
                string = dataSet.getDataLabel(n2);
                if (string == null || string.isEmpty()) continue;
                this.addDataLabel(n2, string);
            }
            this.getDataStyleMap().clear();
            for (n2 = 0; n2 < dataSet.getDataCount(); ++n2) {
                string = dataSet.getStyle(n2);
                if (string == null || string.isEmpty()) continue;
                this.addDataStyle(n2, string);
            }
            return;
        }
        AbstractDataSet abstractDataSet = (AbstractDataSet)dataSet;
        this.getDataLabelMap().clear();
        this.getDataLabelMap().putAll(abstractDataSet.getDataLabelMap());
        this.getDataStyleMap().clear();
        this.getDataStyleMap().putAll(abstractDataSet.getDataStyleMap());
    }

    protected void copyAxisDescription(DataSet dataSet) {
        for (int i2 = 0; i2 < this.getDimension(); ++i2) {
            this.getAxisDescription(i2).set(dataSet.getAxisDescription(i2));
        }
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        this.benchRecomputeLimitsSingle = measurementRecorder.newDuration("ds-RecomputeLimits-single");
    }
}

