/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset;

import io.fair_acc.dataset.DataSet;

public interface DataSetError
extends DataSet {
    default public double getErrorNegative(int n2, double d2) {
        int n3 = this.getIndex(0, d2);
        double d3 = this.get(0, n3);
        double d4 = this.get(n2, n3);
        int n4 = d3 < d2 ? n3 + 1 : n3 - 1;
        n4 = Math.max(0, Math.min(n4, this.getDataCount() - 1));
        double d5 = this.get(n2, n4);
        if (Double.isNaN(d4) || Double.isNaN(d5)) {
            return Double.NaN;
        }
        double d6 = this.get(0, n4);
        if (d3 == d6) {
            return this.getErrorNegative(n2, n3);
        }
        double d7 = this.getErrorNegative(n2, n3);
        return d7 + (this.getErrorNegative(n2, n4) - d7) * (d2 - d3) / (d6 - d3);
    }

    public double getErrorNegative(int var1, int var2);

    default public double getErrorPositive(int n2, double d2) {
        int n3 = this.getIndex(0, d2);
        double d3 = this.get(0, n3);
        double d4 = this.get(n2, n3);
        int n4 = d3 < d2 ? n3 + 1 : n3 - 1;
        n4 = Math.max(0, Math.min(n4, this.getDataCount() - 1));
        double d5 = this.get(n2, n4);
        if (Double.isNaN(d4) || Double.isNaN(d5)) {
            return Double.NaN;
        }
        double d6 = this.get(0, n4);
        if (d3 == d6) {
            return this.getErrorPositive(n2, n3);
        }
        double d7 = this.getErrorPositive(n2, n3);
        return d7 + (this.getErrorPositive(n2, n4) - d7) * (d2 - d3) / (d6 - d3);
    }

    public double getErrorPositive(int var1, int var2);

    default public double[] getErrorsNegative(int n2) {
        int n3 = this.getDataCount();
        double[] dArray = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = this.getErrorNegative(n2, i2);
        }
        return dArray;
    }

    default public double[] getErrorsPositive(int n2) {
        int n3 = this.getDataCount();
        double[] dArray = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = this.getErrorPositive(n2, i2);
        }
        return dArray;
    }

    public ErrorType getErrorType(int var1);

    public static enum ErrorType {
        NO_ERROR,
        SYMMETRIC,
        ASYMMETRIC;


        boolean isAssymmetric() {
            return this.equals((Object)ASYMMETRIC);
        }
    }
}

