/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.css;

import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.chartfx.utils.PropUtil;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;

public class StyleUtil {
    private static double[] cachedDashArray = new double[2];

    private StyleUtil() {
    }

    public static <NODE extends Node> NODE hiddenStyleNode(NODE NODE, String ... stringArray) {
        StyleUtil.styleNode(NODE, stringArray);
        NODE.setVisible(false);
        return NODE;
    }

    public static <NODE extends Node> NODE styleNode(NODE NODE, String ... stringArray) {
        StyleUtil.addStyles(NODE, stringArray);
        NODE.setManaged(false);
        return NODE;
    }

    public static <NODE extends Node> NODE addStyles(NODE NODE, String ... stringArray) {
        NODE.getStyleClass().addAll((Object[])stringArray);
        return NODE;
    }

    public static <NODE extends Node> NODE hide(NODE NODE) {
        NODE.setVisible(false);
        NODE.setManaged(false);
        return NODE;
    }

    public static void applyPseudoClass(Node node, PseudoClass pseudoClass, ObservableBooleanValue observableBooleanValue) {
        node.pseudoClassStateChanged(pseudoClass, observableBooleanValue.get());
        PropUtil.runOnChange(() -> {
            node.pseudoClassStateChanged(pseudoClass, observableBooleanValue.get());
            node.applyCss();
        }, new ObservableValue[]{observableBooleanValue});
    }

    public static void forEachStyleProp(Node node, Consumer<ObservableValue<?>> consumer) {
        consumer.accept((ObservableValue<?>)node.visibleProperty());
        consumer.accept((ObservableValue<?>)node.rotateProperty());
        consumer.accept((ObservableValue<?>)node.opacityProperty());
        if (node instanceof Shape) {
            Shape shape = (Shape)node;
            consumer.accept((ObservableValue<?>)shape.fillProperty());
            consumer.accept((ObservableValue<?>)shape.strokeProperty());
            consumer.accept((ObservableValue<?>)Bindings.size((ObservableList)shape.getStrokeDashArray()));
            consumer.accept((ObservableValue<?>)shape.strokeDashOffsetProperty());
            consumer.accept((ObservableValue<?>)shape.strokeLineCapProperty());
            consumer.accept((ObservableValue<?>)shape.strokeLineJoinProperty());
            consumer.accept((ObservableValue<?>)shape.strokeMiterLimitProperty());
            consumer.accept((ObservableValue<?>)shape.strokeWidthProperty());
            if (node instanceof Text) {
                Text text = (Text)node;
                consumer.accept((ObservableValue<?>)text.fontProperty());
                consumer.accept((ObservableValue<?>)text.fontSmoothingTypeProperty());
                consumer.accept((ObservableValue<?>)text.textAlignmentProperty());
                consumer.accept((ObservableValue<?>)text.textOriginProperty());
            }
        }
    }

    public static void copyStyle(Node node, GraphicsContext graphicsContext) {
        graphicsContext.setGlobalAlpha(node.getOpacity());
        if (node instanceof Shape) {
            Shape shape = (Shape)node;
            graphicsContext.setFill(shape.getFill());
            graphicsContext.setStroke(shape.getStroke());
            graphicsContext.setLineDashes(StyleUtil.toLineDashArray((List<Double>)shape.getStrokeDashArray()));
            graphicsContext.setLineDashOffset(shape.getStrokeDashOffset());
            graphicsContext.setLineCap(shape.getStrokeLineCap());
            graphicsContext.setLineJoin(shape.getStrokeLineJoin());
            graphicsContext.setMiterLimit(shape.getStrokeMiterLimit());
            graphicsContext.setLineWidth(shape.getStrokeWidth());
            if (node instanceof Text) {
                Text text = (Text)node;
                graphicsContext.setFont(text.getFont());
                graphicsContext.setFontSmoothingType(text.getFontSmoothingType());
                graphicsContext.setTextAlign(text.getTextAlignment());
                graphicsContext.setTextBaseline(text.getTextOrigin());
            }
        }
    }

    public static String toStyleString(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : node.getStyleClass()) {
            stringBuilder.append(".").append(string).append(", ");
        }
        StyleUtil.removeEndIf(stringBuilder, ", ");
        stringBuilder.append(" {");
        StyleUtil.forEachStyleProp(node, observableValue -> {
            if (!(observableValue instanceof StyleableProperty)) {
                return;
            }
            StyleableProperty styleableProperty = (StyleableProperty)observableValue;
            stringBuilder.append("\n  ").append(styleableProperty.getCssMetaData().getProperty()).append(": ").append(styleableProperty.getValue()).append(";");
        });
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    private static boolean removeEndIf(StringBuilder stringBuilder, String string) {
        if (stringBuilder.length() < string.length()) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2;
            char c3 = string.charAt(string.length() - 1 - i2);
            if (c3 == (c2 = stringBuilder.charAt(stringBuilder.length() - 1 - i2))) continue;
            return false;
        }
        stringBuilder.setLength(stringBuilder.length() - string.length());
        return true;
    }

    static Consumer<ObservableValue<?>> incrementOnChange(LongProperty longProperty) {
        ChangeListener changeListener = (observableValue, object, object2) -> longProperty.set(longProperty.get() + 1L);
        return observableValue -> observableValue.addListener(changeListener);
    }

    public static ObjectBinding<double[]> toUnboxedDoubleArray(ReadOnlyProperty<Number[]> readOnlyProperty) {
        return Bindings.createObjectBinding(() -> {
            Object object = readOnlyProperty.getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return new double[]{((Number)object).doubleValue()};
            }
            Number[] numberArray = (Number[])object;
            double[] dArray = new double[numberArray.length];
            for (int i2 = 0; i2 < numberArray.length; ++i2) {
                dArray[i2] = numberArray[i2] == null ? 0.0 : numberArray[i2].doubleValue();
            }
            return dArray;
        }, (Observable[])new Observable[0]);
    }

    public static void copyLineDashes(GraphicsContext graphicsContext, Shape shape) {
        graphicsContext.setLineDashes(StyleUtil.toLineDashArray((List<Double>)shape.getStrokeDashArray()));
    }

    private static double[] toLineDashArray(List<Double> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        FXUtils.assertJavaFxThread();
        double[] dArray = cachedDashArray;
        if (dArray.length != list.size()) {
            dArray = new double[list.size()];
        }
        int n2 = 0;
        for (Double d2 : list) {
            dArray[n2++] = d2;
        }
        cachedDashArray = dArray;
        return dArray;
    }

    public static interface StyleNode {
        default public void copyStyleTo(GraphicsContext graphicsContext) {
            StyleUtil.copyStyle((Node)this, graphicsContext);
        }

        default public long getChangeCounter() {
            return this.changeCounterProperty().get();
        }

        public ReadOnlyLongProperty changeCounterProperty();
    }
}

