/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisTransform;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractContourDataSetRendererParameter;
import io.fair_acc.chartfx.renderer.spi.ContourDataSetCache;
import io.fair_acc.chartfx.renderer.spi.hexagon.Hexagon;
import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonMap;
import io.fair_acc.chartfx.renderer.spi.marchingsquares.GeneralPath;
import io.fair_acc.chartfx.renderer.spi.marchingsquares.MarchingSquares;
import io.fair_acc.chartfx.renderer.spi.utils.ColorGradient;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.ui.layout.ChartPane;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import java.util.concurrent.ExecutionException;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContourDataSetRenderer
extends AbstractContourDataSetRendererParameter<ContourDataSetRenderer>
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContourDataSetRenderer.class);
    private ContourDataSetCache localCache;
    protected final ColorGradientBar gradientBar = new ColorGradientBar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawContour(GraphicsContext graphicsContext, ContourDataSetCache contourDataSetCache) {
        int n2;
        double[] dArray = new double[this.getNumberQuantisationLevels()];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = (double)(n2 + 1) / (double)dArray.length;
        }
        n2 = contourDataSetCache.xSize;
        int n3 = contourDataSetCache.ySize;
        double[][] dArray2 = new double[n3][n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 < 0) continue;
            System.arraycopy(contourDataSetCache.reduced, i2 * n2 + 0, dArray2[n3 - 1 - i2], 0, n2);
        }
        double d2 = Math.abs(contourDataSetCache.zMax - contourDataSetCache.zMin);
        if (d2 <= 0.0) {
            return;
        }
        ColorGradient colorGradient = this.getColorGradient();
        MarchingSquares marchingSquares = new MarchingSquares();
        double d3 = contourDataSetCache.xDataPixelRange / (double)n2;
        double d4 = contourDataSetCache.yDataPixelRange / (double)n3;
        graphicsContext.save();
        graphicsContext.translate(contourDataSetCache.xDataPixelMin, contourDataSetCache.yDataPixelMin);
        graphicsContext.scale(d3, d4);
        try {
            GeneralPath[] generalPathArray = marchingSquares.buildContours(dArray2, dArray);
            int n4 = 0;
            for (GeneralPath generalPath : generalPathArray) {
                if (generalPath.size() > this.getMaxContourSegments()) {
                    ++n4;
                    continue;
                }
                Color color = contourDataSetCache.zInverted ? colorGradient.getColor(1.0 - dArray[n4++]) : colorGradient.getColor(dArray[n4++]);
                graphicsContext.setStroke((Paint)color);
                graphicsContext.setLineDashes(new double[]{1.0});
                graphicsContext.setMiterLimit(10.0);
                graphicsContext.setFill((Paint)color);
                graphicsContext.setLineWidth(0.5);
                generalPath.draw(graphicsContext);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().setCause(exception).log("marchingSquares algorithm");
            }
        }
        finally {
            graphicsContext.restore();
        }
    }

    private void drawContourFast(GraphicsContext graphicsContext, AxisTransform axisTransform, ContourDataSetCache contourDataSetCache) {
        int n2;
        long l2 = ProcessingProfiler.getTimeStamp();
        int n3 = contourDataSetCache.xSize;
        int n4 = contourDataSetCache.ySize;
        double d2 = axisTransform.forward(contourDataSetCache.zMin);
        double d3 = axisTransform.forward(contourDataSetCache.zMax);
        graphicsContext.setImageSmoothing(this.isSmooth());
        this.getNumberQuantisationLevels();
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n3][n4];
        double[][] dArray3 = new double[n3][n4];
        double[] dArray4 = new double[this.getNumberQuantisationLevels()];
        for (n2 = 0; n2 < dArray4.length; ++n2) {
            dArray4[n2] = (double)(n2 + 1) / (double)dArray4.length;
        }
        n2 = n3 * n4;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 % n3;
            int n6 = i2 / n3;
            dArray[n5][n6] = contourDataSetCache.reduced[i2];
        }
        WritableImage writableImage = this.localCache.getImage(n3, n4);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        if (pixelWriter == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().log("Could not get PixelWriter for image");
            }
            return;
        }
        ColorGradient colorGradient = this.getColorGradient();
        for (double d4 : dArray4) {
            ContourDataSetRenderer.sobelOperator(dArray, dArray3, d2, d3, d4);
            ContourDataSetRenderer.erosionOperator(dArray3, dArray2, d2, d3, d4);
            for (int i3 = 0; i3 < n4; ++i3) {
                int n7 = n4 - 1 - i3;
                for (int i4 = 0; i4 < n3; ++i4) {
                    double d5 = dArray2[i4][i3];
                    if (d5 <= 0.0) continue;
                    Color color = contourDataSetCache.zInverted ? colorGradient.getColor(1.0 - d4) : colorGradient.getColor(d4);
                    pixelWriter.setColor(i4, n7, color);
                }
            }
        }
        graphicsContext.drawImage((Image)writableImage, contourDataSetCache.xDataPixelMin, contourDataSetCache.yDataPixelMin, contourDataSetCache.xDataPixelRange, contourDataSetCache.yDataPixelRange);
        this.localCache.add(writableImage);
        ProcessingProfiler.getTimeDiff(l2, "sobel");
    }

    private void drawHeatMap(GraphicsContext graphicsContext, ContourDataSetCache contourDataSetCache) {
        long l2 = ProcessingProfiler.getTimeStamp();
        graphicsContext.setImageSmoothing(this.isSmooth());
        WritableImage writableImage = this.localCache.convertDataArrayToImage(contourDataSetCache.reduced, contourDataSetCache.xSize, contourDataSetCache.ySize, this.getColorGradient());
        ProcessingProfiler.getTimeDiff(l2, "color map");
        graphicsContext.drawImage((Image)writableImage, contourDataSetCache.xDataPixelMin, contourDataSetCache.yDataPixelMin, contourDataSetCache.xDataPixelRange, contourDataSetCache.yDataPixelRange);
        this.localCache.add(writableImage);
        ProcessingProfiler.getTimeDiff(l2, "drawHeatMap");
    }

    private void drawHexagonHeatMap(GraphicsContext graphicsContext, ContourDataSetCache contourDataSetCache) {
        long l2 = ProcessingProfiler.getTimeStamp();
        WritableImage writableImage = this.localCache.convertDataArrayToImage(contourDataSetCache.reduced, contourDataSetCache.xSize, contourDataSetCache.ySize, this.getColorGradient());
        int n4 = Math.max(this.getMinHexTileSizeProperty(), (int)contourDataSetCache.xAxisWidth / contourDataSetCache.xSize);
        int n5 = (int)(contourDataSetCache.xAxisWidth / ((double)n4 * Math.sqrt(3.0))) + 1;
        HexagonMap hexagonMap2 = new HexagonMap(n4, (Image)writableImage, n5, (n2, n3, color, hexagonMap) -> {
            Hexagon hexagon = new Hexagon(n2, n3);
            hexagon.setFill((Paint)color);
            hexagon.setStroke((Paint)color);
            hexagon.setStrokeWidth(0.5);
            hexagonMap.addHexagon(hexagon);
        });
        this.localCache.add(writableImage);
        ProcessingProfiler.getTimeDiff(l2, "drawHexagonMap - prepare");
        double d2 = contourDataSetCache.xDataPixelRange / contourDataSetCache.xAxisWidth;
        double d3 = contourDataSetCache.yDataPixelRange / contourDataSetCache.yAxisHeight;
        graphicsContext.save();
        graphicsContext.translate(contourDataSetCache.xDataPixelMin, contourDataSetCache.yDataPixelMin);
        graphicsContext.scale(d2, d3);
        hexagonMap2.render(graphicsContext.getCanvas());
        graphicsContext.restore();
        ProcessingProfiler.getTimeDiff(l2, "drawHexagonMap");
    }

    private void drawHexagonMapContour(GraphicsContext graphicsContext, ContourDataSetCache contourDataSetCache) {
        long l2 = ProcessingProfiler.getTimeStamp();
        WritableImage writableImage = this.localCache.convertDataArrayToImage(contourDataSetCache.reduced, contourDataSetCache.xSize, contourDataSetCache.ySize, this.getColorGradient());
        int n4 = Math.max(this.getMinHexTileSizeProperty(), (int)contourDataSetCache.xAxisWidth / contourDataSetCache.xSize);
        int n5 = (int)(contourDataSetCache.xAxisWidth / ((double)n4 * Math.sqrt(3.0)));
        HexagonMap hexagonMap2 = new HexagonMap(n4, (Image)writableImage, n5, (n2, n3, color, hexagonMap) -> {
            Hexagon hexagon = new Hexagon(n2, n3);
            hexagon.setFill((Paint)Color.TRANSPARENT);
            hexagon.setStroke((Paint)color);
            hexagon.setStrokeType(StrokeType.CENTERED);
            hexagon.setStrokeWidth(1.0);
            hexagonMap.addHexagon(hexagon);
        });
        this.localCache.add(writableImage);
        ProcessingProfiler.getTimeDiff(l2, "drawHexagonMapContour - prepare");
        double d2 = contourDataSetCache.xDataPixelRange / contourDataSetCache.xAxisWidth;
        double d3 = contourDataSetCache.yDataPixelRange / contourDataSetCache.yAxisHeight;
        graphicsContext.save();
        graphicsContext.translate(contourDataSetCache.xDataPixelMin, contourDataSetCache.yDataPixelMin);
        graphicsContext.scale(d2, d3);
        hexagonMap2.renderContour(graphicsContext.getCanvas());
        graphicsContext.restore();
        ProcessingProfiler.getTimeDiff(l2, "drawHexagonMapContour");
    }

    @Override
    protected ContourDataSetRenderer getThis() {
        return this;
    }

    protected void layoutZAxis(Axis axis) {
        if (axis.getSide() == null || !(axis instanceof Node)) {
            return;
        }
        Node node = (Node)axis;
        node.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
        this.gradientBar.setColorGradient(this.getColorGradient());
        this.gradientBar.setAxis(axis);
    }

    private void paintCanvas(GraphicsContext graphicsContext) {
        if (this.localCache.xSize == 0 || this.localCache.ySize == 0) {
            return;
        }
        AxisTransform axisTransform = this.zAxis.getAxisTransform();
        if (axisTransform == null) {
            return;
        }
        switch (this.getContourType()) {
            case CONTOUR: {
                this.drawContour(graphicsContext, this.localCache);
                break;
            }
            case CONTOUR_FAST: {
                this.drawContourFast(graphicsContext, axisTransform, this.localCache);
                break;
            }
            case CONTOUR_HEXAGON: {
                this.drawHexagonMapContour(graphicsContext, this.localCache);
                break;
            }
            case HEATMAP_HEXAGON: {
                this.drawHexagonHeatMap(graphicsContext, this.localCache);
                break;
            }
            default: {
                this.drawHeatMap(graphicsContext, this.localCache);
            }
        }
    }

    @Override
    public void runPreLayout() {
        this.layoutZAxis(this.zAxis);
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        long l2 = ProcessingProfiler.getTimeStamp();
        this.localCache = new ContourDataSetCache(this.getChart(), this, dataSet);
        ProcessingProfiler.getTimeDiff(l2, "updateCachedVariables");
        this.paintCanvas(graphicsContext);
        this.localCache.releaseCachedVariables();
        ProcessingProfiler.getTimeDiff(l2, "finished drawing");
    }

    @Override
    public void shiftZAxisToLeft() {
        super.shiftZAxisToLeft();
        this.gradientBar.toBack();
        if (this.zAxis instanceof Node) {
            ((Node)this.zAxis).toBack();
        }
    }

    @Override
    public void shiftZAxisToRight() {
        super.shiftZAxisToRight();
        this.gradientBar.toFront();
        if (this.zAxis instanceof Node) {
            ((Node)this.zAxis).toFront();
        }
    }

    public static double convolution(double[][] dArray) {
        double d2 = dArray[0][0] * -1.0 + dArray[0][1] * -2.0 + dArray[0][2] * -1.0 + dArray[2][0] + dArray[2][1] * 2.0 + dArray[2][2] * 1.0;
        double d3 = dArray[0][0] + dArray[0][2] * -1.0 + dArray[1][0] * 2.0 + dArray[1][2] * -2.0 + dArray[2][0] + dArray[2][2] * -1.0;
        return Math.sqrt(Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
    }

    public static double erosionConvolution(double[][] dArray) {
        double d2 = 0.0;
        d2 += dArray[0][0];
        d2 += dArray[0][1];
        d2 += dArray[0][2];
        d2 += dArray[1][0];
        d2 += dArray[1][1];
        d2 += dArray[1][2];
        d2 += dArray[2][0];
        d2 += dArray[2][1];
        return d2 += dArray[2][2];
    }

    private static void erosionOperator(double[][] dArray, double[][] dArray2, double d2, double d3, double d4) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray3 = new double[n2][n3];
        double[][] dArray4 = new double[n2][n3];
        double[][] dArray5 = new double[3][3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (i2 == 0 || i2 == n2 - 1 || i3 == 0 || i3 == n3 - 1) {
                    dArray2[i2][i3] = 0.0;
                    dArray4[i2][i3] = 0.0;
                    dArray3[i2][i3] = 0.0;
                    continue;
                }
                dArray5[0][0] = dArray[i2 - 1][i3 - 1] > d4 ? 1.0 : 0.0;
                dArray5[0][1] = dArray[i2 - 1][i3] > d4 ? 1.0 : 0.0;
                dArray5[0][2] = dArray[i2 - 1][i3 + 1] > d4 ? 1.0 : 0.0;
                dArray5[1][0] = dArray[i2][i3 - 1] > d4 ? 1.0 : 0.0;
                dArray5[1][2] = dArray[i2][i3 + 1] > d4 ? 1.0 : 0.0;
                dArray5[2][0] = dArray[i2 + 1][i3 - 1] > d4 ? 1.0 : 0.0;
                dArray5[2][1] = dArray[i2 + 1][i3] > d4 ? 1.0 : 0.0;
                dArray5[2][2] = dArray[i2 + 1][i3 + 1] > d4 ? 1.0 : 0.0;
                double d5 = ContourDataSetRenderer.erosionConvolution(dArray5);
                dArray2[i2][i3] = d5 > 4.0 ? 1.0 : 0.0;
            }
        }
    }

    private static double quantize(double d2, int n2) {
        return (double)((int)(d2 * (double)n2)) / (double)n2;
    }

    private static void sobelOperator(double[][] dArray, double[][] dArray2, double d2, double d3, double d4) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray3 = new double[n2][n3];
        double[][] dArray4 = new double[n2][n3];
        double[][] dArray5 = new double[3][3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (i2 == 0 || i2 == n2 - 1 || i3 == 0 || i3 == n3 - 1) {
                    dArray2[i2][i3] = 0.0;
                    dArray4[i2][i3] = 0.0;
                    dArray3[i2][i3] = 0.0;
                    continue;
                }
                dArray5[0][0] = dArray[i2 - 1][i3 - 1] > d4 ? 1.0 : 0.0;
                dArray5[0][1] = dArray[i2 - 1][i3] > d4 ? 1.0 : 0.0;
                dArray5[0][2] = dArray[i2 - 1][i3 + 1] > d4 ? 1.0 : 0.0;
                dArray5[1][0] = dArray[i2][i3 - 1] > d4 ? 1.0 : 0.0;
                dArray5[1][2] = dArray[i2][i3 + 1] > d4 ? 1.0 : 0.0;
                dArray5[2][0] = dArray[i2 + 1][i3 - 1] > d4 ? 1.0 : 0.0;
                dArray5[2][1] = dArray[i2 + 1][i3] > d4 ? 1.0 : 0.0;
                dArray5[2][2] = dArray[i2 + 1][i3 + 1] > d4 ? 1.0 : 0.0;
                dArray2[i2][i3] = ContourDataSetRenderer.convolution(dArray5);
            }
        }
    }

    static class ColorGradientBar
    extends Rectangle {
        final ChangeListener<Object> updateListener = (observableValue, object, object2) -> this.update();
        final ObjectProperty<Axis> axis = new SimpleObjectProperty(null);
        final ObjectBinding<Node> axisNode = Bindings.createObjectBinding(() -> {
            if (this.axis.get() != null && this.axis.get() instanceof Node) {
                return (Node)this.axis.get();
            }
            return null;
        }, (Observable[])new Observable[]{this.axis});
        final ObjectProperty<ColorGradient> colorGradient = new SimpleObjectProperty(null);
        private static final double gradientSize = 20.0;

        ColorGradientBar() {
            this.colorGradient.addListener(this.updateListener);
            this.axis.addListener((observableValue, axis, axis2) -> {
                if (axis != null) {
                    axis.sideProperty().removeListener(this.updateListener);
                }
                if (axis2 != null) {
                    axis2.sideProperty().addListener(this.updateListener);
                }
            });
            this.axis.addListener(this.updateListener);
            this.axisNode.addListener((observableValue, node, node2) -> {
                if (node != null) {
                    node.parentProperty().removeListener(this.updateListener);
                }
                if (node2 != null) {
                    node2.parentProperty().addListener(this.updateListener);
                }
            });
        }

        void setAxis(Axis axis) {
            this.axis.set((Object)axis);
        }

        public void setColorGradient(ColorGradient colorGradient) {
            this.colorGradient.set((Object)colorGradient);
        }

        private void update() {
            if (this.axisNode.get() == null || ((Node)this.axisNode.get()).getParent() == null) {
                if (this.getParent() != null) {
                    ((Pane)this.getParent()).getChildren().remove((Object)this);
                }
                return;
            }
            ObservableList observableList = ((ChartPane)((Node)this.axisNode.get()).getParent()).getChildren();
            Side side = ((Axis)this.axis.get()).getSide();
            observableList.remove((Object)this);
            ChartPane.setSide((Node)this, side);
            int n2 = observableList.indexOf(this.axisNode.get());
            switch (side) {
                case BOTTOM: 
                case RIGHT: 
                case CENTER_VER: 
                case CENTER_HOR: {
                    observableList.add(n2, (Object)this);
                    break;
                }
                case TOP: 
                case LEFT: {
                    observableList.add(n2 + 1, (Object)this);
                }
            }
            if (this.colorGradient.get() != null) {
                if (side.isHorizontal()) {
                    this.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, ((ColorGradient)this.colorGradient.get()).getStops()));
                } else {
                    this.setFill((Paint)new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, ((ColorGradient)this.colorGradient.get()).getStops()));
                }
            }
        }

        public void resize(double d2, double d3) {
            this.setWidth(d2);
            this.setHeight(d3);
        }

        public double prefWidth(double d2) {
            return 20.0;
        }

        public double prefHeight(double d2) {
            return 20.0;
        }
    }
}

