/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements.utils;

import io.fair_acc.chartfx.plugins.ParameterMeasurements;
import io.fair_acc.chartfx.plugins.measurements.AbstractChartMeasurement;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartMeasurementSelector
extends GridPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartMeasurementSelector.class);
    private static final int DEFAULT_SELECTOR_HEIGHT = 50;
    private static final int ROW_HEIGHT = 24;
    protected final ListView<AbstractChartMeasurement> chartMeasurementListView;

    public ChartMeasurementSelector(ParameterMeasurements parameterMeasurements, AbstractChartMeasurement abstractChartMeasurement, int n2) {
        if (parameterMeasurements == null) {
            throw new IllegalArgumentException("plugin must not be null");
        }
        Label label = new Label("Selected Measurement: ");
        GridPane.setConstraints((Node)label, (int)0, (int)0);
        this.chartMeasurementListView = new ListView((ObservableList)parameterMeasurements.getChartMeasurements().filtered(abstractChartMeasurement2 -> !abstractChartMeasurement2.equals(abstractChartMeasurement)));
        GridPane.setConstraints(this.chartMeasurementListView, (int)1, (int)0);
        this.chartMeasurementListView.setOrientation(Orientation.VERTICAL);
        this.chartMeasurementListView.setPrefSize(-1.0, 50.0);
        this.chartMeasurementListView.setCellFactory(listView -> new ChartMeasurementLabel());
        this.chartMeasurementListView.setPrefHeight((double)(Math.max(2, parameterMeasurements.getChartMeasurements().size()) * 24) + 2.0);
        MultipleSelectionModel multipleSelectionModel = this.chartMeasurementListView.getSelectionModel();
        if (n2 == 1) {
            multipleSelectionModel.setSelectionMode(SelectionMode.SINGLE);
        } else if (n2 >= 2) {
            multipleSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        }
        if (multipleSelectionModel.getSelectedIndices().isEmpty() && parameterMeasurements.getChartMeasurements().size() >= n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                multipleSelectionModel.select(i2);
            }
        }
        if (multipleSelectionModel.getSelectedIndices().size() < n2 && LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().addArgument(parameterMeasurements.getChartMeasurements().size()).addArgument(n2).log("could not add default selection: required {} vs. selected {}");
        }
        if (n2 >= 1) {
            this.getChildren().addAll((Object[])new Node[]{label, this.chartMeasurementListView});
        }
    }

    public AbstractChartMeasurement getSelectedChartMeasurement() {
        MultipleSelectionModel multipleSelectionModel = this.chartMeasurementListView.getSelectionModel();
        return (AbstractChartMeasurement)multipleSelectionModel.getSelectedItem();
    }

    public ObservableList<AbstractChartMeasurement> getSelectedChartMeasurements() {
        MultipleSelectionModel multipleSelectionModel = this.chartMeasurementListView.getSelectionModel();
        return multipleSelectionModel.getSelectedItems();
    }

    protected static class ChartMeasurementLabel
    extends ListCell<AbstractChartMeasurement> {
        protected ChartMeasurementLabel() {
        }

        public void updateItem(AbstractChartMeasurement abstractChartMeasurement, boolean bl2) {
            super.updateItem((Object)abstractChartMeasurement, bl2);
            if (abstractChartMeasurement != null) {
                String string = abstractChartMeasurement.getDataSet() == null ? "n/a" : abstractChartMeasurement.getDataSet().getName();
                this.setText(abstractChartMeasurement.getTitle() + "<" + string + ">");
            }
        }
    }
}

