/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.ValueIndicator;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.dataset.events.EventSource;
import java.util.Arrays;
import java.util.Comparator;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class YWatchValueIndicator
extends AbstractSingleValueIndicator
implements EventSource,
ValueIndicator {
    protected static final String STYLE_CLASS_LABEL = "value-watch-indicator-label";
    protected static final String STYLE_CLASS_LINE = "value-watch-indicator-line";
    protected static final String STYLE_CLASS_MARKER = "value-watch-indicator-marker";
    public static final String WATCH_INDICATOR_PREVENT_OCCLUSION = "WatchIndicatorPreventOcclusion";
    protected String id;

    public YWatchValueIndicator(Axis axis, double d2) {
        super(axis, d2, axis.getTickMarkLabel(d2));
        this.triangle.visibleProperty().unbind();
        this.triangle.visibleProperty().set(true);
        this.pickLine.setOnMouseDragged(this::handleDragMouseEvent);
        this.triangle.setOnMouseDragged(this::handleDragMouseEvent);
        this.label.setOnMouseDragged(this::handleDragMouseEvent);
    }

    public YWatchValueIndicator(Axis axis) {
        this(axis, 0.0);
    }

    @Deprecated
    public YWatchValueIndicator(Axis axis, String string, double d2) {
        this(axis, d2);
    }

    @Deprecated
    public YWatchValueIndicator(Axis axis, String string) {
        this(axis, 0.0);
    }

    public void setMarkerValue(double d2) {
        this.setText(this.getAxis().getTickMarkLabel(d2));
        this.setValue(d2);
    }

    public void setLineVisible(boolean bl2) {
        this.line.setVisible(bl2);
        this.pickLine.setVisible(bl2);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    protected void handleDragMouseEvent(MouseEvent mouseEvent) {
        Point2D point2D = this.getChart().getPlotArea().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        double d2 = this.getAxis().getValueForDisplay(point2D.getY() - this.dragDelta.y);
        if (this.getAxis().isValueOnAxis(d2)) {
            this.setMarkerValue(d2);
        }
        mouseEvent.consume();
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null) {
            return;
        }
        Bounds bounds = this.getChart().getCanvas().getBoundsInLocal();
        double d2 = bounds.getMinX();
        double d3 = bounds.getMaxX();
        double d4 = bounds.getMinY();
        double d5 = bounds.getMaxY();
        double d6 = this.label.getHeight() / 2.0;
        double d7 = this.label.getWidth() + 10.0;
        double d8 = d4 + this.getAxis().getDisplayPosition(this.getValue());
        boolean bl2 = this.getAxis().getSide().equals((Object)Side.RIGHT);
        double d9 = bl2 ? this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(0.0, 0.0)).getX() + 2.0 : this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(this.getAxis().getWidth(), 0.0)).getX() - 2.0;
        double d10 = this.getChart().getPlotForeground().sceneToLocal(this.getChart().getCanvas().localToScene(0.0, d8)).getY();
        if (d8 < d4 || d8 > d5) {
            this.getChart().getPlotForeground().getChildren().remove((Object)this.triangle);
            this.getChart().getPlotForeground().getChildren().remove((Object)this.label);
            this.getChartChildren().remove((Object)this.line);
            this.getChartChildren().remove((Object)this.pickLine);
        } else {
            this.layoutLine(d2, d8, d3, d8);
            this.layoutMarker(d9, d10, d2, d8);
            this.layoutWatchLabel(d9, d10, bl2, d6, d7);
        }
    }

    @Override
    protected void layoutLine(double d2, double d3, double d4, double d5) {
        if (!this.line.isVisible()) {
            return;
        }
        super.layoutLine(d2, d3, d4, d5);
    }

    protected void layoutWatchLabel(double d2, double d3, boolean bl2, Double d4, Double d5) {
        if (this.label.getText() == null || this.label.getText().isEmpty()) {
            this.getChartChildren().remove((Object)this.label);
            return;
        }
        double d6 = this.label.prefWidth(-1.0);
        double d7 = this.label.prefHeight(d6);
        double d8 = 2.0;
        if (this.isPreventOcclusion()) {
            double d9;
            double d10;
            int n2;
            YWatchValueIndicator[] yWatchValueIndicatorArray = (YWatchValueIndicator[])this.getChart().getPlugins().filtered(chartPlugin -> chartPlugin instanceof YWatchValueIndicator && ((YWatchValueIndicator)chartPlugin).getAxis() == this.getAxis()).toArray((Object[])new YWatchValueIndicator[0]);
            Arrays.sort(yWatchValueIndicatorArray, Comparator.comparingDouble(AbstractSingleValueIndicator::getValue).reversed());
            double[] dArray = Arrays.stream(yWatchValueIndicatorArray).mapToDouble(yWatchValueIndicator -> yWatchValueIndicator.triangle.getTranslateY()).toArray();
            for (n2 = 0; n2 < dArray.length - 1; ++n2) {
                d10 = dArray[n2 + 1] - dArray[n2];
                if (!(d7 + 2.0 > d10)) continue;
                d9 = d4 - 0.5 * d10 + 1.0;
                int n3 = n2 + 1;
                dArray[n3] = dArray[n3] + d9;
                int n4 = n2;
                dArray[n4] = dArray[n4] - d9;
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    double d11 = dArray[i2 + 1] - dArray[i2];
                    if (!(d7 + 2.0 > d11)) continue;
                    int n5 = i2;
                    dArray[n5] = dArray[n5] - (2.0 * d4 - d11 + 2.0);
                }
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                d10 = dArray[n2] - yWatchValueIndicatorArray[n2].triangle.getTranslateY();
                d9 = d10 + d4;
                double d12 = d10 - d4;
                if (bl2) {
                    yWatchValueIndicatorArray[n2].triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, 10.0, d9, d5, d9, d5, d12, 10.0, d12});
                } else {
                    yWatchValueIndicatorArray[n2].triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, -10.0, d9, -d5.doubleValue(), d9, -d5.doubleValue(), d12, -10.0, d12});
                }
                yWatchValueIndicatorArray[n2].label.resizeRelocate(bl2 ? d2 : d2 - d6, yWatchValueIndicatorArray[n2].triangle.getTranslateY() - 0.5 * d7 + d10, d6, d7);
            }
        } else {
            if (bl2) {
                this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, 10.0, d4, d5, d4, d5, -d4.doubleValue(), 10.0, -d4.doubleValue()});
            } else {
                this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, -10.0, d4, -d5.doubleValue(), d4, -d5.doubleValue(), -d4.doubleValue(), -10.0, -d4.doubleValue()});
            }
            this.label.resizeRelocate(bl2 ? d2 : d2 - d6, d3 - 0.5 * d7, d6, d7);
        }
        this.label.toFront();
        if (!this.getChart().getPlotForeground().getChildren().contains((Object)this.label)) {
            this.getChart().getPlotForeground().getChildren().add((Object)this.label);
        }
    }

    @Override
    public void updateStyleClass() {
        this.setStyleClasses((Node)this.label, this.getId() + "-", STYLE_CLASS_LABEL);
        this.setStyleClasses((Node)this.line, this.getId() + "-", STYLE_CLASS_LINE);
        this.setStyleClasses((Node)this.triangle, this.getId() + "-", STYLE_CLASS_MARKER);
    }

    public boolean isPreventOcclusion() {
        return this.getAxis() instanceof Node && ((Node)this.getAxis()).getProperties().get((Object)WATCH_INDICATOR_PREVENT_OCCLUSION) == Boolean.TRUE;
    }

    public void setPreventOcclusion(boolean bl2) {
        if (bl2) {
            ((Node)this.getAxis()).getProperties().put((Object)WATCH_INDICATOR_PREVENT_OCCLUSION, (Object)true);
        } else {
            ((Node)this.getAxis()).getProperties().remove((Object)WATCH_INDICATOR_PREVENT_OCCLUSION);
        }
    }
}

