/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.bench;

import io.fair_acc.chartfx.axes.AxisLabelOverlapPolicy;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.bench.HdrHistogramDataSet;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.util.WeakHashMap;
import javafx.util.StringConverter;

class PercentileAxis
extends DefaultNumericAxis {
    DoubleArrayList majorTicks = new DoubleArrayList();
    DoubleArrayList minorTicks = new DoubleArrayList();
    private static WeakHashMap<Number, String> labelCache = new WeakHashMap();

    PercentileAxis() {
        super("Percentile");
        this.setUnit(null);
        this.setAxisLabelGap(10.0);
        this.setLogAxis(true);
        this.setLogarithmBase(10.0);
        this.setMinorTickCount(10);
        this.setForceZeroInRange(true);
        this.setOverlapPolicy(AxisLabelOverlapPolicy.SKIP_ALT);
        this.setTickLabelFormatter(new StringConverter<Number>(){

            public String toString(Number number2) {
                return labelCache.computeIfAbsent(number2, number -> {
                    String string = String.valueOf(HdrHistogramDataSet.convertPercentileFromX(number.doubleValue()));
                    if (string.endsWith(".0")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    return string + "%";
                });
            }

            public Number fromString(String string) {
                throw new IllegalStateException("not implemented");
            }
        });
    }

    @Override
    protected AxisRange computeRange(double d2, double d3, double d4, double d5) {
        return super.computeRange(d2, d3 + 5.0, d4, d5);
    }

    @Override
    protected void calculateMajorTickValues(AxisRange axisRange, DoubleArrayList doubleArrayList) {
        this.precomputeTicks(axisRange.getUpperBound());
        double d2 = axisRange.getLowerBound();
        double d3 = axisRange.getUpperBound();
        this.majorTicks.forEach(d4 -> {
            if (d4 >= d2 && d4 <= d3) {
                doubleArrayList.add(d4);
            }
        });
    }

    @Override
    protected void calculateMinorTickValues(DoubleArrayList doubleArrayList) {
        if (this.getMinorTickCount() <= 0 || this.getTickUnit() <= 0.0) {
            return;
        }
        double d2 = this.getMin();
        double d3 = this.getMax();
        this.minorTicks.forEach(d4 -> {
            if (d4 >= d2 && d4 <= d3) {
                doubleArrayList.add(d4);
            }
        });
    }

    private void precomputeTicks(double d2) {
        if (this.majorTicks.size() > 0 && d2 <= this.majorTicks.getDouble(this.majorTicks.size() - 1)) {
            return;
        }
        this.majorTicks.clear();
        this.minorTicks.clear();
        this.majorTicks.add(HdrHistogramDataSet.convertPercentileToX(0.0));
        this.majorTicks.add(HdrHistogramDataSet.convertPercentileToX(25.0));
        for (double d3 = 1.0; d3 < d2; d3 *= 10.0) {
            this.majorTicks.add(d3 * 2.0);
            this.minorTicks.add(d3 * 3.0);
            this.majorTicks.add(d3 * 4.0);
            this.minorTicks.add(d3 * 5.0);
            this.minorTicks.add(d3 * 6.0);
            this.minorTicks.add(d3 * 7.0);
            this.minorTicks.add(d3 * 8.0);
            this.minorTicks.add(d3 * 9.0);
            this.majorTicks.add(d3 * 10.0);
        }
    }
}

