/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import java.net.InetSocketAddress;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.status.AtomicCounter;

public final class DriverConductorProxy {
    private final ThreadingMode threadingMode;
    private final QueuedPipe<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private DriverConductor driverConductor;

    DriverConductorProxy(ThreadingMode threadingMode, QueuedPipe<Runnable> queuedPipe, AtomicCounter atomicCounter) {
        this.threadingMode = threadingMode;
        this.commandQueue = queuedPipe;
        this.failCount = atomicCounter;
    }

    public void channelEndpointError(long l2, Exception exception) {
        if (this.notConcurrent()) {
            this.driverConductor.onChannelEndpointError(l2, exception);
        } else {
            this.offer(() -> this.driverConductor.onChannelEndpointError(l2, exception));
        }
    }

    public void reResolveEndpoint(String string, SendChannelEndpoint sendChannelEndpoint, InetSocketAddress inetSocketAddress) {
        if (this.notConcurrent()) {
            this.driverConductor.onReResolveEndpoint(string, sendChannelEndpoint, inetSocketAddress);
        } else {
            this.offer(() -> this.driverConductor.onReResolveEndpoint(string, sendChannelEndpoint, inetSocketAddress));
        }
    }

    public void reResolveControl(String string, UdpChannel udpChannel, ReceiveChannelEndpoint receiveChannelEndpoint, InetSocketAddress inetSocketAddress) {
        if (this.notConcurrent()) {
            this.driverConductor.onReResolveControl(string, udpChannel, receiveChannelEndpoint, inetSocketAddress);
        } else {
            this.offer(() -> this.driverConductor.onReResolveControl(string, udpChannel, receiveChannelEndpoint, inetSocketAddress));
        }
    }

    public void closeReceiveDestinationIndicators(ReceiveDestinationTransport receiveDestinationTransport) {
        if (this.notConcurrent()) {
            this.driverConductor.closeReceiveDestinationIndicators(receiveDestinationTransport);
        } else {
            this.offer(() -> this.driverConductor.closeReceiveDestinationIndicators(receiveDestinationTransport));
        }
    }

    public boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    public ThreadingMode threadingMode() {
        return this.threadingMode;
    }

    public String toString() {
        return "DriverConductorProxy{threadingMode=" + (Object)((Object)this.threadingMode) + ", failCount=" + this.failCount + '}';
    }

    void driverConductor(DriverConductor driverConductor) {
        this.driverConductor = driverConductor;
    }

    void createPublicationImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ReceiveChannelEndpoint receiveChannelEndpoint) {
        if (this.notConcurrent()) {
            this.driverConductor.onCreatePublicationImage(n2, n3, n4, n5, n6, n7, n8, n9, inetSocketAddress, inetSocketAddress2, receiveChannelEndpoint);
        } else {
            this.offer(() -> this.driverConductor.onCreatePublicationImage(n2, n3, n4, n5, n6, n7, n8, n9, inetSocketAddress, inetSocketAddress2, receiveChannelEndpoint));
        }
    }

    private void offer(Runnable runnable) {
        while (!this.commandQueue.offer(runnable)) {
            if (!this.failCount.isClosed()) {
                this.failCount.increment();
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new AgentTerminationException("interrupted");
        }
    }
}

