/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.LogBuffers;
import io.aeron.Subscription;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.Header;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.RawBlockHandler;
import io.aeron.logbuffer.TermBlockScanner;
import io.aeron.logbuffer.TermReader;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.agrona.BitUtil;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;

public final class Image {
    private final long correlationId;
    private final long joinPosition;
    private long finalPosition;
    private final int sessionId;
    private final int initialTermId;
    private final int termLengthMask;
    private final int positionBitsToShift;
    private boolean isEos;
    private volatile boolean isClosed;
    private final Position subscriberPosition;
    private final UnsafeBuffer[] termBuffers;
    private final Header header;
    private final ErrorHandler errorHandler;
    private final LogBuffers logBuffers;
    private final String sourceIdentity;
    private final Subscription subscription;

    public Image(Subscription subscription, int n2, Position position, LogBuffers logBuffers, ErrorHandler errorHandler, String string, long l2) {
        this.subscription = subscription;
        this.sessionId = n2;
        this.subscriberPosition = position;
        this.logBuffers = logBuffers;
        this.errorHandler = errorHandler;
        this.sourceIdentity = string;
        this.correlationId = l2;
        this.joinPosition = position.get();
        this.termBuffers = logBuffers.duplicateTermBuffers();
        int n3 = logBuffers.termLength();
        this.termLengthMask = n3 - 1;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(n3);
        this.initialTermId = LogBufferDescriptor.initialTermId(logBuffers.metaDataBuffer());
        this.header = new Header(this.initialTermId, this.positionBitsToShift, this);
    }

    public int positionBitsToShift() {
        return this.positionBitsToShift;
    }

    public int termBufferLength() {
        return this.termLengthMask + 1;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public String sourceIdentity() {
        return this.sourceIdentity;
    }

    public int mtuLength() {
        return LogBufferDescriptor.mtuLength(this.logBuffers.metaDataBuffer());
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long joinPosition() {
        return this.joinPosition;
    }

    public long position() {
        if (this.isClosed) {
            return this.finalPosition;
        }
        return this.subscriberPosition.get();
    }

    public void position(long l2) {
        if (!this.isClosed) {
            this.validatePosition(l2);
            this.subscriberPosition.setOrdered(l2);
        }
    }

    public int subscriberPositionId() {
        return this.subscriberPosition.id();
    }

    public boolean isEndOfStream() {
        if (this.isClosed) {
            return this.isEos;
        }
        return this.subscriberPosition.get() >= LogBufferDescriptor.endOfStreamPosition(this.logBuffers.metaDataBuffer());
    }

    public int activeTransportCount() {
        if (this.isClosed) {
            return 0;
        }
        return LogBufferDescriptor.activeTransportCount(this.logBuffers.metaDataBuffer());
    }

    public FileChannel fileChannel() {
        return this.logBuffers.fileChannel();
    }

    public int poll(FragmentHandler fragmentHandler, int n2) {
        if (this.isClosed) {
            return 0;
        }
        long l2 = this.subscriberPosition.get();
        return TermReader.read(this.activeTermBuffer(l2), (int)l2 & this.termLengthMask, fragmentHandler, n2, this.header, this.errorHandler, l2, this.subscriberPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int controlledPoll(ControlledFragmentHandler controlledFragmentHandler, int n2) {
        int n3;
        int n4;
        if (this.isClosed) {
            return 0;
        }
        int n5 = 0;
        long l2 = this.subscriberPosition.get();
        UnsafeBuffer unsafeBuffer = this.activeTermBuffer(l2);
        int n6 = unsafeBuffer.capacity();
        Header header = this.header;
        header.buffer(unsafeBuffer);
        try {
            int n7;
            for (n4 = n3 = (int)l2 & this.termLengthMask; n5 < n2 && n4 < n6; n4 += n7) {
                int n8 = FrameDescriptor.frameLengthVolatile(unsafeBuffer, n4);
                if (n8 <= 0) {
                } else {
                    int n9 = n4;
                    n7 = BitUtil.align(n8, 32);
                    if (FrameDescriptor.isPaddingFrame(unsafeBuffer, n9)) continue;
                    ++n5;
                    header.offset(n9);
                    ControlledFragmentHandler.Action action = controlledFragmentHandler.onFragment(unsafeBuffer, n9 + 32, n8 - 32, header);
                    if (ControlledFragmentHandler.Action.ABORT == action) {
                        --n5;
                        n4 -= n7;
                    } else if (ControlledFragmentHandler.Action.BREAK != action) continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.errorHandler.onError(exception);
        }
        finally {
            long l3 = l2 + (long)(n4 - n3);
            if (l3 > l2) {
                this.subscriberPosition.setOrdered(l3);
            }
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int boundedPoll(FragmentHandler fragmentHandler, long l2, int n2) {
        int n3;
        int n4;
        if (this.isClosed) {
            return 0;
        }
        long l3 = this.subscriberPosition.get();
        if (l3 >= l2) {
            return 0;
        }
        int n5 = 0;
        UnsafeBuffer unsafeBuffer = this.activeTermBuffer(l3);
        int n6 = (int)Math.min((long)unsafeBuffer.capacity(), l2 - l3 + (long)n4);
        Header header = this.header;
        header.buffer(unsafeBuffer);
        try {
            int n7;
            for (n4 = n3 = (int)l3 & this.termLengthMask; n5 < n2 && n4 < n6; n4 += n7) {
                int n8 = FrameDescriptor.frameLengthVolatile(unsafeBuffer, n4);
                if (n8 <= 0) {
                    break;
                }
                int n9 = n4;
                n7 = BitUtil.align(n8, 32);
                if (FrameDescriptor.isPaddingFrame(unsafeBuffer, n9)) continue;
                ++n5;
                header.offset(n9);
                fragmentHandler.onFragment(unsafeBuffer, n9 + 32, n8 - 32, header);
            }
        }
        catch (Exception exception) {
            this.errorHandler.onError(exception);
        }
        finally {
            long l4 = l3 + (long)(n4 - n3);
            if (l4 > l3) {
                this.subscriberPosition.setOrdered(l4);
            }
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int boundedControlledPoll(ControlledFragmentHandler controlledFragmentHandler, long l2, int n2) {
        int n3;
        int n4;
        if (this.isClosed) {
            return 0;
        }
        long l3 = this.subscriberPosition.get();
        if (l3 >= l2) {
            return 0;
        }
        int n5 = 0;
        UnsafeBuffer unsafeBuffer = this.activeTermBuffer(l3);
        int n6 = (int)Math.min((long)unsafeBuffer.capacity(), l2 - l3 + (long)n4);
        Header header = this.header;
        header.buffer(unsafeBuffer);
        try {
            int n7;
            for (n4 = n3 = (int)l3 & this.termLengthMask; n5 < n2 && n4 < n6; n4 += n7) {
                int n8 = FrameDescriptor.frameLengthVolatile(unsafeBuffer, n4);
                if (n8 <= 0) {
                } else {
                    int n9 = n4;
                    n7 = BitUtil.align(n8, 32);
                    if (FrameDescriptor.isPaddingFrame(unsafeBuffer, n9)) continue;
                    ++n5;
                    header.offset(n9);
                    ControlledFragmentHandler.Action action = controlledFragmentHandler.onFragment(unsafeBuffer, n9 + 32, n8 - 32, header);
                    if (ControlledFragmentHandler.Action.ABORT == action) {
                        --n5;
                        n4 -= n7;
                    } else if (ControlledFragmentHandler.Action.BREAK != action) continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.errorHandler.onError(exception);
        }
        finally {
            long l4 = l3 + (long)(n4 - n3);
            if (l4 > l3) {
                this.subscriberPosition.setOrdered(l4);
            }
        }
        return n5;
    }

    public long controlledPeek(long l2, ControlledFragmentHandler controlledFragmentHandler, long l3) {
        int n2;
        if (this.isClosed) {
            return l2;
        }
        this.validatePosition(l2);
        if (l2 >= l3) {
            return l2;
        }
        int n3 = n2 = (int)l2 & this.termLengthMask;
        long l4 = l2;
        UnsafeBuffer unsafeBuffer = this.activeTermBuffer(l2);
        Header header = this.header;
        int n4 = (int)Math.min((long)unsafeBuffer.capacity(), l3 - l2 + (long)n3);
        header.buffer(unsafeBuffer);
        long l5 = l2;
        try {
            int n5;
            while (n3 < n4 && (n5 = FrameDescriptor.frameLengthVolatile(unsafeBuffer, n3)) > 0) {
                int n6 = n3;
                n3 += BitUtil.align(n5, 32);
                if (FrameDescriptor.isPaddingFrame(unsafeBuffer, n6)) {
                    n2 = n3;
                    l5 = l4 += (long)(n3 - n2);
                    continue;
                }
                header.offset(n6);
                ControlledFragmentHandler.Action action = controlledFragmentHandler.onFragment(unsafeBuffer, n6 + 32, n5 - 32, header);
                if (ControlledFragmentHandler.Action.ABORT != action) {
                    l4 += (long)(n3 - n2);
                    n2 = n3;
                    if ((header.flags() & 0x40) == 64) {
                        l5 = l4;
                    }
                    if (ControlledFragmentHandler.Action.BREAK != action) continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.errorHandler.onError(exception);
        }
        return l5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockPoll(BlockHandler blockHandler, int n2) {
        if (this.isClosed) {
            return 0;
        }
        long l2 = this.subscriberPosition.get();
        int n3 = (int)l2 & this.termLengthMask;
        int n4 = Math.min(n3 + n2, this.termLengthMask + 1);
        UnsafeBuffer unsafeBuffer = this.activeTermBuffer(l2);
        int n5 = TermBlockScanner.scan(unsafeBuffer, n3, n4);
        int n6 = n5 - n3;
        if (n5 > n3) {
            try {
                int n7 = unsafeBuffer.getInt(n3 + 20, ByteOrder.LITTLE_ENDIAN);
                blockHandler.onBlock(unsafeBuffer, n3, n6, this.sessionId, n7);
            }
            catch (Exception exception) {
                this.errorHandler.onError(exception);
            }
            finally {
                this.subscriberPosition.setOrdered(l2 + (long)n6);
            }
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rawPoll(RawBlockHandler rawBlockHandler, int n2) {
        if (this.isClosed) {
            return 0;
        }
        long l2 = this.subscriberPosition.get();
        int n3 = (int)l2 & this.termLengthMask;
        int n4 = LogBufferDescriptor.indexByPosition(l2, this.positionBitsToShift);
        UnsafeBuffer unsafeBuffer = this.termBuffers[n4];
        int n5 = unsafeBuffer.capacity();
        int n6 = Math.min(n3 + n2, n5);
        int n7 = TermBlockScanner.scan(unsafeBuffer, n3, n6);
        int n8 = n7 - n3;
        if (n7 > n3) {
            try {
                long l3 = (long)n5 * (long)n4 + (long)n3;
                int n9 = unsafeBuffer.getInt(n3 + 20, ByteOrder.LITTLE_ENDIAN);
                rawBlockHandler.onBlock(this.logBuffers.fileChannel(), l3, unsafeBuffer, n3, n8, this.sessionId, n9);
            }
            catch (Exception exception) {
                this.errorHandler.onError(exception);
            }
            finally {
                this.subscriberPosition.setOrdered(l2 + (long)n8);
            }
        }
        return n8;
    }

    private UnsafeBuffer activeTermBuffer(long l2) {
        return this.termBuffers[LogBufferDescriptor.indexByPosition(l2, this.positionBitsToShift)];
    }

    private void validatePosition(long l2) {
        long l3 = this.subscriberPosition.get();
        long l4 = l3 - (l3 & (long)this.termLengthMask) + (long)this.termLengthMask + 1L;
        if (l2 < l3 || l2 > l4) {
            throw new IllegalArgumentException(l2 + " position out of range: " + l3 + "-" + l4);
        }
        if (0L != (l2 & 0x1FL)) {
            throw new IllegalArgumentException(l2 + " position not aligned to FRAME_ALIGNMENT");
        }
    }

    LogBuffers logBuffers() {
        return this.logBuffers;
    }

    void close() {
        this.finalPosition = this.subscriberPosition.getVolatile();
        this.isEos = this.finalPosition >= LogBufferDescriptor.endOfStreamPosition(this.logBuffers.metaDataBuffer());
        this.isClosed = true;
    }

    public String toString() {
        return "Image{correlationId=" + this.correlationId + ", sessionId=" + this.sessionId + ", isClosed=" + this.isClosed + ", isEos=" + this.isEndOfStream() + ", initialTermId=" + this.initialTermId + ", termLength=" + this.termBufferLength() + ", joinPosition=" + this.joinPosition + ", position=" + this.position() + ", activeTransportCount=" + this.activeTransportCount() + ", sourceIdentity='" + this.sourceIdentity + '\'' + ", subscription=" + this.subscription + '}';
    }
}

