/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.CncFileDescriptor;
import io.aeron.DriverProxy;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.errors.ErrorConsumer;
import org.agrona.concurrent.errors.ErrorLogReader;
import org.agrona.concurrent.errors.LoggingErrorHandler;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class CommonContext
implements Cloneable {
    public static final String DRIVER_TIMEOUT_PROP_NAME = "aeron.driver.timeout";
    public static final String DEBUG_TIMEOUT_PROP_NAME = "aeron.debug.timeout";
    public static final long DEFAULT_DRIVER_TIMEOUT_MS = 10000L;
    public static final long DRIVER_TIMEOUT_MS;
    public static final int NULL_SESSION_ID = -1;
    public static final String AERON_DIR_PROP_NAME = "aeron.dir";
    public static final String AERON_DIR_PROP_DEFAULT;
    public static final String IPC_MEDIA = "ipc";
    public static final String UDP_MEDIA = "udp";
    public static final String IPC_CHANNEL = "aeron:ipc";
    public static final String UDP_CHANNEL = "aeron:udp";
    public static final String SPY_PREFIX = "aeron-spy:";
    public static final String ENDPOINT_PARAM_NAME = "endpoint";
    public static final String INTERFACE_PARAM_NAME = "interface";
    public static final String INITIAL_TERM_ID_PARAM_NAME = "init-term-id";
    public static final String TERM_ID_PARAM_NAME = "term-id";
    public static final String TERM_OFFSET_PARAM_NAME = "term-offset";
    public static final String TERM_LENGTH_PARAM_NAME = "term-length";
    public static final String MTU_LENGTH_PARAM_NAME = "mtu";
    public static final String TTL_PARAM_NAME = "ttl";
    public static final String MDC_CONTROL_PARAM_NAME = "control";
    public static final String MDC_CONTROL_MODE_PARAM_NAME = "control-mode";
    public static final String MDC_CONTROL_MODE_MANUAL = "manual";
    public static final String MDC_CONTROL_MODE_DYNAMIC = "dynamic";
    public static final String SESSION_ID_PARAM_NAME = "session-id";
    public static final String LINGER_PARAM_NAME = "linger";
    public static final String RELIABLE_STREAM_PARAM_NAME = "reliable";
    public static final String TAGS_PARAM_NAME = "tags";
    public static final String TAG_PREFIX = "tag:";
    public static final String SPARSE_PARAM_NAME = "sparse";
    public static final String ALIAS_PARAM_NAME = "alias";
    public static final String EOS_PARAM_NAME = "eos";
    public static final String TETHER_PARAM_NAME = "tether";
    public static final String GROUP_PARAM_NAME = "group";
    public static final String REJOIN_PARAM_NAME = "rejoin";
    public static final String CONGESTION_CONTROL_PARAM_NAME = "cc";
    public static final String FLOW_CONTROL_PARAM_NAME = "fc";
    public static final String GROUP_TAG_PARAM_NAME = "gtag";
    public static final String SPIES_SIMULATE_CONNECTION_PARAM_NAME = "ssc";
    public static final String SOCKET_SNDBUF_PARAM_NAME = "so-sndbuf";
    public static final String SOCKET_RCVBUF_PARAM_NAME = "so-rcvbuf";
    public static final String RECEIVER_WINDOW_LENGTH_PARAM_NAME = "rcv-wnd";
    public static final String MEDIA_RCV_TIMESTAMP_OFFSET_PARAM_NAME = "media-rcv-ts-offset";
    public static final String CHANNEL_RECEIVE_TIMESTAMP_OFFSET_PARAM_NAME = "channel-rcv-ts-offset";
    public static final String CHANNEL_SEND_TIMESTAMP_OFFSET_PARAM_NAME = "channel-snd-ts-offset";
    public static final String RESERVED_OFFSET = "reserved";
    public static final String FALLBACK_LOGGER_PROP_NAME = "aeron.fallback.logger";
    private static final PrintStream NO_OP_LOGGER;
    private static final AtomicIntegerFieldUpdater<CommonContext> IS_CONCLUDED_UPDATER;
    private static final Map<String, Boolean> DEBUG_FIELDS_SEEN;
    private volatile int isConcluded;
    private long driverTimeoutMs = DRIVER_TIMEOUT_MS;
    private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
    private File aeronDirectory;
    private File cncFile;
    private UnsafeBuffer countersMetaDataBuffer;
    private UnsafeBuffer countersValuesBuffer;

    public static PrintStream fallbackLogger() {
        String string;
        switch (string = System.getProperty(FALLBACK_LOGGER_PROP_NAME, "stderr")) {
            case "stdout": {
                return System.out;
            }
            case "no_op": {
                return NO_OP_LOGGER;
            }
        }
        return System.err;
    }

    public CommonContext clone() {
        try {
            return (CommonContext)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public static String getAeronDirectoryName() {
        return System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT);
    }

    public static String generateRandomDirName() {
        return AERON_DIR_PROP_DEFAULT + "-" + UUID.randomUUID();
    }

    public CommonContext conclude() {
        if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
            throw new ConcurrentConcludeException();
        }
        this.concludeAeronDirectory();
        this.cncFile = new File(this.aeronDirectory, "cnc.dat");
        return this;
    }

    public boolean isConcluded() {
        return 1 == this.isConcluded;
    }

    public CommonContext concludeAeronDirectory() {
        if (null == this.aeronDirectory) {
            this.aeronDirectory = new File(this.aeronDirectoryName);
        }
        return this;
    }

    public String aeronDirectoryName() {
        return this.aeronDirectoryName;
    }

    public File aeronDirectory() {
        return this.aeronDirectory;
    }

    public CommonContext aeronDirectoryName(String string) {
        this.aeronDirectoryName = string;
        return this;
    }

    public static File newDefaultCncFile() {
        return new File(System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT), "cnc.dat");
    }

    public static File newCncFile(String string) {
        return new File(string, "cnc.dat");
    }

    public UnsafeBuffer countersMetaDataBuffer() {
        return this.countersMetaDataBuffer;
    }

    public CommonContext countersMetaDataBuffer(UnsafeBuffer unsafeBuffer) {
        this.countersMetaDataBuffer = unsafeBuffer;
        return this;
    }

    public UnsafeBuffer countersValuesBuffer() {
        return this.countersValuesBuffer;
    }

    public CommonContext countersValuesBuffer(UnsafeBuffer unsafeBuffer) {
        this.countersValuesBuffer = unsafeBuffer;
        return this;
    }

    public File cncFile() {
        return this.cncFile;
    }

    public CommonContext driverTimeoutMs(long l2) {
        this.driverTimeoutMs = l2;
        return this;
    }

    public long driverTimeoutMs() {
        return CommonContext.checkDebugTimeout(this.driverTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public static long checkDebugTimeout(long l2, TimeUnit timeUnit) {
        String string = System.getProperty(DEBUG_TIMEOUT_PROP_NAME);
        if (null == string || !SystemUtil.isDebuggerAttached()) {
            return l2;
        }
        try {
            long l3 = SystemUtil.parseDuration(DEBUG_TIMEOUT_PROP_NAME, string);
            long l4 = timeUnit.convert(l3, TimeUnit.NANOSECONDS);
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            String string2 = stackTraceElementArray[2].getMethodName();
            String string3 = stackTraceElementArray[2].getClassName();
            String string4 = string3 + "." + string2;
            if (null == DEBUG_FIELDS_SEEN.putIfAbsent(string4, true)) {
                String string5 = "Using debug timeout [" + l4 + "] for " + string4 + " replacing [" + l2 + "]";
                System.out.println(string5);
            }
            return l4;
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public void deleteAeronDirectory() {
        IoUtil.delete(this.aeronDirectory, false);
    }

    public MappedByteBuffer mapExistingCncFile(Consumer<String> consumer) {
        File file = new File(this.aeronDirectory, "cnc.dat");
        if (file.exists() && file.length() > (long)CncFileDescriptor.END_OF_METADATA_OFFSET) {
            if (null != consumer) {
                consumer.accept("INFO: Aeron CnC file exists: " + file);
            }
            return IoUtil.mapExistingFile(file, "cnc.dat");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDriverActive(File file, long l2, Consumer<String> consumer) {
        File file2 = new File(file, "cnc.dat");
        if (file2.exists() && file2.length() > (long)CncFileDescriptor.END_OF_METADATA_OFFSET) {
            consumer.accept("INFO: Aeron CnC file exists: " + file2);
            MappedByteBuffer mappedByteBuffer = IoUtil.mapExistingFile(file2, "CnC file");
            try {
                boolean bl2 = CommonContext.isDriverActive(l2, consumer, mappedByteBuffer);
                return bl2;
            }
            finally {
                BufferUtil.free(mappedByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDriverActive(long l2, Consumer<String> consumer) {
        MappedByteBuffer mappedByteBuffer = this.mapExistingCncFile(consumer);
        try {
            boolean bl2 = CommonContext.isDriverActive(l2, consumer, mappedByteBuffer);
            return bl2;
        }
        finally {
            BufferUtil.free(mappedByteBuffer);
        }
    }

    public static boolean isDriverActive(long l2, Consumer<String> consumer, ByteBuffer byteBuffer) {
        int n2;
        if (null == byteBuffer) {
            return false;
        }
        UnsafeBuffer unsafeBuffer = CncFileDescriptor.createMetaDataBuffer(byteBuffer);
        long l3 = System.currentTimeMillis();
        while (0 == (n2 = unsafeBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
            if (System.currentTimeMillis() > l3 + l2) {
                throw new DriverTimeoutException("CnC file is created but not initialised.");
            }
            CommonContext.sleep(1L);
        }
        CncFileDescriptor.checkVersion(n2);
        ManyToOneRingBuffer manyToOneRingBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(byteBuffer, unsafeBuffer));
        long l4 = manyToOneRingBuffer.consumerHeartbeatTime();
        long l5 = System.currentTimeMillis();
        long l6 = l5 - l4;
        consumer.accept("INFO: Aeron toDriver consumer heartbeat is (ms): " + l6);
        return l6 <= l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requestDriverTermination(File file, DirectBuffer directBuffer, int n2, int n3) {
        File file2 = new File(file, "cnc.dat");
        if (file2.exists() && file2.length() > (long)CncFileDescriptor.END_OF_METADATA_OFFSET) {
            MappedByteBuffer mappedByteBuffer = IoUtil.mapExistingFile(file2, "CnC file");
            try {
                UnsafeBuffer unsafeBuffer = CncFileDescriptor.createMetaDataBuffer(mappedByteBuffer);
                int n4 = unsafeBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0));
                if (n4 > 0) {
                    CncFileDescriptor.checkVersion(n4);
                    ManyToOneRingBuffer manyToOneRingBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(mappedByteBuffer, unsafeBuffer));
                    long l2 = manyToOneRingBuffer.nextCorrelationId();
                    DriverProxy driverProxy = new DriverProxy(manyToOneRingBuffer, l2);
                    boolean bl2 = driverProxy.terminateDriver(directBuffer, n2, n3);
                    return bl2;
                }
            }
            finally {
                BufferUtil.free(mappedByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveErrorLog(PrintStream printStream) {
        MappedByteBuffer mappedByteBuffer = this.mapExistingCncFile(null);
        try {
            int n2 = this.saveErrorLog(printStream, mappedByteBuffer);
            return n2;
        }
        finally {
            BufferUtil.free(mappedByteBuffer);
        }
    }

    public int saveErrorLog(PrintStream printStream, ByteBuffer byteBuffer) {
        if (null == byteBuffer) {
            return 0;
        }
        return CommonContext.printErrorLog(CommonContext.errorLogBuffer(byteBuffer), printStream);
    }

    public void close() {
    }

    public static int printErrorLog(AtomicBuffer atomicBuffer, PrintStream printStream) {
        int n3 = 0;
        if (ErrorLogReader.hasErrors(atomicBuffer)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            ErrorConsumer errorConsumer = (n2, l2, l3, string) -> {
                String string2 = simpleDateFormat.format(new Date(l2));
                String string3 = simpleDateFormat.format(new Date(l3));
                printStream.println();
                printStream.println(n2 + " observations from " + string2 + " to " + string3 + " for:");
                printStream.println(string);
            };
            n3 = ErrorLogReader.read(atomicBuffer, errorConsumer);
            printStream.println();
            printStream.println(n3 + " distinct errors observed.");
        } else {
            printStream.println();
            printStream.println("O distinct errors observed");
        }
        return n3;
    }

    public static void saveExistingErrors(File file, AtomicBuffer atomicBuffer, PrintStream printStream, String string) {
        block15: {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = CommonContext.printErrorLog(atomicBuffer, new PrintStream((OutputStream)byteArrayOutputStream, false, "US-ASCII"));
                if (n2 <= 0) break block15;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSSZ");
                File file2 = new File(file.getParentFile(), string + '-' + simpleDateFormat.format(new Date()) + "-error.log");
                if (null != printStream) {
                    printStream.println("WARNING: existing errors saved to: " + file2);
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    byteArrayOutputStream.writeTo(fileOutputStream);
                }
            }
            catch (Exception exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        }
    }

    public static AtomicBuffer errorLogBuffer(ByteBuffer byteBuffer) {
        UnsafeBuffer unsafeBuffer = CncFileDescriptor.createMetaDataBuffer(byteBuffer);
        int n2 = unsafeBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        CncFileDescriptor.checkVersion(n2);
        return CncFileDescriptor.createErrorLogBuffer(byteBuffer, unsafeBuffer);
    }

    public static ErrorHandler setupErrorHandler(ErrorHandler errorHandler, DistinctErrorLog distinctErrorLog) {
        LoggingErrorHandler loggingErrorHandler = new LoggingErrorHandler(distinctErrorLog, CommonContext.fallbackLogger());
        if (null == errorHandler) {
            return loggingErrorHandler;
        }
        return throwable -> {
            loggingErrorHandler.onError(throwable);
            errorHandler.onError(throwable);
        };
    }

    static void sleep(long l2) {
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new AeronException("unexpected interrupt", interruptedException);
        }
    }

    static {
        File file;
        DRIVER_TIMEOUT_MS = Long.getLong(DRIVER_TIMEOUT_PROP_NAME, 10000L);
        NO_OP_LOGGER = new PrintStream(new OutputStream(){

            @Override
            public void write(int n2) {
            }
        });
        IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CommonContext.class, "isConcluded");
        DEBUG_FIELDS_SEEN = new ConcurrentHashMap<String, Boolean>();
        String string = null;
        if (SystemUtil.isLinux() && (file = new File("/dev/shm")).exists()) {
            string = "/dev/shm/aeron";
        }
        if (null == string) {
            string = SystemUtil.tmpDirName() + "aeron";
        }
        AERON_DIR_PROP_DEFAULT = string + '-' + System.getProperty("user.name", "default");
    }

    public static enum InferableBoolean {
        FORCE_FALSE,
        FORCE_TRUE,
        INFER;


        public static InferableBoolean parse(String string) {
            if (null == string || "infer".equals(string)) {
                return INFER;
            }
            return "true".equals(string) ? FORCE_TRUE : FORCE_FALSE;
        }
    }
}

