/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableCounterHandler;
import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.ConcurrentPublication;
import io.aeron.Counter;
import io.aeron.DriverProxy;
import io.aeron.ExclusivePublication;
import io.aeron.LogBuffersFactory;
import io.aeron.MappedLogBuffersFactory;
import io.aeron.Subscription;
import io.aeron.UnavailableCounterHandler;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.CountersReader;

public class Aeron
implements AutoCloseable {
    public static final int NULL_VALUE = -1;
    private static final AtomicIntegerFieldUpdater<Aeron> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Aeron.class, "isClosed");
    private volatile int isClosed;
    private final long clientId;
    private final ClientConductor conductor;
    private final RingBuffer commandBuffer;
    private final AgentInvoker conductorInvoker;
    private final AgentRunner conductorRunner;
    private final Context ctx;

    Aeron(Context context) {
        try {
            context.conclude();
            this.ctx = context;
            this.clientId = context.clientId();
            this.commandBuffer = context.toDriverBuffer();
            this.conductor = new ClientConductor(context, this);
            if (context.useConductorAgentInvoker()) {
                this.conductorInvoker = new AgentInvoker(context.errorHandler(), null, this.conductor);
                this.conductorRunner = null;
            } else {
                this.conductorInvoker = null;
                this.conductorRunner = new AgentRunner(context.idleStrategy(), context.errorHandler(), null, this.conductor);
            }
        }
        catch (ConcurrentConcludeException concurrentConcludeException) {
            throw concurrentConcludeException;
        }
        catch (Exception exception) {
            CloseHelper.quietClose(context::close);
            throw exception;
        }
    }

    public static Aeron connect() {
        return Aeron.connect(new Context());
    }

    public static Aeron connect(Context context) {
        try {
            Aeron aeron = new Aeron(context);
            if (context.useConductorAgentInvoker()) {
                aeron.conductorInvoker.start();
            } else {
                AgentRunner.startOnThread(aeron.conductorRunner, context.threadFactory());
            }
            return aeron;
        }
        catch (ConcurrentConcludeException concurrentConcludeException) {
            throw concurrentConcludeException;
        }
        catch (Exception exception) {
            context.close();
            throw exception;
        }
    }

    public void printCounters(PrintStream printStream) {
        CountersReader countersReader = this.countersReader();
        countersReader.forEach((l2, n2, string) -> printStream.format("%3d: %,20d - %s%n", n2, l2, string));
    }

    public boolean isClosed() {
        return 1 == this.isClosed;
    }

    public Context context() {
        return this.ctx;
    }

    public long clientId() {
        return this.clientId;
    }

    public AgentInvoker conductorAgentInvoker() {
        return this.conductorInvoker;
    }

    public boolean isCommandActive(long l2) {
        return this.conductor.isCommandActive(l2);
    }

    public boolean hasActiveCommands() {
        return this.conductor.hasActiveCommands();
    }

    @Override
    public void close() {
        if (IS_CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            ErrorHandler errorHandler = this.ctx.errorHandler();
            if (null != this.conductorRunner) {
                CloseHelper.close(errorHandler, this.conductorRunner);
            } else {
                CloseHelper.close(errorHandler, this.conductorInvoker);
            }
        }
    }

    public ConcurrentPublication addPublication(String string, int n2) {
        return this.conductor.addPublication(string, n2);
    }

    public ExclusivePublication addExclusivePublication(String string, int n2) {
        return this.conductor.addExclusivePublication(string, n2);
    }

    public long asyncAddPublication(String string, int n2) {
        return this.conductor.asyncAddPublication(string, n2);
    }

    public long asyncAddExclusivePublication(String string, int n2) {
        return this.conductor.asyncAddExclusivePublication(string, n2);
    }

    public void asyncRemovePublication(long l2) {
        this.conductor.removePublication(l2);
    }

    public ConcurrentPublication getPublication(long l2) {
        return this.conductor.getPublication(l2);
    }

    public ExclusivePublication getExclusivePublication(long l2) {
        return this.conductor.getExclusivePublication(l2);
    }

    public Subscription addSubscription(String string, int n2) {
        return this.conductor.addSubscription(string, n2);
    }

    public Subscription addSubscription(String string, int n2, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        return this.conductor.addSubscription(string, n2, availableImageHandler, unavailableImageHandler);
    }

    public long asyncAddSubscription(String string, int n2, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        return this.conductor.asyncAddSubscription(string, n2, availableImageHandler, unavailableImageHandler);
    }

    public long asyncAddSubscription(String string, int n2) {
        return this.conductor.asyncAddSubscription(string, n2);
    }

    public Subscription getSubscription(long l2) {
        return this.conductor.getSubscription(l2);
    }

    public long nextCorrelationId() {
        if (1 == this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.commandBuffer.nextCorrelationId();
    }

    public CountersReader countersReader() {
        if (1 == this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.conductor.countersReader();
    }

    public Counter addCounter(int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6) {
        return this.conductor.addCounter(n2, directBuffer, n3, n4, directBuffer2, n5, n6);
    }

    public Counter addCounter(int n2, String string) {
        return this.conductor.addCounter(n2, string);
    }

    public long addAvailableCounterHandler(AvailableCounterHandler availableCounterHandler) {
        return this.conductor.addAvailableCounterHandler(availableCounterHandler);
    }

    public boolean removeAvailableCounterHandler(long l2) {
        return this.conductor.removeAvailableCounterHandler(l2);
    }

    @Deprecated
    public boolean removeAvailableCounterHandler(AvailableCounterHandler availableCounterHandler) {
        return this.conductor.removeAvailableCounterHandler(availableCounterHandler);
    }

    public long addUnavailableCounterHandler(UnavailableCounterHandler unavailableCounterHandler) {
        return this.conductor.addUnavailableCounterHandler(unavailableCounterHandler);
    }

    public boolean removeUnavailableCounterHandler(long l2) {
        return this.conductor.removeUnavailableCounterHandler(l2);
    }

    @Deprecated
    public boolean removeUnavailableCounterHandler(UnavailableCounterHandler unavailableCounterHandler) {
        return this.conductor.removeUnavailableCounterHandler(unavailableCounterHandler);
    }

    public long addCloseHandler(Runnable runnable) {
        return this.conductor.addCloseHandler(runnable);
    }

    public boolean removeCloseHandler(long l2) {
        return this.conductor.removeCloseHandler(l2);
    }

    @Deprecated
    public boolean removeCloseHandler(Runnable runnable) {
        return this.conductor.removeCloseHandler(runnable);
    }

    public String toString() {
        return "Aeron{isClosed=" + this.isClosed + ", clientId=" + this.clientId + '}';
    }

    void internalClose() {
        this.isClosed = 1;
    }

    public static class Context
    extends CommonContext {
        private long clientId;
        private boolean useConductorAgentInvoker = false;
        private boolean preTouchMappedMemory = Configuration.preTouchMappedMemory();
        private AgentInvoker driverAgentInvoker;
        private Lock clientLock;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private IdleStrategy idleStrategy;
        private IdleStrategy awaitingIdleStrategy;
        private CopyBroadcastReceiver toClientBuffer;
        private RingBuffer toDriverBuffer;
        private DriverProxy driverProxy;
        private MappedByteBuffer cncByteBuffer;
        private AtomicBuffer cncMetaDataBuffer;
        private LogBuffersFactory logBuffersFactory;
        private ErrorHandler errorHandler;
        private ErrorHandler subscriberErrorHandler;
        private AvailableImageHandler availableImageHandler;
        private UnavailableImageHandler unavailableImageHandler;
        private AvailableCounterHandler availableCounterHandler;
        private UnavailableCounterHandler unavailableCounterHandler;
        private Runnable closeHandler;
        private long keepAliveIntervalNs = Configuration.KEEPALIVE_INTERVAL_NS;
        private long interServiceTimeoutNs = 0L;
        private long resourceLingerDurationNs = Configuration.resourceLingerDurationNs();
        private long closeLingerDurationNs = Configuration.closeLingerDurationNs();
        private ThreadFactory threadFactory = Thread::new;

        @Override
        public Context clone() {
            return (Context)super.clone();
        }

        @Override
        public Context conclude() {
            super.conclude();
            if (null == this.clientLock) {
                this.clientLock = new ReentrantLock();
            } else if (this.clientLock instanceof NoOpLock && !this.useConductorAgentInvoker) {
                throw new AeronException("Must use Aeron.Context.useConductorAgentInvoker(true) when Aeron.Context.clientLock(...) is using a NoOpLock");
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new SleepingMillisIdleStrategy(16L);
            }
            if (null == this.awaitingIdleStrategy) {
                this.awaitingIdleStrategy = new SleepingMillisIdleStrategy(1L);
            }
            if (this.cncFile() != null) {
                this.connectToDriver();
            }
            this.interServiceTimeoutNs = CncFileDescriptor.clientLivenessTimeoutNs(this.cncMetaDataBuffer);
            if (this.interServiceTimeoutNs <= this.keepAliveIntervalNs) {
                throw new ConfigurationException("interServiceTimeoutNs=" + this.interServiceTimeoutNs + " <= keepAliveIntervalNs=" + this.keepAliveIntervalNs);
            }
            if (null == this.toDriverBuffer) {
                this.toDriverBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (null == this.toClientBuffer) {
                this.toClientBuffer = new CopyBroadcastReceiver(new BroadcastReceiver(CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, this.cncMetaDataBuffer)));
            }
            if (this.countersMetaDataBuffer() == null) {
                this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (this.countersValuesBuffer() == null) {
                this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (null == this.logBuffersFactory) {
                this.logBuffersFactory = new MappedLogBuffersFactory();
            }
            if (null == this.errorHandler) {
                this.errorHandler = Configuration.DEFAULT_ERROR_HANDLER;
            }
            if (null == this.subscriberErrorHandler) {
                this.subscriberErrorHandler = this.errorHandler;
            }
            if (null == this.driverProxy) {
                this.clientId = this.toDriverBuffer.nextCorrelationId();
                this.driverProxy = new DriverProxy(this.toDriverBuffer, this.clientId);
            }
            return this;
        }

        public long clientId() {
            return this.clientId;
        }

        public Context useConductorAgentInvoker(boolean bl2) {
            this.useConductorAgentInvoker = bl2;
            return this;
        }

        public boolean useConductorAgentInvoker() {
            return this.useConductorAgentInvoker;
        }

        public Context preTouchMappedMemory(boolean bl2) {
            this.preTouchMappedMemory = bl2;
            return this;
        }

        public boolean preTouchMappedMemory() {
            return this.preTouchMappedMemory;
        }

        public Context driverAgentInvoker(AgentInvoker agentInvoker) {
            this.driverAgentInvoker = agentInvoker;
            return this;
        }

        public AgentInvoker driverAgentInvoker() {
            return this.driverAgentInvoker;
        }

        public Context clientLock(Lock lock) {
            this.clientLock = lock;
            return this;
        }

        public Lock clientLock() {
            return this.clientLock;
        }

        public Context epochClock(EpochClock epochClock) {
            this.epochClock = epochClock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context nanoClock(NanoClock nanoClock) {
            this.nanoClock = nanoClock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context awaitingIdleStrategy(IdleStrategy idleStrategy) {
            this.awaitingIdleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy awaitingIdleStrategy() {
            return this.awaitingIdleStrategy;
        }

        Context toClientBuffer(CopyBroadcastReceiver copyBroadcastReceiver) {
            this.toClientBuffer = copyBroadcastReceiver;
            return this;
        }

        public CopyBroadcastReceiver toClientBuffer() {
            return this.toClientBuffer;
        }

        public RingBuffer toDriverBuffer() {
            return this.toDriverBuffer;
        }

        Context driverProxy(DriverProxy driverProxy) {
            this.driverProxy = driverProxy;
            return this;
        }

        public DriverProxy driverProxy() {
            return this.driverProxy;
        }

        Context logBuffersFactory(LogBuffersFactory logBuffersFactory) {
            this.logBuffersFactory = logBuffersFactory;
            return this;
        }

        public LogBuffersFactory logBuffersFactory() {
            return this.logBuffersFactory;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context subscriberErrorHandler(ErrorHandler errorHandler) {
            this.subscriberErrorHandler = errorHandler;
            return this;
        }

        public ErrorHandler subscriberErrorHandler() {
            return this.subscriberErrorHandler;
        }

        public Context availableImageHandler(AvailableImageHandler availableImageHandler) {
            this.availableImageHandler = availableImageHandler;
            return this;
        }

        public AvailableImageHandler availableImageHandler() {
            return this.availableImageHandler;
        }

        public Context unavailableImageHandler(UnavailableImageHandler unavailableImageHandler) {
            this.unavailableImageHandler = unavailableImageHandler;
            return this;
        }

        public UnavailableImageHandler unavailableImageHandler() {
            return this.unavailableImageHandler;
        }

        public Context availableCounterHandler(AvailableCounterHandler availableCounterHandler) {
            this.availableCounterHandler = availableCounterHandler;
            return this;
        }

        public AvailableCounterHandler availableCounterHandler() {
            return this.availableCounterHandler;
        }

        public Context unavailableCounterHandler(UnavailableCounterHandler unavailableCounterHandler) {
            this.unavailableCounterHandler = unavailableCounterHandler;
            return this;
        }

        public UnavailableCounterHandler unavailableCounterHandler() {
            return this.unavailableCounterHandler;
        }

        public Context closeHandler(Runnable runnable) {
            this.closeHandler = runnable;
            return this;
        }

        public Runnable closeHandler() {
            return this.closeHandler;
        }

        public Context keepAliveIntervalNs(long l2) {
            this.keepAliveIntervalNs = l2;
            return this;
        }

        public long keepAliveIntervalNs() {
            return this.keepAliveIntervalNs;
        }

        @Override
        public Context driverTimeoutMs(long l2) {
            super.driverTimeoutMs(l2);
            return this;
        }

        Context interServiceTimeoutNs(long l2) {
            this.interServiceTimeoutNs = l2;
            return this;
        }

        public long interServiceTimeoutNs() {
            return CommonContext.checkDebugTimeout(this.interServiceTimeoutNs, TimeUnit.NANOSECONDS);
        }

        public Context resourceLingerDurationNs(long l2) {
            this.resourceLingerDurationNs = l2;
            return this;
        }

        public long resourceLingerDurationNs() {
            return this.resourceLingerDurationNs;
        }

        public Context closeLingerDurationNs(long l2) {
            this.closeLingerDurationNs = l2;
            return this;
        }

        public long closeLingerDurationNs() {
            return this.closeLingerDurationNs;
        }

        @Override
        public Context aeronDirectoryName(String string) {
            super.aeronDirectoryName(string);
            return this;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        @Override
        public void close() {
            BufferUtil.free(this.cncByteBuffer);
            this.cncByteBuffer = null;
            super.close();
        }

        public String toString() {
            return "Aeron.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    aeronDirectory=" + this.aeronDirectory() + "\n    aeronDirectoryName='" + this.aeronDirectoryName() + '\'' + "\n    cncFile=" + this.cncFile() + "\n    countersMetaDataBuffer=" + this.countersMetaDataBuffer() + "\n    countersValuesBuffer=" + this.countersValuesBuffer() + "\n    driverTimeoutMs=" + this.driverTimeoutMs() + "\n    clientId=" + this.clientId + "\n    useConductorAgentInvoker=" + this.useConductorAgentInvoker + "\n    preTouchMappedMemory=" + this.preTouchMappedMemory + "\n    driverAgentInvoker=" + this.driverAgentInvoker + "\n    clientLock=" + this.clientLock + "\n    epochClock=" + this.epochClock + "\n    nanoClock=" + this.nanoClock + "\n    idleStrategy=" + this.idleStrategy + "\n    awaitingIdleStrategy=" + this.awaitingIdleStrategy + "\n    toClientBuffer=" + this.toClientBuffer + "\n    toDriverBuffer=" + this.toDriverBuffer + "\n    driverProxy=" + this.driverProxy + "\n    cncByteBuffer=" + this.cncByteBuffer + "\n    cncMetaDataBuffer=" + this.cncMetaDataBuffer + "\n    logBuffersFactory=" + this.logBuffersFactory + "\n    errorHandler=" + this.errorHandler + "\n    subscriberErrorHandler=" + this.subscriberErrorHandler + "\n    availableImageHandler=" + this.availableImageHandler + "\n    unavailableImageHandler=" + this.unavailableImageHandler + "\n    availableCounterHandler=" + this.availableCounterHandler + "\n    unavailableCounterHandler=" + this.unavailableCounterHandler + "\n    closeHandler=" + this.closeHandler + "\n    keepAliveIntervalNs=" + this.keepAliveIntervalNs + "\n    interServiceTimeoutNs=" + this.interServiceTimeoutNs + "\n    resourceLingerDurationNs=" + this.resourceLingerDurationNs + "\n    closeLingerDurationNs=" + this.closeLingerDurationNs + "\n    threadFactory=" + this.threadFactory + "\n}";
        }

        private void connectToDriver() {
            EpochClock epochClock = this.epochClock;
            long l2 = epochClock.time() + this.driverTimeoutMs();
            File file = this.cncFile();
            while (null == this.toDriverBuffer) {
                int n2;
                this.cncByteBuffer = Context.waitForFileMapping(file, epochClock, l2);
                this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(this.cncByteBuffer);
                while (0 == (n2 = this.cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
                    if (epochClock.time() > l2) {
                        throw new DriverTimeoutException("CnC file is created but not initialised: " + file.getAbsolutePath());
                    }
                    Context.sleep(1L);
                }
                CncFileDescriptor.checkVersion(n2);
                if (SemanticVersion.minor(n2) < SemanticVersion.minor(CncFileDescriptor.CNC_VERSION)) {
                    throw new AeronException("driverVersion=" + SemanticVersion.toString(n2) + " insufficient for clientVersion=" + SemanticVersion.toString(CncFileDescriptor.CNC_VERSION));
                }
                if (!CncFileDescriptor.isCncFileLengthSufficient(this.cncMetaDataBuffer, this.cncByteBuffer.capacity())) {
                    BufferUtil.free(this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Context.sleep(1L);
                    continue;
                }
                ManyToOneRingBuffer manyToOneRingBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
                while (0L == manyToOneRingBuffer.consumerHeartbeatTime()) {
                    if (epochClock.time() > l2) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    Context.sleep(1L);
                }
                long l3 = epochClock.time();
                if (manyToOneRingBuffer.consumerHeartbeatTime() < l3 - this.driverTimeoutMs()) {
                    if (l3 > l2) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    BufferUtil.free(this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Context.sleep(100L);
                    continue;
                }
                this.toDriverBuffer = manyToOneRingBuffer;
            }
        }

        /*
         * Loose catch block
         */
        private static MappedByteBuffer waitForFileMapping(File file, EpochClock epochClock, long l2) {
            while (true) {
                MappedByteBuffer mappedByteBuffer;
                Throwable throwable;
                FileChannel fileChannel;
                block24: {
                    block25: {
                        long l3;
                        block22: {
                            block23: {
                                if (!file.exists() || file.length() < (long)CncFileDescriptor.META_DATA_LENGTH) {
                                    if (epochClock.time() > l2) {
                                        throw new DriverTimeoutException("CnC file not created: " + file.getAbsolutePath());
                                    }
                                    Context.sleep(16L);
                                    continue;
                                }
                                fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                                throwable = null;
                                l3 = fileChannel.size();
                                if (l3 >= (long)CncFileDescriptor.META_DATA_LENGTH) break block22;
                                if (epochClock.time() > l2) {
                                    throw new DriverTimeoutException("CnC file is created but not populated: " + file.getAbsolutePath());
                                }
                                fileChannel.close();
                                Context.sleep(16L);
                                if (fileChannel == null) continue;
                                if (throwable == null) break block23;
                                try {
                                    fileChannel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                continue;
                            }
                            fileChannel.close();
                            continue;
                        }
                        mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l3);
                        if (fileChannel == null) break block24;
                        if (throwable == null) break block25;
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block24;
                    }
                    fileChannel.close();
                }
                return mappedByteBuffer;
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (fileChannel != null) {
                                if (throwable != null) {
                                    try {
                                        fileChannel.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    fileChannel.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new AeronException("cannot open CnC file: " + file.getAbsolutePath(), iOException);
                    }
                }
                break;
            }
        }
    }

    public static class Configuration {
        static final long IDLE_SLEEP_MS = 16L;
        static final long AWAITING_IDLE_SLEEP_MS = 1L;
        static final long IDLE_SLEEP_NS = TimeUnit.MILLISECONDS.toNanos(16L);
        static final long KEEPALIVE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        public static final String RESOURCE_LINGER_DURATION_PROP_NAME = "aeron.client.resource.linger.duration";
        public static final long RESOURCE_LINGER_DURATION_DEFAULT_NS = TimeUnit.SECONDS.toNanos(3L);
        public static final String CLOSE_LINGER_DURATION_PROP_NAME = "aeron.client.close.linger.duration";
        public static final long CLOSE_LINGER_DURATION_DEFAULT_NS = 0L;
        public static final String PRE_TOUCH_MAPPED_MEMORY_PROP_NAME = "aeron.pre.touch.mapped.memory";
        public static final boolean PRE_TOUCH_MAPPED_MEMORY_DEFAULT = false;
        public static final ErrorHandler DEFAULT_ERROR_HANDLER = throwable -> {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(System.currentTimeMillis() + " Exception:");
                throwable.printStackTrace(System.err);
            }
            if (throwable instanceof DriverTimeoutException) {
                System.err.printf("%n***%n*** timeout for the Media Driver - is it currently running? exiting%n***%n", new Object[0]);
                System.exit(-1);
            }
        };

        public static long resourceLingerDurationNs() {
            return SystemUtil.getDurationInNanos(RESOURCE_LINGER_DURATION_PROP_NAME, RESOURCE_LINGER_DURATION_DEFAULT_NS);
        }

        public static long closeLingerDurationNs() {
            return SystemUtil.getDurationInNanos(CLOSE_LINGER_DURATION_PROP_NAME, 0L);
        }

        public static boolean preTouchMappedMemory() {
            String string = System.getProperty(PRE_TOUCH_MAPPED_MEMORY_PROP_NAME);
            if (null != string) {
                return Boolean.parseBoolean(string);
            }
            return false;
        }
    }
}

