/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.tools.rectangle.CoordinatePosition;
import impl.org.controlsfx.tools.rectangle.CoordinatePositions;
import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import impl.org.controlsfx.tools.rectangle.change.MoveChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.NewChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.Rectangle2DChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToEastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNortheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSoutheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToWestChangeStrategy;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.controlsfx.control.SnapshotView;

public class SnapshotViewSkin
extends SkinBase<SnapshotView> {
    private static final double RELATIVE_EDGE_TOLERANCE = 0.015;
    private Node node;
    private final GridPane gridPane = SnapshotViewSkin.createGridPane();
    private final Rectangle selectedArea = new Rectangle();
    private final Rectangle unselectedArea = new Rectangle();
    private final Node mouseNode = this.createMouseNode();
    private SelectionChange selectionChange;
    private final Consumer<Boolean> setSelectionChanging = this.createSetSelectionChanging();

    public SnapshotViewSkin(SnapshotView snapshotView) {
        super((Control)snapshotView);
        this.buildSceneGraph();
        this.initializeAreas();
        this.registerChangeListener((ObservableValue)snapshotView.nodeProperty(), observableValue -> this.updateNode());
        this.registerChangeListener((ObservableValue)snapshotView.selectionProperty(), observableValue -> this.updateSelection());
    }

    private static GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER);
        return gridPane;
    }

    private Node createMouseNode() {
        Rectangle rectangle = new Rectangle();
        rectangle.setFill((Paint)Color.TRANSPARENT);
        rectangle.setManaged(false);
        rectangle.widthProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).widthProperty());
        rectangle.heightProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).heightProperty());
        rectangle.addEventHandler(MouseEvent.ANY, this::handleMouseEvent);
        rectangle.mouseTransparentProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).selectionMouseTransparentProperty());
        return rectangle;
    }

    private Consumer<Boolean> createSetSelectionChanging() {
        return bl2 -> this.getNode().getProperties().put((Object)SnapshotView.SELECTION_CHANGING_PROPERTY_KEY, bl2);
    }

    private void buildSceneGraph() {
        this.getChildren().addAll((Object[])new Node[]{this.gridPane, this.unselectedArea, this.selectedArea, this.mouseNode});
        this.updateNode();
    }

    private void initializeAreas() {
        this.styleAreas();
        this.bindAreaCoordinatesTogether();
        this.bindAreaVisibilityToSelection();
    }

    private void styleAreas() {
        this.selectedArea.fillProperty().bind(((SnapshotView)this.getSkinnable()).selectionAreaFillProperty());
        this.selectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).selectionBorderPaintProperty());
        this.selectedArea.strokeWidthProperty().bind((ObservableValue)((SnapshotView)this.getSkinnable()).selectionBorderWidthProperty());
        this.selectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.selectedArea.setManaged(false);
        this.selectedArea.setMouseTransparent(true);
        this.unselectedArea.setFill((Paint)Color.TRANSPARENT);
        this.unselectedArea.strokeProperty().bind(((SnapshotView)this.getSkinnable()).unselectedAreaFillProperty());
        this.unselectedArea.strokeWidthProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)((SnapshotView)this.getSkinnable()).widthProperty(), (ObservableNumberValue)((SnapshotView)this.getSkinnable()).heightProperty()));
        this.unselectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.unselectedArea.setManaged(false);
        this.unselectedArea.setMouseTransparent(true);
    }

    private void bindAreaCoordinatesTogether() {
        this.unselectedArea.xProperty().bind((ObservableValue)this.selectedArea.xProperty());
        this.unselectedArea.yProperty().bind((ObservableValue)this.selectedArea.yProperty());
        this.unselectedArea.widthProperty().bind((ObservableValue)this.selectedArea.widthProperty());
        this.unselectedArea.heightProperty().bind((ObservableValue)this.selectedArea.heightProperty());
    }

    private void bindAreaVisibilityToSelection() {
        ReadOnlyBooleanProperty readOnlyBooleanProperty = ((SnapshotView)this.getSkinnable()).hasSelectionProperty();
        BooleanProperty booleanProperty = ((SnapshotView)this.getSkinnable()).selectionActiveProperty();
        BooleanBinding booleanBinding = Bindings.and((ObservableBooleanValue)readOnlyBooleanProperty, (ObservableBooleanValue)booleanProperty);
        this.selectedArea.visibleProperty().bind((ObservableValue)booleanBinding);
        this.unselectedArea.visibleProperty().bind((ObservableValue)booleanBinding);
        new Clipper((SnapshotView)this.getSkinnable(), (Node)this.unselectedArea, () -> this.unselectedArea.visibleProperty().bind((ObservableValue)booleanBinding));
    }

    private void updateNode() {
        if (this.node != null) {
            this.gridPane.getChildren().remove((Object)this.node);
        }
        this.node = ((SnapshotView)this.getSkinnable()).getNode();
        if (this.node != null) {
            this.gridPane.getChildren().add(0, (Object)this.node);
        }
    }

    private void updateSelection() {
        boolean bl2;
        boolean bl3 = bl2 = ((SnapshotView)this.getSkinnable()).hasSelection() && ((SnapshotView)this.getSkinnable()).isSelectionActive();
        if (bl2) {
            Rectangle2D rectangle2D = ((SnapshotView)this.getSkinnable()).getSelection();
            this.setSelection(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            this.setSelection(0.0, 0.0, 0.0, 0.0);
        }
    }

    private void setSelection(double d2, double d3, double d4, double d5) {
        this.selectedArea.setX(d2);
        this.selectedArea.setY(d3);
        this.selectedArea.setWidth(d4);
        this.selectedArea.setHeight(d5);
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        Cursor cursor = this.handleMouseEventImpl(mouseEvent);
        this.mouseNode.setCursor(cursor);
    }

    private Cursor handleMouseEventImpl(MouseEvent mouseEvent) {
        Objects.requireNonNull(mouseEvent, "The argument 'mouseEvent' must not be null.");
        EventType eventType = mouseEvent.getEventType();
        SelectionEvent selectionEvent = this.createSelectionEvent(mouseEvent);
        if (eventType == MouseEvent.MOUSE_MOVED) {
            return this.getCursor(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            return this.handleMousePressedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_DRAGGED) {
            return this.handleMouseDraggedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_RELEASED) {
            return this.handleMouseReleasedEvent(selectionEvent);
        }
        return Cursor.DEFAULT;
    }

    private SelectionEvent createSelectionEvent(MouseEvent mouseEvent) {
        Point2D point2D = new Point2D(mouseEvent.getX(), mouseEvent.getY());
        Rectangle2D rectangle2D = this.createBoundsForCurrentBoundary();
        CoordinatePosition coordinatePosition = this.computePosition(point2D);
        return new SelectionEvent(mouseEvent, point2D, rectangle2D, coordinatePosition);
    }

    private Rectangle2D createBoundsForCurrentBoundary() {
        SnapshotView.Boundary boundary = ((SnapshotView)this.getSkinnable()).getSelectionAreaBoundary();
        switch (boundary) {
            case CONTROL: {
                return new Rectangle2D(0.0, 0.0, this.getControlWidth(), this.getControlHeight());
            }
            case NODE: {
                boolean bl2;
                boolean bl3 = bl2 = this.getSnapshotNode() != null;
                if (bl2) {
                    Bounds bounds = this.getSnapshotNode().getBoundsInParent();
                    return Rectangles2D.fromBounds(bounds);
                }
                return Rectangle2D.EMPTY;
            }
        }
        throw new IllegalArgumentException("The boundary " + boundary + " is not fully implemented.");
    }

    private CoordinatePosition computePosition(Point2D point2D) {
        boolean bl2;
        boolean bl3 = !((SnapshotView)this.getSkinnable()).hasSelection() || !((SnapshotView)this.getSkinnable()).isSelectionActive();
        boolean bl4 = bl2 = this.getControlWidth() == 0.0 || this.getControlHeight() == 0.0;
        if (bl3 || bl2) {
            return CoordinatePosition.OUT_OF_RECTANGLE;
        }
        double d2 = this.computeTolerance();
        return SnapshotViewSkin.computePosition(this.getSelection(), point2D, d2);
    }

    private double computeTolerance() {
        double d2 = Math.sqrt(this.getControlWidth() * this.getControlHeight());
        return 0.015 * d2;
    }

    private static CoordinatePosition computePosition(Rectangle2D rectangle2D, Point2D point2D, double d2) {
        CoordinatePosition coordinatePosition = CoordinatePositions.onEdges(rectangle2D, point2D, d2);
        if (coordinatePosition != null) {
            return coordinatePosition;
        }
        return CoordinatePositions.inRectangle(rectangle2D, point2D);
    }

    private Cursor handleMousePressedEvent(SelectionEvent selectionEvent) {
        if (selectionEvent.isPointInSelectionBounds()) {
            Cursor cursor = this.getCursor(selectionEvent);
            Rectangle2DChangeStrategy rectangle2DChangeStrategy = this.getChangeStrategy(selectionEvent);
            boolean bl2 = SnapshotViewSkin.willDeactivateSelectionIfClick(selectionEvent);
            this.selectionChange = new SelectionChangeByStrategy((SnapshotView)this.getSkinnable(), this.setSelectionChanging, rectangle2DChangeStrategy, cursor, bl2);
            this.selectionChange.beginSelectionChange(selectionEvent.getPoint());
        } else {
            this.selectionChange = NoSelectionChange.INSTANCE;
        }
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseDraggedEvent(SelectionEvent selectionEvent) {
        this.selectionChange.continueSelectionChange(selectionEvent.getPoint());
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseReleasedEvent(SelectionEvent selectionEvent) {
        this.selectionChange.endSelectionChange(selectionEvent.getPoint());
        this.selectionChange = null;
        return this.getCursor(selectionEvent);
    }

    private Cursor getCursor(SelectionEvent selectionEvent) {
        if (!selectionEvent.isPointInSelectionBounds()) {
            return this.getRegularCursor();
        }
        switch (selectionEvent.getPosition()) {
            case IN_RECTANGLE: {
                return Cursor.MOVE;
            }
            case OUT_OF_RECTANGLE: {
                return this.getRegularCursor();
            }
            case NORTH_EDGE: {
                return Cursor.N_RESIZE;
            }
            case NORTHEAST_EDGE: {
                return Cursor.NE_RESIZE;
            }
            case EAST_EDGE: {
                return Cursor.E_RESIZE;
            }
            case SOUTHEAST_EDGE: {
                return Cursor.SE_RESIZE;
            }
            case SOUTH_EDGE: {
                return Cursor.S_RESIZE;
            }
            case SOUTHWEST_EDGE: {
                return Cursor.SW_RESIZE;
            }
            case WEST_EDGE: {
                return Cursor.W_RESIZE;
            }
            case NORTHWEST_EDGE: {
                return Cursor.NW_RESIZE;
            }
        }
        throw new IllegalArgumentException("The position " + selectionEvent.getPosition() + " is not fully implemented.");
    }

    private Cursor getRegularCursor() {
        return ((SnapshotView)this.getSkinnable()).getCursor();
    }

    private Rectangle2DChangeStrategy getChangeStrategy(SelectionEvent selectionEvent) {
        boolean bl2;
        boolean bl3 = bl2 = selectionEvent.getMouseEvent().getEventType() == MouseEvent.MOUSE_PRESSED;
        if (!bl2) {
            throw new IllegalArgumentException();
        }
        Rectangle2D rectangle2D = selectionEvent.getSelectionBounds();
        switch (selectionEvent.getPosition()) {
            case IN_RECTANGLE: {
                return new MoveChangeStrategy(this.getSelection(), rectangle2D);
            }
            case OUT_OF_RECTANGLE: {
                return new NewChangeStrategy(this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case NORTH_EDGE: {
                return new ToNorthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case NORTHEAST_EDGE: {
                return new ToNortheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case EAST_EDGE: {
                return new ToEastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case SOUTHEAST_EDGE: {
                return new ToSoutheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case SOUTH_EDGE: {
                return new ToSouthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case SOUTHWEST_EDGE: {
                return new ToSouthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case WEST_EDGE: {
                return new ToWestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
            case NORTHWEST_EDGE: {
                return new ToNorthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), rectangle2D);
            }
        }
        throw new IllegalArgumentException("The position " + selectionEvent.getPosition() + " is not fully implemented.");
    }

    private static boolean willDeactivateSelectionIfClick(SelectionEvent selectionEvent) {
        boolean bl2 = selectionEvent.getMouseEvent().getButton() == MouseButton.SECONDARY;
        boolean bl3 = selectionEvent.getPosition() == CoordinatePosition.OUT_OF_RECTANGLE;
        return bl2 || bl3;
    }

    private double getControlWidth() {
        return ((SnapshotView)this.getSkinnable()).getWidth();
    }

    private double getControlHeight() {
        return ((SnapshotView)this.getSkinnable()).getHeight();
    }

    private Node getSnapshotNode() {
        return ((SnapshotView)this.getSkinnable()).getNode();
    }

    private Rectangle2D getSelection() {
        return ((SnapshotView)this.getSkinnable()).getSelection();
    }

    private boolean isSelectionRatioFixed() {
        return ((SnapshotView)this.getSkinnable()).isSelectionRatioFixed();
    }

    private double getSelectionRatio() {
        return ((SnapshotView)this.getSkinnable()).getFixedSelectionRatio();
    }

    private static class SelectionChangeByStrategy
    implements SelectionChange {
        private final SnapshotView snapshotView;
        private final Consumer<Boolean> setSelectionChanging;
        private final Rectangle2DChangeStrategy selectionChangeStrategy;
        private final Cursor cursor;
        private final boolean deactivateSelectionIfClick;
        private Point2D startingPoint;
        private boolean mouseMoved;

        public SelectionChangeByStrategy(SnapshotView snapshotView, Consumer<Boolean> consumer, Rectangle2DChangeStrategy rectangle2DChangeStrategy, Cursor cursor, boolean bl2) {
            this.snapshotView = snapshotView;
            this.setSelectionChanging = consumer;
            this.selectionChangeStrategy = rectangle2DChangeStrategy;
            this.cursor = cursor;
            this.deactivateSelectionIfClick = bl2;
        }

        @Override
        public void beginSelectionChange(Point2D point2D) {
            this.startingPoint = point2D;
            this.setSelectionChanging.accept(true);
            Rectangle2D rectangle2D = this.selectionChangeStrategy.beginChange(point2D);
            this.snapshotView.setSelection(rectangle2D);
        }

        @Override
        public void continueSelectionChange(Point2D point2D) {
            this.updateMouseMoved(point2D);
            Rectangle2D rectangle2D = this.selectionChangeStrategy.continueChange(point2D);
            this.snapshotView.setSelection(rectangle2D);
        }

        @Override
        public void endSelectionChange(Point2D point2D) {
            boolean bl2;
            this.updateMouseMoved(point2D);
            Rectangle2D rectangle2D = this.selectionChangeStrategy.endChange(point2D);
            this.snapshotView.setSelection(rectangle2D);
            boolean bl3 = bl2 = this.deactivateSelectionIfClick && !this.mouseMoved;
            if (bl2) {
                this.snapshotView.setSelection(null);
            }
            this.setSelectionChanging.accept(false);
        }

        private void updateMouseMoved(Point2D point2D) {
            boolean bl2;
            if (this.mouseMoved) {
                return;
            }
            this.mouseMoved = bl2 = !this.startingPoint.equals((Object)point2D);
        }

        @Override
        public Cursor getCursor() {
            return this.cursor;
        }
    }

    private static class NoSelectionChange
    implements SelectionChange {
        public static final NoSelectionChange INSTANCE = new NoSelectionChange();

        private NoSelectionChange() {
        }

        @Override
        public void beginSelectionChange(Point2D point2D) {
        }

        @Override
        public void continueSelectionChange(Point2D point2D) {
        }

        @Override
        public void endSelectionChange(Point2D point2D) {
        }

        @Override
        public Cursor getCursor() {
            return Cursor.DEFAULT;
        }
    }

    private static interface SelectionChange {
        public void beginSelectionChange(Point2D var1);

        public void continueSelectionChange(Point2D var1);

        public void endSelectionChange(Point2D var1);

        public Cursor getCursor();
    }

    private static class SelectionEvent {
        private final MouseEvent mouseEvent;
        private final Point2D point;
        private final Rectangle2D selectionBounds;
        private final CoordinatePosition position;

        public SelectionEvent(MouseEvent mouseEvent, Point2D point2D, Rectangle2D rectangle2D, CoordinatePosition coordinatePosition) {
            this.mouseEvent = mouseEvent;
            this.point = point2D;
            this.selectionBounds = rectangle2D;
            this.position = coordinatePosition;
        }

        public MouseEvent getMouseEvent() {
            return this.mouseEvent;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public Rectangle2D getSelectionBounds() {
            return this.selectionBounds;
        }

        public boolean isPointInSelectionBounds() {
            return this.selectionBounds.contains(this.point);
        }

        public CoordinatePosition getPosition() {
            return this.position;
        }
    }

    private static class Clipper {
        private final SnapshotView snapshotView;
        private final Node clippedNode;
        private final Runnable rebindClippedNodeVisibility;
        private final Rectangle controlClip;
        private final Rectangle nodeClip;
        private final ChangeListener<Bounds> updateControlClipToNewBoundsListener;
        private final ChangeListener<Bounds> updateNodeClipToNewBoundsListener;

        public Clipper(SnapshotView snapshotView, Node node, Runnable runnable) {
            this.snapshotView = snapshotView;
            this.clippedNode = node;
            this.rebindClippedNodeVisibility = runnable;
            this.controlClip = new Rectangle();
            this.updateControlClipToNewBoundsListener = (observableValue, bounds, bounds2) -> Clipper.resizeRectangleToBounds(this.controlClip, bounds2);
            this.nodeClip = new Rectangle();
            this.updateNodeClipToNewBoundsListener = (observableValue, bounds, bounds2) -> Clipper.resizeRectangleToBounds(this.nodeClip, bounds2);
            this.setClipping();
            snapshotView.unselectedAreaBoundaryProperty().addListener((observableValue, boundary, boundary2) -> this.setClipping());
        }

        private void setClipping() {
            SnapshotView.Boundary boundary = this.snapshotView.getUnselectedAreaBoundary();
            switch (boundary) {
                case CONTROL: {
                    this.clipToControl();
                    break;
                }
                case NODE: {
                    this.clipToNode();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The boundary " + boundary + " is not fully implemented.");
                }
            }
        }

        private void clipToControl() {
            this.updateNodeClipToChangingNode((ObservableValue<? extends Node>)this.snapshotView.nodeProperty(), this.snapshotView.getNode(), null);
            Clipper.resizeRectangleToBounds(this.controlClip, this.snapshotView.getBoundsInLocal());
            this.snapshotView.boundsInLocalProperty().addListener(this.updateControlClipToNewBoundsListener);
            this.setClip((Node)this.controlClip);
        }

        private void clipToNode() {
            this.updateNodeClipToChangingNode((ObservableValue<? extends Node>)this.snapshotView.nodeProperty(), null, this.snapshotView.getNode());
            this.snapshotView.nodeProperty().addListener(this::updateNodeClipToChangingNode);
            this.setClip((Node)this.nodeClip);
        }

        private void updateNodeClipToChangingNode(ObservableValue<? extends Node> observableValue, Node node, Node node2) {
            Clipper.resizeRectangleToNodeBounds(this.nodeClip, node2);
            if (node != null) {
                node.boundsInParentProperty().removeListener(this.updateNodeClipToNewBoundsListener);
            }
            if (node2 != null) {
                node2.boundsInParentProperty().addListener(this.updateNodeClipToNewBoundsListener);
            }
        }

        private static void resizeRectangleToNodeBounds(Rectangle rectangle, Node node) {
            if (node == null) {
                Clipper.resizeRectangleToZero(rectangle);
            } else {
                Clipper.resizeRectangleToBounds(rectangle, node.getBoundsInParent());
            }
        }

        private static void resizeRectangleToZero(Rectangle rectangle) {
            rectangle.setX(0.0);
            rectangle.setY(0.0);
            rectangle.setWidth(0.0);
            rectangle.setHeight(0.0);
        }

        private static void resizeRectangleToBounds(Rectangle rectangle, Bounds bounds) {
            rectangle.setX(bounds.getMinX());
            rectangle.setY(bounds.getMinY());
            rectangle.setWidth(bounds.getWidth());
            rectangle.setHeight(bounds.getHeight());
        }

        private void setClip(Node node) {
            boolean bl2;
            boolean bl3 = bl2 = !this.clippedNode.isVisible();
            if (bl2) {
                this.clippedNode.visibleProperty().unbind();
                this.clippedNode.setVisible(true);
            }
            this.clippedNode.setClip(node);
            if (bl2) {
                this.rebindClippedNodeVisibility.run();
            }
        }
    }
}

