/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.MaskerPane;

public class MaskerPaneSkin
extends SkinBase<MaskerPane> {
    public MaskerPaneSkin(MaskerPane maskerPane) {
        super((Control)maskerPane);
        this.getChildren().add((Object)this.createMasker(maskerPane));
    }

    private StackPane createMasker(MaskerPane maskerPane) {
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER);
        vBox.setSpacing(10.0);
        vBox.getStyleClass().add((Object)"masker-center");
        vBox.getChildren().add((Object)this.createLabel());
        vBox.getChildren().add((Object)this.createProgressIndicator());
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().addAll((Object[])new Node[]{vBox});
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        stackPane.getStyleClass().add((Object)"masker-glass");
        stackPane.getChildren().add((Object)hBox);
        return stackPane;
    }

    private Label createLabel() {
        Label label = new Label();
        label.textProperty().bind((ObservableValue)((MaskerPane)this.getSkinnable()).textProperty());
        label.getStyleClass().add((Object)"masker-text");
        return label;
    }

    private Label createProgressIndicator() {
        Label label = new Label();
        label.setGraphic(((MaskerPane)this.getSkinnable()).getProgressNode());
        label.visibleProperty().bind((ObservableValue)((MaskerPane)this.getSkinnable()).progressVisibleProperty());
        label.getStyleClass().add((Object)"masker-graphic");
        return label;
    }
}

