/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.util.AttributesImpl;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.bind.v2.runtime.output.Pcdata;
import com.sun.xml.bind.v2.runtime.output.XmlOutputAbstractImpl;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class SAXOutput
extends XmlOutputAbstractImpl {
    protected final ContentHandler out;
    private String elementNsUri;
    private String elementLocalName;
    private String elementQName;
    private char[] buf = new char[256];
    private final AttributesImpl atts = new AttributesImpl();

    public SAXOutput(ContentHandler contentHandler) {
        this.out = contentHandler;
        contentHandler.setDocumentLocator(new LocatorImpl());
    }

    @Override
    public void startDocument(XMLSerializer xMLSerializer, boolean bl2, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws SAXException, IOException, XMLStreamException {
        super.startDocument(xMLSerializer, bl2, nArray, namespaceContextImpl);
        if (!bl2) {
            this.out.startDocument();
        }
    }

    @Override
    public void endDocument(boolean bl2) throws SAXException, IOException, XMLStreamException {
        if (!bl2) {
            this.out.endDocument();
        }
        super.endDocument(bl2);
    }

    @Override
    public void beginStartTag(int n2, String string) {
        this.elementNsUri = this.nsContext.getNamespaceURI(n2);
        this.elementLocalName = string;
        this.elementQName = this.getQName(n2, string);
        this.atts.clear();
    }

    @Override
    public void attribute(int n2, String string, String string2) {
        String string3;
        String string4;
        if (n2 == -1) {
            string4 = "";
            string3 = string;
        } else {
            string4 = this.nsContext.getNamespaceURI(n2);
            String string5 = this.nsContext.getPrefix(n2);
            string3 = string5.length() == 0 ? string : string5 + ':' + string;
        }
        this.atts.addAttribute(string4, string, string3, "CDATA", string2);
    }

    @Override
    public void endStartTag() throws SAXException {
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (element != null) {
            int n2 = element.count();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = element.getPrefix(i2);
                String string2 = element.getNsUri(i2);
                if (string2.length() == 0 && element.getBase() == 1) continue;
                this.out.startPrefixMapping(string, string2);
            }
        }
        this.out.startElement(this.elementNsUri, this.elementLocalName, this.elementQName, this.atts);
    }

    @Override
    public void endTag(int n2, String string) throws SAXException {
        this.out.endElement(this.nsContext.getNamespaceURI(n2), string, this.getQName(n2, string));
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (element != null) {
            int n3 = element.count();
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                String string2 = element.getPrefix(i2);
                String string3 = element.getNsUri(i2);
                if (string3.length() == 0 && element.getBase() == 1) continue;
                this.out.endPrefixMapping(string2);
            }
        }
    }

    private String getQName(int n2, String string) {
        String string2 = this.nsContext.getPrefix(n2);
        String string3 = string2.length() == 0 ? string : string2 + ':' + string;
        return string3;
    }

    @Override
    public void text(String string, boolean bl2) throws IOException, SAXException, XMLStreamException {
        int n2 = string.length();
        if (this.buf.length <= n2) {
            this.buf = new char[Math.max(this.buf.length * 2, n2 + 1)];
        }
        if (bl2) {
            string.getChars(0, n2, this.buf, 1);
            this.buf[0] = 32;
        } else {
            string.getChars(0, n2, this.buf, 0);
        }
        this.out.characters(this.buf, 0, n2 + (bl2 ? 1 : 0));
    }

    @Override
    public void text(Pcdata pcdata, boolean bl2) throws IOException, SAXException, XMLStreamException {
        int n2 = pcdata.length();
        if (this.buf.length <= n2) {
            this.buf = new char[Math.max(this.buf.length * 2, n2 + 1)];
        }
        if (bl2) {
            pcdata.writeTo(this.buf, 1);
            this.buf[0] = 32;
        } else {
            pcdata.writeTo(this.buf, 0);
        }
        this.out.characters(this.buf, 0, n2 + (bl2 ? 1 : 0));
    }
}

