/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation.base;

import com.jfoenix.controls.JFXTooltip;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;

public abstract class ValidatorBase {
    public static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private static final String TOOLTIP_PROP_KEY = "javafx.scene.control.Tooltip";
    public static final String ERROR_TOOLTIP_STYLE_CLASS = "error-tooltip";
    private static final String TEMP_TOOLTIP_KEY = "stashed-tootlip";
    private static final Set<String> supportedTooltipKeys = new HashSet<String>(Arrays.asList("javafx.scene.control.Tooltip", "jfoenix-tooltip"));
    protected SimpleObjectProperty<Node> srcControl = new SimpleObjectProperty();
    protected ReadOnlyBooleanWrapper hasErrors = new ReadOnlyBooleanWrapper(false);
    private Supplier<Tooltip> errorTooltipSupplier = () -> new Tooltip();
    protected SimpleStringProperty message = new SimpleStringProperty();
    protected SimpleObjectProperty<Supplier<Node>> iconSupplier = new SimpleObjectProperty();

    public ValidatorBase(String string) {
        this();
        this.setMessage(string);
    }

    public ValidatorBase() {
    }

    public void validate() {
        this.eval();
        this.onEval();
    }

    protected abstract void eval();

    protected void onEval() {
        Node node = this.getSrcControl();
        boolean bl2 = this.hasErrors.get();
        node.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, bl2);
        Tooltip tooltip = this.getActiveTooltip(node);
        if (bl2) {
            Tooltip tooltip2 = this.errorTooltipSupplier.get();
            tooltip2.getStyleClass().add((Object)ERROR_TOOLTIP_STYLE_CLASS);
            tooltip2.setText(this.getMessage());
            this.install(node, tooltip, tooltip2);
        } else {
            Tooltip tooltip3 = (Tooltip)node.getProperties().remove((Object)TEMP_TOOLTIP_KEY);
            this.install(node, tooltip, tooltip3);
        }
    }

    private final Tooltip getActiveTooltip(Node node) {
        Tooltip tooltip = null;
        for (String string : supportedTooltipKeys) {
            tooltip = (Tooltip)node.getProperties().get((Object)string);
            if (tooltip == null) continue;
            break;
        }
        return tooltip;
    }

    private void install(Node node, Tooltip tooltip, Tooltip tooltip2) {
        if (tooltip != null && !tooltip.getStyleClass().contains((Object)ERROR_TOOLTIP_STYLE_CLASS)) {
            node.getProperties().put((Object)TEMP_TOOLTIP_KEY, (Object)tooltip);
        }
        if (node instanceof Control) {
            if (tooltip != null) {
                if (tooltip instanceof JFXTooltip) {
                    JFXTooltip.uninstall(node);
                }
                if (tooltip2 == null || !(tooltip2 instanceof JFXTooltip)) {
                    ((Control)node).setTooltip(tooltip2);
                    return;
                }
                if (tooltip2 instanceof JFXTooltip) {
                    ((Control)node).setTooltip(null);
                }
            }
            if (tooltip2 instanceof JFXTooltip) {
                this.install(node, tooltip2);
            } else {
                ((Control)node).setTooltip(tooltip2);
            }
        } else {
            this.uninstall(node, tooltip);
            this.install(node, tooltip2);
        }
    }

    private void uninstall(Node node, Tooltip tooltip) {
        if (tooltip instanceof JFXTooltip) {
            JFXTooltip.uninstall(node);
        } else {
            Tooltip.uninstall((Node)node, (Tooltip)tooltip);
        }
    }

    private void install(Node node, Tooltip tooltip) {
        if (tooltip == null) {
            return;
        }
        if (tooltip instanceof JFXTooltip) {
            JFXTooltip.install(node, (JFXTooltip)tooltip);
        } else {
            Tooltip.install((Node)node, (Tooltip)tooltip);
        }
    }

    public void setSrcControl(Node node) {
        this.srcControl.set((Object)node);
    }

    public Node getSrcControl() {
        return (Node)this.srcControl.get();
    }

    public ObjectProperty<Node> srcControlProperty() {
        return this.srcControl;
    }

    public boolean getHasErrors() {
        return this.hasErrors.get();
    }

    public ReadOnlyBooleanProperty hasErrorsProperty() {
        return this.hasErrors.getReadOnlyProperty();
    }

    public Supplier<Tooltip> getErrorTooltipSupplier() {
        return this.errorTooltipSupplier;
    }

    public void setErrorTooltipSupplier(Supplier<Tooltip> supplier) {
        this.errorTooltipSupplier = supplier;
    }

    public void setMessage(String string) {
        this.message.set(string);
    }

    public String getMessage() {
        return this.message.get();
    }

    public StringProperty messageProperty() {
        return this.message;
    }

    public void setIconSupplier(Supplier<Node> supplier) {
        this.iconSupplier.set(supplier);
    }

    public SimpleObjectProperty<Supplier<Node>> iconSupplierProperty() {
        return this.iconSupplier;
    }

    public Supplier<Node> getIconSupplier() {
        return (Supplier)this.iconSupplier.get();
    }

    public void setIcon(Node node) {
        this.iconSupplier.set(() -> node);
    }

    public Node getIcon() {
        if (this.iconSupplier.get() == null) {
            return null;
        }
        Node node = (Node)((Supplier)this.iconSupplier.get()).get();
        if (node != null) {
            node.getStyleClass().add((Object)"error-icon");
        }
        return node;
    }
}

