/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import com.jfoenix.utils.JFXUtilities;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class JFXHighlighter {
    private Parent parent;
    private HashMap<Node, List<Rectangle>> boxes = new HashMap();
    private ObjectProperty<Paint> paint = new SimpleObjectProperty((Object)Color.rgb((int)255, (int)0, (int)0, (double)0.4));
    private Method textLayoutMethod;
    private Field parentChildrenField;

    public JFXHighlighter() {
        try {
            this.textLayoutMethod = Text.class.getDeclaredMethod("getTextLayout", new Class[0]);
            this.textLayoutMethod.setAccessible(true);
            this.parentChildrenField = Parent.class.getDeclaredField("children");
            this.parentChildrenField.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void highlight(Parent parent, String string) {
        if (this.parent != null && !this.boxes.isEmpty()) {
            this.clear();
        }
        if (string == null || string.isEmpty()) {
            return;
        }
        this.parent = parent;
        Set<Node> set = this.getTextNodes(parent);
        ArrayList<HighLightRectangle> arrayList = new ArrayList<HighLightRectangle>();
        for (Node node : set) {
            Text text = (Text)node;
            int n2 = text.getText().toLowerCase().indexOf(string.toLowerCase());
            if (n2 <= -1 || !NodeHelper.isTreeVisible((Node)node)) continue;
            ArrayList<Bounds> arrayList2 = this.getMatchingBounds(string, text);
            ArrayList<HighLightRectangle> arrayList3 = new ArrayList<HighLightRectangle>();
            for (Bounds bounds : arrayList2) {
                HighLightRectangle highLightRectangle = new HighLightRectangle(text);
                highLightRectangle.setCacheHint(CacheHint.SPEED);
                highLightRectangle.setCache(true);
                highLightRectangle.setMouseTransparent(true);
                highLightRectangle.setBlendMode(BlendMode.MULTIPLY);
                highLightRectangle.fillProperty().bind(this.paintProperty());
                highLightRectangle.setManaged(false);
                highLightRectangle.setX(bounds.getMinX());
                highLightRectangle.setY(bounds.getMinY());
                highLightRectangle.setWidth(bounds.getWidth());
                highLightRectangle.setHeight(bounds.getHeight());
                arrayList3.add(highLightRectangle);
                arrayList.add(highLightRectangle);
            }
            this.boxes.put(node, arrayList3);
        }
        JFXUtilities.runInFXAndWait(() -> this.getParentChildren(parent).addAll((Collection)arrayList));
    }

    private Set<Node> getTextNodes(Parent parent) {
        Set set = parent.lookupAll("LabeledText");
        Set set2 = parent.lookupAll("Text");
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    private ObservableList<Node> getParentChildren(Parent parent) {
        try {
            return (ObservableList)this.parentChildrenField.get(parent);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    private ArrayList<Bounds> getMatchingBounds(String string, Text text) {
        Bounds bounds = this.parent.sceneToLocal(text.localToScene(text.getBoundsInLocal()));
        ArrayList<Bounds> arrayList = new ArrayList<Bounds>();
        TextLayout textLayout = null;
        try {
            textLayout = (TextLayout)this.textLayoutMethod.invoke((Object)text, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        int n2 = string.length();
        TextLine[] textLineArray = textLayout.getLines();
        for (int i2 = 0; i2 < textLineArray.length; ++i2) {
            String string2;
            TextLine textLine = textLineArray[i2];
            String string3 = text.getText().substring(textLine.getStart(), textLine.getStart() + textLine.getLength());
            String string4 = string3.toLowerCase();
            int n3 = string4.indexOf(string2 = string.toLowerCase());
            if (n3 == -1) continue;
            RectBounds rectBounds = textLine.getBounds();
            double d2 = Math.round(rectBounds.getMaxY()) - Math.round(rectBounds.getMinY());
            double d3 = d2 * (double)i2;
            while (n3 != -1) {
                Text text2 = new Text(string3.substring(n3, n3 + n2));
                text2.setFont(text.getFont());
                text2.applyCss();
                double d4 = text2.getLayoutBounds().getWidth();
                text2.setText(string3.substring(0, n3 + n2));
                text2.applyCss();
                double d5 = text2.getLayoutBounds().getMaxX();
                double d6 = d5 - d4;
                arrayList.add((Bounds)new BoundingBox(bounds.getMinX() + d6, bounds.getMinY() + d3, d4, text2.getLayoutBounds().getHeight()));
                n3 = string4.indexOf(string2, n3 + n2);
            }
        }
        return arrayList;
    }

    public synchronized void clear() {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Collection<List<Rectangle>> collection = this.boxes.values();
        for (List<Rectangle> list : collection) {
            arrayList.addAll(list);
        }
        this.boxes.clear();
        if (this.parent != null) {
            JFXUtilities.runInFXAndWait(() -> this.getParentChildren(this.parent).removeAll((Collection)arrayList));
        }
    }

    public Paint getPaint() {
        return (Paint)this.paint.get();
    }

    public ObjectProperty<Paint> paintProperty() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint.set((Object)paint);
    }

    private class HighLightRectangle
    extends Rectangle {
        private InvalidationListener listener = observable -> this.clear(text);

        public HighLightRectangle(Text text) {
            text.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
            text.localToSceneTransformProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        }

        private void clear(Text text) {
            List list = (List)JFXHighlighter.this.boxes.get(text);
            if (list != null && !list.isEmpty()) {
                Platform.runLater(() -> JFXHighlighter.this.getParentChildren(JFXHighlighter.this.parent).removeAll((Collection)list));
            }
        }
    }
}

