/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.base.IFXStaticControl;
import com.jfoenix.controls.base.IFXValidatableControl;
import com.jfoenix.utils.JFXUtilities;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class ValidationPane<T extends Region & IFXStaticControl>
extends HBox {
    private Label errorLabel = new Label();
    private StackPane errorIcon = new StackPane();
    private final Rectangle errorContainerClip = new Rectangle();
    private final Scale errorClipScale = new Scale(1.0, 0.0, 0.0, 0.0);
    private Timeline errorHideTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Interpolator.LINEAR)})});
    private Timeline errorShowTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Interpolator.EASE_OUT)})});
    private Timeline scale1 = new Timeline();
    private Timeline scaleLess1 = new Timeline();
    private T control;

    public ValidationPane(T t2) {
        this.control = t2;
        this.setManaged(false);
        this.errorLabel.getStyleClass().add((Object)"error-label");
        StackPane stackPane = new StackPane(new Node[]{this.errorLabel});
        stackPane.getStyleClass().add((Object)"error-label-container");
        stackPane.setAlignment(Pos.TOP_LEFT);
        this.getChildren().setAll((Object[])new Node[]{stackPane, this.errorIcon});
        HBox.setHgrow((Node)stackPane, (Priority)Priority.ALWAYS);
        this.setSpacing(8.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setPadding(new Insets(4.0, 0.0, 0.0, 0.0));
        this.setVisible(false);
        this.setOpacity(0.0);
        this.errorContainerClip.getTransforms().add((Object)this.errorClipScale);
        this.setClip((Node)(((IFXStaticControl)t2).isDisableAnimation() != false ? null : this.errorContainerClip));
        ((IFXValidatableControl)t2).activeValidatorProperty().addListener((observableValue, validatorBase, validatorBase2) -> {
            if (!((IFXStaticControl)t2).isDisableAnimation().booleanValue()) {
                if (validatorBase2 != null) {
                    this.errorHideTransition.setOnFinished(actionEvent2 -> {
                        this.showError((ValidatorBase)validatorBase2);
                        double d2 = t2.getWidth();
                        double d3 = this.computeErrorHeight(this.computeErrorWidth(d2));
                        if (this.errorLabel.isWrapText()) {
                            if (d3 < this.getHeight()) {
                                this.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{this.createSmallerScaleFrame(d3)});
                                this.scaleLess1.setOnFinished(actionEvent -> {
                                    this.updateErrorContainerSize(d2, d3);
                                    this.errorClipScale.setY(1.0);
                                });
                                SequentialTransition sequentialTransition = new SequentialTransition(new Animation[]{this.scaleLess1, this.errorShowTransition});
                                sequentialTransition.play();
                            } else {
                                this.errorClipScale.setY(validatorBase == null ? 0.0 : this.getHeight() / d3);
                                this.updateErrorContainerSize(d2, d3);
                                this.scale1.getKeyFrames().setAll((Object[])new KeyFrame[]{this.createScaleToOneFrames()});
                                ParallelTransition parallelTransition = new ParallelTransition();
                                parallelTransition.getChildren().addAll((Object[])new Animation[]{this.scale1, this.errorShowTransition});
                                parallelTransition.play();
                            }
                        } else {
                            this.errorClipScale.setY(1.0);
                            this.updateErrorContainerSize(d2, d3);
                            ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.errorShowTransition});
                            parallelTransition.play();
                        }
                    });
                    this.errorHideTransition.play();
                } else {
                    this.errorHideTransition.setOnFinished(null);
                    if (this.errorLabel.isWrapText()) {
                        this.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                        this.scaleLess1.setOnFinished(actionEvent -> {
                            this.hideError();
                            this.errorClipScale.setY(0.0);
                        });
                        SequentialTransition sequentialTransition = new SequentialTransition(new Animation[]{this.scaleLess1});
                        sequentialTransition.play();
                    } else {
                        this.errorClipScale.setY(0.0);
                    }
                    this.errorHideTransition.play();
                }
            } else if (validatorBase2 != null) {
                JFXUtilities.runInFXAndWait(() -> this.showError((ValidatorBase)validatorBase2));
            } else {
                JFXUtilities.runInFXAndWait(this::hideError);
            }
        });
    }

    public void layoutPane(double d2, double d3, double d4, double d5) {
        this.relocate(d2, d3);
        if (((IFXStaticControl)this.control).isDisableAnimation().booleanValue() || this.isErrorVisible()) {
            this.resize(d4, this.computeErrorHeight(this.computeErrorWidth(d4)));
            this.errorContainerClip.setWidth(d4);
        }
    }

    public void invalid(double d2) {
        ValidatorBase validatorBase = ((IFXValidatableControl)this.control).getActiveValidator();
        if (validatorBase != null) {
            this.showError(validatorBase);
            double d3 = d2 - this.errorIcon.prefWidth(-1.0);
            this.setOpacity(1.0);
            this.resize(d2, this.computeErrorHeight(d3));
            this.errorContainerClip.setWidth(d2);
            this.errorContainerClip.setHeight(this.getHeight());
            this.errorClipScale.setY(1.0);
        }
    }

    public void updateClip() {
        this.setClip((Node)(((IFXStaticControl)this.control).isDisableAnimation() != false ? null : this.errorContainerClip));
    }

    private boolean isErrorVisible() {
        return this.isVisible() && this.errorShowTransition.getStatus().equals((Object)Animation.Status.STOPPED) && this.errorHideTransition.getStatus().equals((Object)Animation.Status.STOPPED);
    }

    private double computeErrorWidth(double d2) {
        return d2 - this.errorIcon.prefWidth(-1.0);
    }

    private double computeErrorHeight(double d2) {
        return this.errorLabel.prefHeight(d2) + this.snappedBottomInset() + this.snappedTopInset();
    }

    private void updateErrorContainerSize(double d2, double d3) {
        this.errorContainerClip.setWidth(d2);
        this.errorContainerClip.setHeight(d3);
        this.resize(d2, d3);
    }

    private KeyFrame createSmallerScaleFrame(double d2) {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)(d2 / this.getHeight()), Interpolator.EASE_BOTH)});
    }

    private KeyFrame createScaleToOneFrames() {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)1, Interpolator.EASE_BOTH)});
    }

    private void showError(ValidatorBase validatorBase) {
        this.errorLabel.setText(validatorBase.getMessage());
        Node node = validatorBase.getIcon();
        this.errorIcon.getChildren().clear();
        if (node != null) {
            this.errorIcon.getChildren().setAll((Object[])new Node[]{node});
            StackPane.setAlignment((Node)node, (Pos)Pos.CENTER_RIGHT);
        }
        this.setVisible(true);
    }

    private void hideError() {
        this.errorLabel.setText(null);
        this.errorIcon.getChildren().clear();
        this.setVisible(false);
    }
}

