/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXTimePicker;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import javafx.util.converter.LocalTimeStringConverter;
import javafx.util.converter.NumberStringConverter;

public class JFXTimePickerContent
extends VBox {
    private static final String ROBOTO = "Roboto";
    private static final String SPINNER_LABEL = "spinner-label";
    protected JFXTimePicker timePicker;
    private Color fadedColor = Color.rgb((int)255, (int)255, (int)255, (double)0.67);
    private boolean is24HourView = false;
    private double contentCircleRadius = 100.0;
    private Label selectedHourLabel = new Label();
    private Label selectedMinLabel = new Label();
    private Label periodPMLabel;
    private Label periodAMLabel;
    private StackPane calendarPlaceHolder = new StackPane();
    private StackPane hoursContent;
    private StackPane minutesContent;
    private Rotate hoursPointerRotate;
    private Rotate _24HourHoursPointerRotate;
    private Rotate minsPointerRotate;
    private ObjectProperty<TimeUnit> unit = new SimpleObjectProperty((Object)TimeUnit.HOURS);
    private DoubleProperty angle = new SimpleDoubleProperty(Math.toDegrees(0.5235987755982988));
    private StringProperty period = new SimpleStringProperty("AM");
    private ObjectProperty<Rotate> pointerRotate = new SimpleObjectProperty();
    private ObjectProperty<Rotate> _24HourPointerRotate = new SimpleObjectProperty();
    private ObjectProperty<Label> timeLabel = new SimpleObjectProperty();
    private NumberStringConverter unitConverter = new NumberStringConverter("#00");
    private ObjectProperty<LocalTime> selectedTime = new SimpleObjectProperty((Object)this, "selectedTime");

    JFXTimePickerContent(JFXTimePicker jFXTimePicker) {
        this.timePicker = jFXTimePicker;
        LocalTime localTime3 = this.timePicker.getValue() == null ? LocalTime.now() : (LocalTime)this.timePicker.getValue();
        this.is24HourView = this.timePicker.is24HourView();
        this.timePicker.valueProperty().addListener((observableValue, localTime, localTime2) -> this.goToTime((LocalTime)localTime2));
        this.getStyleClass().add((Object)"date-picker-popup");
        this.getChildren().add((Object)this.createHeaderPane(localTime3, this.is24HourView));
        VBox vBox = new VBox();
        vBox.getChildren().add((Object)this.createContentPane(localTime3, this.is24HourView));
        this.calendarPlaceHolder.getChildren().add((Object)vBox);
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)this.calendarPlaceHolder.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)this.calendarPlaceHolder.heightProperty());
        this.calendarPlaceHolder.setClip((Node)rectangle);
        StackPane stackPane = new StackPane(new Node[]{this.calendarPlaceHolder});
        this.getChildren().add((Object)stackPane);
        this.unit.addListener((observableValue, timeUnit, timeUnit2) -> {
            if (timeUnit2 == TimeUnit.HOURS) {
                this.angle.set(Math.toDegrees(0.5235987755982988));
                int n2 = Integer.parseInt(this.selectedHourLabel.getText());
                if (this.is24HourView) {
                    if (n2 == 0 || n2 > 12) {
                        ((Node)this.hoursContent.getChildren().get(0)).setVisible(false);
                        ((Node)this.hoursContent.getChildren().get(1)).setVisible(true);
                    } else {
                        ((Node)this.hoursContent.getChildren().get(1)).setVisible(false);
                        ((Node)this.hoursContent.getChildren().get(0)).setVisible(true);
                    }
                }
                this.pointerRotate.set((Object)this._24HourHoursPointerRotate);
                this._24HourPointerRotate.set((Object)this._24HourHoursPointerRotate);
                this.timeLabel.set((Object)this.selectedHourLabel);
            } else if (timeUnit2 == TimeUnit.MINUTES) {
                this.angle.set(Math.toDegrees(0.10471975511965977));
                this.pointerRotate.set((Object)this.minsPointerRotate);
                this.timeLabel.set((Object)this.selectedMinLabel);
            }
            this.swapLabelsColor(this.selectedHourLabel, this.selectedMinLabel);
            this.switchTimeUnit((TimeUnit)((Object)timeUnit2));
        });
        if (!this.is24HourView) {
            this.period.addListener((observableValue, string, string2) -> {
                this.swapLabelsColor(this.periodPMLabel, this.periodAMLabel);
                this.updateValue();
            });
        }
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-time-picker.css").toExternalForm();
    }

    protected BorderPane createContentPane(LocalTime localTime, boolean bl2) {
        Circle circle = new Circle(this.contentCircleRadius);
        Circle circle2 = new Circle(this.contentCircleRadius / 6.0);
        circle.setFill((Paint)Color.rgb((int)224, (int)224, (int)224, (double)0.67));
        EventHandler eventHandler = mouseEvent -> {
            int n2;
            double d2 = mouseEvent.getX();
            double d3 = mouseEvent.getY();
            double d4 = 9.0;
            double d5 = Math.atan2(d3, d2);
            int n3 = (int)Math.round((180.0 + Math.toDegrees(d5)) / this.angle.get());
            if (bl2) {
                if ((double)this.distance(0.0, 0.0, d2, d3) >= this.contentCircleRadius - d4 - 2.0 * circle2.getRadius()) {
                    ((Node)this.hoursContent.getChildren().get(1)).setVisible(false);
                    ((Node)this.hoursContent.getChildren().get(0)).setVisible(true);
                    ((Rotate)this.pointerRotate.get()).setAngle((double)n3 * this.angle.get());
                    n2 = (n3 + 9) % 12 == 0 ? 12 : (n3 + 9) % 12;
                } else {
                    ((Node)this.hoursContent.getChildren().get(0)).setVisible(false);
                    ((Node)this.hoursContent.getChildren().get(1)).setVisible(true);
                    ((Rotate)this._24HourPointerRotate.get()).setAngle((double)n3 * this.angle.get());
                    int n4 = (n3 + 21) % 24 <= 13 ? (n3 + 21) % 24 + 12 : (n3 + 21) % 24;
                    n2 = n4 == 12 ? 0 : n4;
                }
            } else {
                ((Rotate)this.pointerRotate.get()).setAngle((double)n3 * this.angle.get());
                int n5 = n2 = (n3 + 9) % 12 == 0 ? 12 : (n3 + 9) % 12;
            }
            if (this.unit.get() == TimeUnit.MINUTES) {
                n2 = (n3 + 45) % 60;
            }
            ((Label)this.timeLabel.get()).setText(this.unit.get() == TimeUnit.MINUTES ? this.unitConverter.toString((Number)n2) : Integer.toString(n2));
            this.updateValue();
        };
        circle.setOnMousePressed(eventHandler);
        circle.setOnMouseDragged(eventHandler);
        this.hoursContent = this.createHoursContent(localTime, bl2);
        this.hoursContent.setMouseTransparent(true);
        this.minutesContent = this.createMinutesContent(localTime);
        this.minutesContent.setOpacity(0.0);
        this.minutesContent.setMouseTransparent(true);
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Object[])new Node[]{circle, this.hoursContent, this.minutesContent});
        stackPane.setPadding(new Insets(12.0));
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)stackPane);
        borderPane.setMinHeight(50.0);
        borderPane.setPadding(new Insets(2.0, 12.0, 2.0, 12.0));
        return borderPane;
    }

    private float distance(double d2, double d3, double d4, double d5) {
        return (float)Math.sqrt((d2 -= d4) * d2 + (d3 -= d5) * d3);
    }

    protected StackPane createHeaderPane(LocalTime localTime, boolean bl2) {
        int n2 = localTime.getHour();
        this.selectedHourLabel.setText(String.valueOf(n2 % (bl2 ? 24 : 12) == 0 ? (bl2 ? 0 : 12) : n2 % (bl2 ? 24 : 12)));
        this.selectedHourLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.selectedHourLabel.setTextFill((Paint)Color.WHITE);
        this.selectedHourLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)42.0));
        this.selectedHourLabel.setOnMouseClicked(mouseEvent -> this.unit.set((Object)TimeUnit.HOURS));
        this.selectedHourLabel.setMinWidth(49.0);
        this.selectedHourLabel.setAlignment(Pos.CENTER_RIGHT);
        this.timeLabel.set((Object)this.selectedHourLabel);
        this.selectedMinLabel.setText(String.valueOf(this.unitConverter.toString((Number)localTime.getMinute())));
        this.selectedMinLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.selectedMinLabel.setTextFill((Paint)this.fadedColor);
        this.selectedMinLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)42.0));
        this.selectedMinLabel.setOnMouseClicked(mouseEvent -> this.unit.set((Object)TimeUnit.MINUTES));
        Label label = new Label(":");
        label.setPadding(new Insets(0.0, 0.0, 4.0, 0.0));
        label.setTextFill((Paint)this.fadedColor);
        label.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)42.0));
        this.periodPMLabel = new Label("PM");
        this.periodPMLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.periodPMLabel.setTextFill((Paint)this.fadedColor);
        this.periodPMLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)14.0));
        this.periodPMLabel.setOnMouseClicked(mouseEvent -> this.period.set((Object)"PM"));
        this.periodAMLabel = new Label("AM");
        this.periodAMLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.periodAMLabel.setTextFill((Paint)this.fadedColor);
        this.periodAMLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)14.0));
        this.periodAMLabel.setOnMouseClicked(mouseEvent -> this.period.set((Object)"AM"));
        if (n2 < 12) {
            this.periodAMLabel.setTextFill((Paint)Color.WHITE);
        } else {
            this.periodPMLabel.setTextFill((Paint)Color.WHITE);
        }
        this.period.set((Object)(n2 < 12 ? "AM" : "PM"));
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(0.0, 0.0, 0.0, 4.0));
        vBox.getChildren().addAll((Object[])new Node[]{this.periodAMLabel, this.periodPMLabel});
        HBox hBox = new HBox();
        hBox.getStyleClass().add((Object)"spinner");
        hBox.getChildren().addAll((Object[])new Node[]{this.selectedHourLabel, label, this.selectedMinLabel});
        if (!bl2) {
            hBox.getChildren().add((Object)vBox);
        }
        hBox.setAlignment(Pos.CENTER);
        hBox.setFillHeight(false);
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().add((Object)"time-pane");
        stackPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.timePicker.getDefaultColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        stackPane.setPadding(new Insets(8.0, 24.0, 8.0, 24.0));
        stackPane.getChildren().add((Object)hBox);
        return stackPane;
    }

    private StackPane createHoursContent(LocalTime localTime, boolean bl2) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        StackPane stackPane;
        Label label;
        int n2;
        int n3;
        StackPane stackPane2 = new StackPane();
        StackPane stackPane3 = new StackPane();
        Circle circle = new Circle(this.contentCircleRadius / 6.0);
        Circle circle2 = new Circle(this.contentCircleRadius / 6.0);
        circle.fillProperty().bind(this.timePicker.defaultColorProperty());
        circle2.fillProperty().bind(this.timePicker.defaultColorProperty());
        double d8 = 9.0;
        double d9 = 27.5;
        Line line = new Line(d8, 0.0, this.contentCircleRadius, 0.0);
        line.fillProperty().bind(this.timePicker.defaultColorProperty());
        line.strokeProperty().bind((ObservableValue)line.fillProperty());
        line.setStrokeWidth(1.5);
        stackPane2.getChildren().addAll((Object[])new Node[]{line, circle});
        StackPane.setAlignment((Node)circle, (Pos)Pos.CENTER_LEFT);
        Group group = new Group();
        group.getChildren().add((Object)stackPane2);
        group.setTranslateX((-this.contentCircleRadius + d8) / 2.0);
        this.hoursPointerRotate = new Rotate(0.0, this.contentCircleRadius - d8, circle.getRadius());
        this.pointerRotate.set((Object)this.hoursPointerRotate);
        group.getTransforms().add((Object)this.hoursPointerRotate);
        group.setVisible(!this.is24HourView);
        Line line2 = new Line(d8 + d9, 0.0, this.contentCircleRadius, 0.0);
        line2.fillProperty().bind(this.timePicker.defaultColorProperty());
        line2.strokeProperty().bind((ObservableValue)line2.fillProperty());
        line2.setStrokeWidth(1.5);
        stackPane3.getChildren().addAll((Object[])new Node[]{line2, circle2});
        StackPane.setAlignment((Node)circle2, (Pos)Pos.CENTER_LEFT);
        Group group2 = new Group();
        group2.getChildren().add((Object)stackPane3);
        group2.setTranslateX((-this.contentCircleRadius + d8) / 2.0 + d9 / 2.0);
        this._24HourHoursPointerRotate = new Rotate(0.0, this.contentCircleRadius - d8 - d9, circle.getRadius());
        this._24HourPointerRotate.set((Object)this._24HourHoursPointerRotate);
        group2.getTransforms().add((Object)this._24HourHoursPointerRotate);
        group2.setVisible(this.is24HourView);
        Pane pane = new Pane();
        double d10 = this.contentCircleRadius - d8 - circle.getRadius();
        for (n3 = 0; n3 < 12; ++n3) {
            n2 = (n3 + 3) % 12 == 0 ? 12 : (n3 + 3) % 12;
            label = new Label(Integer.toString(n2));
            label.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
            label.setTextFill((Paint)((n2 == localTime.getHour() % 12 || n2 == 12 && localTime.getHour() % 12 == 0) && !this.is24HourView ? Color.rgb((int)255, (int)255, (int)255, (double)0.87) : Color.rgb((int)0, (int)0, (int)0, (double)0.87)));
            this.selectedHourLabel.textProperty().addListener((observableValue, string, string2) -> {
                if (Integer.parseInt(string2) == Integer.parseInt(label.getText())) {
                    label.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
                } else {
                    label.setTextFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.87));
                }
            });
            stackPane = new StackPane();
            stackPane.getChildren().add((Object)label);
            d7 = circle.getRadius() / Math.sqrt(2.0) * 2.0;
            stackPane.setMinSize(d7, d7);
            d6 = (double)(2 * n3) * Math.PI / 12.0;
            d5 = d10 * Math.cos(d6);
            d4 = d10 * Math.sin(d6);
            d3 = this.contentCircleRadius + d5;
            d2 = this.contentCircleRadius + d4;
            stackPane.setLayoutX(d3 - stackPane.getMinWidth() / 2.0);
            stackPane.setLayoutY(d2 - stackPane.getMinHeight() / 2.0);
            pane.getChildren().add((Object)stackPane);
            if (this.is24HourView || n2 != localTime.getHour() % 12 && (n2 != 12 || localTime.getHour() % 12 != 0)) continue;
            this.hoursPointerRotate.setAngle(180.0 + Math.toDegrees(d6));
        }
        if (bl2) {
            d10 /= 1.6;
            for (n3 = 0; n3 < 12; ++n3) {
                n2 = (n3 + 3) % 12 == 0 ? 12 : (n3 + 3) % 12;
                label = new Label(Integer.toString(n2 += n2 == 12 ? -12 : 12) + (n2 == 0 ? "0" : ""));
                label.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.NORMAL, (double)10.0));
                label.setTextFill((Paint)(n2 == localTime.getHour() % 24 || n2 == 0 && localTime.getHour() % 24 == 0 && this.is24HourView ? Color.rgb((int)255, (int)255, (int)255, (double)0.54) : Color.rgb((int)0, (int)0, (int)0, (double)0.54)));
                this.selectedHourLabel.textProperty().addListener((observableValue, string, string2) -> {
                    if (Integer.parseInt(string2) == Integer.parseInt(label.getText())) {
                        label.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.54));
                    } else {
                        label.setTextFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.54));
                    }
                });
                stackPane = new StackPane();
                stackPane.getChildren().add((Object)label);
                d7 = circle.getRadius() / Math.sqrt(2.0) * 2.0;
                stackPane.setMinSize(d7, d7);
                d6 = (double)(2 * n3) * Math.PI / 12.0;
                d5 = d10 * Math.cos(d6);
                d4 = d10 * Math.sin(d6);
                d3 = this.contentCircleRadius + d5;
                d2 = this.contentCircleRadius + d4;
                stackPane.setLayoutX(d3 - stackPane.getMinWidth() / 2.0);
                stackPane.setLayoutY(d2 - stackPane.getMinHeight() / 2.0);
                pane.getChildren().add((Object)stackPane);
                if (n2 != localTime.getHour() % 24 && (n2 != 24 || localTime.getHour() % 24 != 0)) continue;
                this._24HourHoursPointerRotate.setAngle(180.0 + Math.toDegrees(d6));
            }
        }
        if (bl2) {
            return new StackPane(new Node[]{group, group2, pane});
        }
        return new StackPane(new Node[]{group, pane});
    }

    private StackPane createMinutesContent(LocalTime localTime) {
        StackPane stackPane = new StackPane();
        Circle circle = new Circle(this.contentCircleRadius / 6.0);
        circle.fillProperty().bind(this.timePicker.defaultColorProperty());
        Circle circle2 = new Circle(circle.getRadius() / 8.0);
        circle2.setFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
        circle2.setTranslateX(circle.getRadius() - circle2.getRadius());
        circle2.setVisible(localTime.getMinute() % 5 != 0);
        this.selectedMinLabel.textProperty().addListener((observableValue, string, string2) -> {
            if (Integer.parseInt(string2) % 5 == 0) {
                circle2.setVisible(false);
            } else {
                circle2.setVisible(true);
            }
        });
        double d2 = 9.0;
        Line line = new Line(d2, 0.0, this.contentCircleRadius, 0.0);
        line.fillProperty().bind(this.timePicker.defaultColorProperty());
        line.strokeProperty().bind((ObservableValue)line.fillProperty());
        line.setStrokeWidth(1.5);
        stackPane.getChildren().addAll((Object[])new Node[]{line, circle, circle2});
        StackPane.setAlignment((Node)circle, (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)circle2, (Pos)Pos.CENTER_LEFT);
        Group group = new Group();
        group.getChildren().add((Object)stackPane);
        group.setTranslateX((-this.contentCircleRadius + d2) / 2.0);
        this.minsPointerRotate = new Rotate(0.0, this.contentCircleRadius - d2, circle.getRadius());
        group.getTransforms().add((Object)this.minsPointerRotate);
        Pane pane = new Pane();
        double d3 = this.contentCircleRadius - d2 - circle.getRadius();
        for (int i2 = 0; i2 < 12; ++i2) {
            StackPane stackPane2 = new StackPane();
            int n2 = (i2 + 3) * 5 % 60;
            Label label = new Label(String.valueOf(this.unitConverter.toString((Number)n2)));
            label.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
            label.setTextFill((Paint)(n2 == localTime.getMinute() ? Color.rgb((int)255, (int)255, (int)255, (double)0.87) : Color.rgb((int)0, (int)0, (int)0, (double)0.87)));
            this.selectedMinLabel.textProperty().addListener((observableValue, string, string2) -> {
                if (Integer.parseInt(string2) == Integer.parseInt(label.getText())) {
                    label.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
                } else {
                    label.setTextFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.87));
                }
            });
            stackPane2.getChildren().add((Object)label);
            double d4 = circle.getRadius() / Math.sqrt(2.0) * 2.0;
            stackPane2.setMinSize(d4, d4);
            double d5 = (double)(2 * i2) * Math.PI / 12.0;
            double d6 = d3 * Math.cos(d5);
            double d7 = d3 * Math.sin(d5);
            double d8 = this.contentCircleRadius + d6;
            double d9 = this.contentCircleRadius + d7;
            stackPane2.setLayoutX(d8 - stackPane2.getMinWidth() / 2.0);
            stackPane2.setLayoutY(d9 - stackPane2.getMinHeight() / 2.0);
            pane.getChildren().add((Object)stackPane2);
        }
        this.minsPointerRotate.setAngle(180.0 + (double)((localTime.getMinute() + 45) % 60) * Math.toDegrees(0.10471975511965977));
        return new StackPane(new Node[]{group, pane});
    }

    ObjectProperty<LocalTime> displayedTimeProperty() {
        return this.selectedTime;
    }

    void init() {
        this.calendarPlaceHolder.setOpacity(1.0);
        if (this.unit.get() == TimeUnit.HOURS) {
            this.selectedHourLabel.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
        } else {
            this.selectedMinLabel.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
        }
    }

    private void swapLabelsColor(Label label, Label label2) {
        Paint paint = label.getTextFill();
        label.setTextFill(label2.getTextFill());
        label2.setTextFill(paint);
    }

    private void switchTimeUnit(TimeUnit timeUnit) {
        if (timeUnit == TimeUnit.HOURS) {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.minutesContent.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})});
            Timeline timeline2 = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.hoursContent.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
            new ParallelTransition(new Animation[]{timeline, timeline2}).play();
        } else {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.hoursContent.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})});
            Timeline timeline3 = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)this.minutesContent.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
            new ParallelTransition(new Animation[]{timeline, timeline3}).play();
        }
    }

    void updateValue() {
        if (this.is24HourView) {
            LocalTimeStringConverter localTimeStringConverter = new LocalTimeStringConverter(FormatStyle.SHORT, Locale.GERMAN);
            this.timePicker.setValue(localTimeStringConverter.fromString(this.selectedHourLabel.getText() + ":" + this.selectedMinLabel.getText()));
        } else {
            this.timePicker.setValue(LocalTime.parse(this.selectedHourLabel.getText() + ":" + this.selectedMinLabel.getText() + " " + (String)this.period.get(), DateTimeFormatter.ofPattern("h:mm a").withLocale(Locale.ENGLISH)));
        }
    }

    private void goToTime(LocalTime localTime) {
        if (localTime != null) {
            int n2 = localTime.getHour();
            this.selectedHourLabel.setText(Integer.toString(n2 % (this.is24HourView ? 24 : 12) == 0 ? (this.is24HourView ? 0 : 12) : n2 % (this.is24HourView ? 24 : 12)));
            this.selectedMinLabel.setText(this.unitConverter.toString((Number)localTime.getMinute()));
            if (!this.is24HourView) {
                this.period.set((Object)(n2 < 12 ? "AM" : "PM"));
            }
            this.minsPointerRotate.setAngle(180.0 + (double)((localTime.getMinute() + 45) % 60) * Math.toDegrees(0.10471975511965977));
            this.hoursPointerRotate.setAngle(180.0 + Math.toDegrees((double)(2 * (n2 - 3)) * Math.PI / 12.0));
            this._24HourHoursPointerRotate.setAngle(180.0 + Math.toDegrees((double)(2 * (n2 - 3)) * Math.PI / 12.0));
        }
    }

    void clearFocus() {
        LocalTime localTime = (LocalTime)this.timePicker.getValue();
        if (localTime == null) {
            localTime = LocalTime.now();
        }
        this.goToTime(localTime);
    }

    private static enum TimeUnit {
        HOURS,
        MINUTES;

    }
}

