/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.behavior.JFXGenericPickerBehavior;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.stage.WindowEventDispatcher;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public abstract class JFXGenericPickerSkin<T>
extends ComboBoxPopupControl<T> {
    private final EventHandler<MouseEvent> mouseEnteredEventHandler;
    private final EventHandler<MouseEvent> mousePressedEventHandler;
    private final EventHandler<MouseEvent> mouseReleasedEventHandler;
    private final EventHandler<MouseEvent> mouseExitedEventHandler;
    protected JFXGenericPickerBehavior<T> behavior;
    protected Pane arrowButton;
    protected PopupControl popup;
    private BiConsumer<String, EventType<?>> parentArrowEventHandlerTerminator = (string, eventType) -> {
        try {
            EventHandler eventHandler = (EventHandler)ReflectionHelper.getFieldContent(ComboBoxBaseSkin.class, (Object)this, string);
            this.arrowButton.removeEventHandler(eventType, eventHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    };
    private HashMap<String, Method> parentCachedMethods = new HashMap();
    Function<String, Method> methodSupplier = string -> {
        if (!this.parentCachedMethods.containsKey(string)) {
            try {
                Method method = ReflectionHelper.getMethod(ComboBoxPopupControl.class, string);
                this.parentCachedMethods.put((String)string, method);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.parentCachedMethods.get(string);
    };
    Consumer<Method> methodInvoker = method -> {
        try {
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    };
    Function<Method, Object> methodReturnInvoker = method -> {
        try {
            return method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    };

    public JFXGenericPickerSkin(ComboBoxBase<T> comboBoxBase) {
        super(comboBoxBase);
        this.behavior = new JFXGenericPickerBehavior<T>(comboBoxBase);
        this.removeParentFakeFocusListener(comboBoxBase);
        this.mouseEnteredEventHandler = mouseEvent -> this.behavior.mouseEntered((MouseEvent)mouseEvent);
        this.mousePressedEventHandler = mouseEvent -> {
            this.behavior.mousePressed((MouseEvent)mouseEvent);
            mouseEvent.consume();
        };
        this.mouseReleasedEventHandler = mouseEvent -> {
            this.behavior.mouseReleased((MouseEvent)mouseEvent);
            mouseEvent.consume();
        };
        this.mouseExitedEventHandler = mouseEvent -> this.behavior.mouseExited((MouseEvent)mouseEvent);
        this.arrowButton = (Pane)this.getChildren().get(0);
        this.parentArrowEventHandlerTerminator.accept("mouseEnteredEventHandler", MouseEvent.MOUSE_ENTERED);
        this.parentArrowEventHandlerTerminator.accept("mousePressedEventHandler", MouseEvent.MOUSE_PRESSED);
        this.parentArrowEventHandlerTerminator.accept("mouseReleasedEventHandler", MouseEvent.MOUSE_RELEASED);
        this.parentArrowEventHandlerTerminator.accept("mouseExitedEventHandler", MouseEvent.MOUSE_EXITED);
        this.unregisterChangeListeners((ObservableValue)comboBoxBase.editableProperty());
        this.updateArrowButtonListeners();
        this.registerChangeListener((ObservableValue)comboBoxBase.editableProperty(), observableValue -> {
            this.updateArrowButtonListeners();
            this.reflectUpdateDisplayArea();
        });
        this.removeParentPopupHandlers();
        this.popup = (PopupControl)ReflectionHelper.getFieldContent(ComboBoxPopupControl.class, (Object)this, "popup");
    }

    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    private void removeParentFakeFocusListener(ComboBoxBase<T> comboBoxBase) {
        try {
            ReadOnlyBooleanProperty readOnlyBooleanProperty = comboBoxBase.focusedProperty();
            ExpressionHelper expressionHelper = (ExpressionHelper)ReflectionHelper.getFieldContent(readOnlyBooleanProperty.getClass().getSuperclass(), readOnlyBooleanProperty, "helper");
            ChangeListener[] changeListenerArray = (ChangeListener[])ReflectionHelper.getFieldContent(expressionHelper.getClass(), expressionHelper, "changeListeners");
            for (int i2 = changeListenerArray.length - 1; i2 > 0; --i2) {
                if (changeListenerArray[i2] == null || !changeListenerArray[i2].getClass().getName().contains("ComboBoxPopupControl")) continue;
                readOnlyBooleanProperty.removeListener(changeListenerArray[i2]);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void removeParentPopupHandlers() {
        try {
            PopupControl popupControl = (PopupControl)ReflectionHelper.invoke(ComboBoxPopupControl.class, (Object)this, "getPopup");
            popupControl.setOnAutoHide(event -> this.behavior.onAutoHide(popupControl));
            WindowEventDispatcher windowEventDispatcher = (WindowEventDispatcher)ReflectionHelper.invoke(Window.class, popupControl, "getInternalEventDispatcher");
            Map map = (Map)ReflectionHelper.getFieldContent(EventHandlerManager.class, windowEventDispatcher.getEventHandlerManager(), "eventHandlerMap");
            map.remove(MouseEvent.MOUSE_CLICKED);
            popupControl.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> this.behavior.onAutoHide(popupControl));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateArrowButtonListeners() {
        if (((ComboBoxBase)this.getSkinnable()).isEditable()) {
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedEventHandler);
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEventHandler);
        } else {
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedEventHandler);
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEventHandler);
        }
    }

    protected void reflectUpdateDisplayArea() {
        this.methodInvoker.accept(this.methodSupplier.apply("updateDisplayArea"));
    }

    protected void reflectSetTextFromTextFieldIntoComboBoxValue() {
        this.methodInvoker.accept(this.methodSupplier.apply("setTextFromTextFieldIntoComboBoxValue"));
    }

    protected TextField reflectGetEditableInputNode() {
        return (TextField)this.methodReturnInvoker.apply(this.methodSupplier.apply("getEditableInputNode"));
    }

    protected void reflectUpdateDisplayNode() {
        this.methodInvoker.accept(this.methodSupplier.apply("updateDisplayNode"));
    }
}

