/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.GenericEditableTreeTableCell;
import java.util.function.Consumer;
import javafx.scene.input.MouseEvent;

public class OnPressedEditableTreeTableCell<S, T>
extends GenericEditableTreeTableCell<S, T> {
    public OnPressedEditableTreeTableCell() {
        this.init();
    }

    public OnPressedEditableTreeTableCell(EditorNodeBuilder editorNodeBuilder) {
        super(editorNodeBuilder);
        this.init();
    }

    public OnPressedEditableTreeTableCell(EditorNodeBuilder editorNodeBuilder, Consumer<Exception> consumer) {
        super(editorNodeBuilder, consumer);
        this.init();
    }

    private void init() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            OnPressedEditableTreeTableCell onPressedEditableTreeTableCell;
            if (this.getTreeTableView().getEditingCell() != null && !this.isEditing() && (onPressedEditableTreeTableCell = (OnPressedEditableTreeTableCell)((Object)((Object)this.getTreeTableView().getProperties().remove(OnPressedEditableTreeTableCell.class)))) != null) {
                onPressedEditableTreeTableCell.commitHelper(true);
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            if (!this.isEmpty() && this.isEditable() && !this.isEditing() && this.getTableColumn().isEditable()) {
                this.getTreeTableView().edit(this.getIndex(), this.getTableColumn());
            }
        });
    }

    @Override
    public void startEdit() {
        super.startEdit();
        if (this.isEditing()) {
            this.getTreeTableView().getProperties().put(OnPressedEditableTreeTableCell.class, (Object)this);
        }
    }

    public void commitEdit(T t2) {
        super.commitEdit(t2);
        this.getTreeTableView().getProperties().remove(OnPressedEditableTreeTableCell.class);
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.getTreeTableView().getProperties().remove(OnPressedEditableTreeTableCell.class);
    }
}

