/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.cells.editors.TextFieldEditorBuilder;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public class GenericEditableTableCell<S, T>
extends TableCell<S, T> {
    protected EditorNodeBuilder builder;
    protected Region editorNode;
    protected Consumer<Exception> commitExceptionConsumer = null;
    private BiFunction<Integer, Integer, Integer> stepFunction = (n2, n3) -> 0;

    public GenericEditableTableCell() {
        this(new TextFieldEditorBuilder());
    }

    public GenericEditableTableCell(EditorNodeBuilder editorNodeBuilder) {
        this(editorNodeBuilder, null);
    }

    public GenericEditableTableCell(EditorNodeBuilder editorNodeBuilder, Consumer<Exception> consumer) {
        this.builder = editorNodeBuilder;
        this.commitExceptionConsumer = consumer;
    }

    protected void commitHelper(boolean bl2) {
        block4: {
            if (this.editorNode == null) {
                return;
            }
            try {
                this.builder.validateValue();
                this.commitEdit(this.builder.getValue());
                this.builder.nullEditorNode();
                this.editorNode = null;
            }
            catch (Exception exception) {
                if (this.commitExceptionConsumer != null) {
                    this.commitExceptionConsumer.accept(exception);
                }
                if (!bl2) break block4;
                this.cancelEdit();
            }
        }
    }

    protected Object getValue() {
        return this.getItem();
    }

    public void startEdit() {
        if (this.isEditable()) {
            super.startEdit();
            this.getTableView().getFocusModel().focus(this.getTableRow().getIndex(), this.getTableColumn());
            if (this.editorNode == null) {
                this.createEditorNode();
            } else {
                this.builder.setValue(this.getValue());
            }
            this.builder.startEdit();
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }

    public void cancelEdit() {
        this.editorNode = null;
        super.cancelEdit();
        this.builder.cancelEdit();
        this.builder.setValue(this.getValue());
        this.builder.nullEditorNode();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void updateItem(T t2, boolean bl2) {
        super.updateItem(t2, bl2);
        if (bl2) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.editorNode != null) {
                this.builder.setValue(this.getValue());
            }
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.builder.updateItem(t2, bl2);
        } else {
            Object object = this.getValue();
            if (object instanceof Node) {
                this.setGraphic((Node)object);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(object == null ? null : String.valueOf(object));
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createEditorNode() {
        EventHandler eventHandler = keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.commitHelper(false);
            } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            } else if (keyEvent.getCode() == KeyCode.TAB) {
                this.commitHelper(false);
                this.editNext(!keyEvent.isShiftDown());
            }
        };
        ChangeListener changeListener = (observableValue, bl2, bl3) -> {
            if (this.editorNode != null && !bl3.booleanValue()) {
                this.commitHelper(true);
            }
        };
        this.editorNode = this.builder.createNode(this.getValue(), (EventHandler<KeyEvent>)eventHandler, (ChangeListener<Boolean>)changeListener);
    }

    public BiFunction<Integer, Integer, Integer> getStepFunction() {
        return this.stepFunction;
    }

    public void setStepFunction(BiFunction<Integer, Integer, Integer> biFunction) {
        this.stepFunction = biFunction;
    }

    private void editNext(boolean bl2) {
        ArrayList arrayList = new ArrayList();
        for (TableColumn tableColumn : this.getTableView().getColumns()) {
            arrayList.addAll(this.getLeaves(tableColumn));
        }
        int n2 = this.getIndex();
        int n3 = arrayList.indexOf(this.getTableColumn());
        if (bl2) {
            if (++n3 > arrayList.size() - 1) {
                n3 = 0;
                n2 += this.stepFunction.apply(n2, 1).intValue();
            }
        } else if (--n3 < 0) {
            n3 = arrayList.size() - 1;
            n2 += this.stepFunction.apply(n2, -1).intValue();
        }
        if (arrayList.size() < 2 && n2 == this.getIndex()) {
            return;
        }
        TableColumn tableColumn = (TableColumn)arrayList.get(n3);
        if (tableColumn != null) {
            this.getTableView().edit(n2, tableColumn);
            this.getTableView().scrollToColumn(tableColumn);
        }
    }

    private List<TableColumn<S, ?>> getLeaves(TableColumn<S, ?> tableColumn) {
        ArrayList arrayList = new ArrayList();
        if (tableColumn.getColumns().isEmpty()) {
            if (tableColumn.isEditable()) {
                arrayList.add(tableColumn);
            }
            return arrayList;
        }
        for (TableColumn tableColumn2 : tableColumn.getColumns()) {
            arrayList.addAll(this.getLeaves(tableColumn2));
        }
        return arrayList;
    }
}

