/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.httpclient.HttpClientProvider;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class OAuthService
implements Closeable {
    private final OAuthConfig config;
    private final HttpClient httpClient;

    public OAuthService(OAuthConfig oAuthConfig) {
        this.config = oAuthConfig;
        HttpClientConfig httpClientConfig = oAuthConfig.getHttpClientConfig();
        HttpClient httpClient = oAuthConfig.getHttpClient();
        this.httpClient = httpClientConfig == null && httpClient == null ? new JDKHttpClient(JDKHttpClientConfig.defaultConfig()) : (httpClient == null ? OAuthService.getClient(httpClientConfig) : httpClient);
    }

    private static HttpClient getClient(HttpClientConfig httpClientConfig) {
        for (HttpClientProvider httpClientProvider : ServiceLoader.load(HttpClientProvider.class)) {
            HttpClient httpClient = httpClientProvider.createClient(httpClientConfig);
            if (httpClient == null) continue;
            return httpClient;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public abstract String getVersion();

    public Future<Response> executeAsync(OAuthRequest oAuthRequest) {
        return this.execute(oAuthRequest, null);
    }

    public Future<Response> execute(OAuthRequest oAuthRequest, OAuthAsyncRequestCallback<Response> oAuthAsyncRequestCallback) {
        return this.execute(oAuthRequest, oAuthAsyncRequestCallback, null);
    }

    public <R> Future<R> execute(OAuthRequest oAuthRequest, OAuthAsyncRequestCallback<R> oAuthAsyncRequestCallback, OAuthRequest.ResponseConverter<R> responseConverter) {
        File file = oAuthRequest.getFilePayload();
        if (file != null) {
            return this.httpClient.executeAsync(this.config.getUserAgent(), oAuthRequest.getHeaders(), oAuthRequest.getVerb(), oAuthRequest.getCompleteUrl(), file, oAuthAsyncRequestCallback, responseConverter);
        }
        if (oAuthRequest.getStringPayload() != null) {
            return this.httpClient.executeAsync(this.config.getUserAgent(), oAuthRequest.getHeaders(), oAuthRequest.getVerb(), oAuthRequest.getCompleteUrl(), oAuthRequest.getStringPayload(), oAuthAsyncRequestCallback, responseConverter);
        }
        return this.httpClient.executeAsync(this.config.getUserAgent(), oAuthRequest.getHeaders(), oAuthRequest.getVerb(), oAuthRequest.getCompleteUrl(), oAuthRequest.getByteArrayPayload(), oAuthAsyncRequestCallback, responseConverter);
    }

    public Response execute(OAuthRequest oAuthRequest) throws InterruptedException, ExecutionException, IOException {
        File file = oAuthRequest.getFilePayload();
        if (file != null) {
            return this.httpClient.execute(this.config.getUserAgent(), oAuthRequest.getHeaders(), oAuthRequest.getVerb(), oAuthRequest.getCompleteUrl(), file);
        }
        if (oAuthRequest.getStringPayload() != null) {
            return this.httpClient.execute(this.config.getUserAgent(), oAuthRequest.getHeaders(), oAuthRequest.getVerb(), oAuthRequest.getCompleteUrl(), oAuthRequest.getStringPayload());
        }
        return this.httpClient.execute(this.config.getUserAgent(), oAuthRequest.getHeaders(), oAuthRequest.getVerb(), oAuthRequest.getCompleteUrl(), oAuthRequest.getByteArrayPayload());
    }
}

