/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.Serializable;

public abstract class NameTransformer {
    public static final NameTransformer NOP = new NopTransformer();

    protected NameTransformer() {
    }

    public static NameTransformer simpleTransformer(final String string, final String string2) {
        boolean bl2;
        boolean bl3 = string != null && !string.isEmpty();
        boolean bl4 = bl2 = string2 != null && !string2.isEmpty();
        if (bl3) {
            if (bl2) {
                return new NameTransformer(){

                    @Override
                    public String transform(String string3) {
                        return string + string3 + string2;
                    }

                    @Override
                    public String reverse(String string3) {
                        String string22;
                        if (string3.startsWith(string) && (string22 = string3.substring(string.length())).endsWith(string2)) {
                            return string22.substring(0, string22.length() - string2.length());
                        }
                        return null;
                    }

                    public String toString() {
                        return "[PreAndSuffixTransformer('" + string + "','" + string2 + "')]";
                    }
                };
            }
            return new NameTransformer(){

                @Override
                public String transform(String string2) {
                    return string + string2;
                }

                @Override
                public String reverse(String string2) {
                    if (string2.startsWith(string)) {
                        return string2.substring(string.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[PrefixTransformer('" + string + "')]";
                }
            };
        }
        if (bl2) {
            return new NameTransformer(){

                @Override
                public String transform(String string) {
                    return string + string2;
                }

                @Override
                public String reverse(String string) {
                    if (string.endsWith(string2)) {
                        return string.substring(0, string.length() - string2.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[SuffixTransformer('" + string2 + "')]";
                }
            };
        }
        return NOP;
    }

    public static NameTransformer chainedTransformer(NameTransformer nameTransformer, NameTransformer nameTransformer2) {
        return new Chained(nameTransformer, nameTransformer2);
    }

    public abstract String transform(String var1);

    public abstract String reverse(String var1);

    public static class Chained
    extends NameTransformer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final NameTransformer _t1;
        protected final NameTransformer _t2;

        public Chained(NameTransformer nameTransformer, NameTransformer nameTransformer2) {
            this._t1 = nameTransformer;
            this._t2 = nameTransformer2;
        }

        @Override
        public String transform(String string) {
            return this._t1.transform(this._t2.transform(string));
        }

        @Override
        public String reverse(String string) {
            if ((string = this._t1.reverse(string)) != null) {
                string = this._t2.reverse(string);
            }
            return string;
        }

        public String toString() {
            return "[ChainedTransformer(" + this._t1 + ", " + this._t2 + ")]";
        }
    }

    protected static final class NopTransformer
    extends NameTransformer
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected NopTransformer() {
        }

        @Override
        public String transform(String string) {
            return string;
        }

        @Override
        public String reverse(String string) {
            return string;
        }
    }
}

